/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.task;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.collections.map.HashedMap;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.SystemEventListenerFactory;
import org.drools.grid.NodeSelectionStrategy;
import org.drools.grid.generic.GenericConnection;
import org.drools.grid.generic.GenericMessageHandler;
import org.drools.grid.generic.GenericMessageHandlerImpl;
import org.drools.grid.generic.GenericNodeConnector;
import org.drools.grid.generic.NodeData;
import org.drools.grid.remote.mina.MinaAcceptor;
import org.drools.grid.remote.mina.MinaIoHandler;
import org.drools.grid.remote.mina.MinaNodeConnector;
import org.drools.grid.strategies.ReturnAlwaysTheFirstSelectionStrategy;
import org.drools.grid.task.BaseTaskServiceTest;
import org.drools.grid.task.CommandBasedServicesWSHumanTaskHandler;
import org.drools.grid.task.HumanTaskFactoryService;
import org.drools.grid.task.HumanTaskServiceProviderRemoteClient;
import org.drools.grid.task.TaskServerMessageHandlerImpl;
import org.drools.io.impl.ClassPathResource;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.task.Group;
import org.drools.task.MockUserInfo;
import org.drools.task.User;
import org.drools.task.UserInfo;
import org.drools.task.service.SendIcal;
import org.drools.task.service.TaskService;
import org.drools.task.service.TaskServiceSession;
import org.junit.After;
import org.junit.Before;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExpressionCompiler;

public class CommandBasedServicesWSHumanTaskHandlerTest
extends BaseTaskServiceTest {
    private MinaAcceptor server;
    private MinaAcceptor humanTaskServer;
    protected EntityManagerFactory emf;
    protected static TaskService taskService;
    protected TaskServiceSession taskSession;
    protected GenericNodeConnector htMinaClient;
    protected GenericNodeConnector minaClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUpTaskService() throws Exception {
        Properties conf = new Properties();
        conf.setProperty("mail.smtp.host", "localhost");
        conf.setProperty("mail.smtp.port", "2345");
        conf.setProperty("from", "from@domain.com");
        conf.setProperty("replyTo", "replyTo@domain.com");
        conf.setProperty("defaultLanguage", "en-UK");
        SendIcal.initInstance((Properties)conf);
        this.emf = Persistence.createEntityManagerFactory((String)"org.drools.task");
        taskService = new TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener());
        this.taskSession = taskService.createSession();
        MockUserInfo userInfo = new MockUserInfo();
        taskService.setUserinfo((UserInfo)userInfo);
        HashedMap vars = new HashedMap();
        Reader reader = null;
        try {
            reader = new InputStreamReader(new ClassPathResource("org/drools/task/LoadUsers.mvel").getInputStream());
            this.users = (Map)this.eval(reader, (Map)vars);
            for (User user : this.users.values()) {
                this.taskSession.addUser(user);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            reader = null;
        }
        try {
            reader = new InputStreamReader(new ClassPathResource("org/drools/task/LoadGroups.mvel").getInputStream());
            this.groups = (Map)this.eval(reader, (Map)vars);
            for (Group group : this.groups.values()) {
                this.taskSession.addGroup(group);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 9123);
        NodeData nodeData = new NodeData();
        NioSocketAcceptor acceptor = new NioSocketAcceptor();
        acceptor.setHandler((IoHandler)new MinaIoHandler(SystemEventListenerFactory.getSystemEventListener(), (GenericMessageHandler)new GenericMessageHandlerImpl(nodeData, SystemEventListenerFactory.getSystemEventListener())));
        this.server = new MinaAcceptor((SocketAcceptor)acceptor, (SocketAddress)address);
        this.server.start();
        Thread.sleep(5000L);
        InetSocketAddress htAddress = new InetSocketAddress("127.0.0.1", 9124);
        NioSocketAcceptor htAcceptor = new NioSocketAcceptor();
        htAcceptor.setHandler((IoHandler)new MinaIoHandler(SystemEventListenerFactory.getSystemEventListener(), (GenericMessageHandler)new TaskServerMessageHandlerImpl(taskService, SystemEventListenerFactory.getSystemEventListener())));
        this.humanTaskServer = new MinaAcceptor((SocketAcceptor)htAcceptor, (SocketAddress)htAddress);
        this.humanTaskServer.start();
        Thread.sleep(5000L);
        NioSocketConnector htclientConnector = new NioSocketConnector();
        htclientConnector.setHandler((IoHandler)new MinaIoHandler(SystemEventListenerFactory.getSystemEventListener()));
        this.htMinaClient = new MinaNodeConnector("client ht", (SocketConnector)htclientConnector, (SocketAddress)htAddress, SystemEventListenerFactory.getSystemEventListener());
        boolean connected = this.htMinaClient.connect();
        if (!connected) {
            throw new IllegalArgumentException("Could not connect task client");
        }
        NioSocketConnector clientConnector = new NioSocketConnector();
        clientConnector.setHandler((IoHandler)new MinaIoHandler(SystemEventListenerFactory.getSystemEventListener()));
        this.minaClient = new MinaNodeConnector("client SM", (SocketConnector)clientConnector, (SocketAddress)address, SystemEventListenerFactory.getSystemEventListener());
        this.connection.addNodeConnector(this.minaClient);
        this.node = this.connection.getExecutionNode((NodeSelectionStrategy)new ReturnAlwaysTheFirstSelectionStrategy((GenericConnection)this.connection));
        KnowledgeBase kbase = ((KnowledgeBaseFactoryService)this.node.get(KnowledgeBaseFactoryService.class)).newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        int sessionId = ksession.getId();
        this.node.set(HumanTaskFactoryService.class, (Object)new HumanTaskServiceProviderRemoteClient(this.htMinaClient, sessionId));
        this.humanTaskClient = ((HumanTaskFactoryService)this.node.get(HumanTaskFactoryService.class)).newHumanTaskService();
        this.handler = new CommandBasedServicesWSHumanTaskHandler((KnowledgeRuntime)ksession);
    }

    @After
    public void tearDown() throws Exception {
        this.humanTaskClient.disconnect();
        for (GenericNodeConnector connector : this.connection.getNodeConnectors()) {
            connector.disconnect();
        }
        this.handler.dispose();
        this.server.stop();
        this.humanTaskServer.stop();
        this.taskSession.dispose();
        this.emf.close();
    }

    public Object eval(Reader reader, Map vars) {
        try {
            return this.eval(this.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception Thrown", e);
        }
    }

    public String toString(Reader reader) throws IOException {
        int charValue;
        StringBuilder sb = new StringBuilder(1024);
        while ((charValue = reader.read()) != -1) {
            sb.append((char)charValue);
        }
        return sb.toString();
    }

    public Object eval(String str, Map vars) {
        ExpressionCompiler compiler = new ExpressionCompiler(str.trim());
        ParserContext context = new ParserContext();
        context.addPackageImport("org.drools.task");
        context.addPackageImport("org.drools.task.service");
        context.addPackageImport("org.drools.task.query");
        context.addPackageImport("java.util");
        vars.put("now", new Date());
        return MVEL.executeExpression((Object)compiler.compile(context), (Map)vars);
    }
}

