/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.task;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.drools.SystemEventListenerFactory;
import org.drools.eventmessaging.EventKey;
import org.drools.eventmessaging.Payload;
import org.drools.grid.generic.GenericNodeConnector;
import org.drools.grid.generic.Message;
import org.drools.grid.remote.mina.MinaIoHandler;
import org.drools.grid.remote.mina.MinaNodeConnector;
import org.drools.grid.task.HumanTaskServiceImpl;
import org.drools.grid.task.TaskClientMessageHandlerImpl;
import org.drools.grid.task.eventmessaging.EventMessageResponseHandler;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.task.AccessType;
import org.drools.task.Content;
import org.drools.task.Group;
import org.drools.task.I18NText;
import org.drools.task.PeopleAssignments;
import org.drools.task.SubTasksStrategy;
import org.drools.task.SubTasksStrategyFactory;
import org.drools.task.Task;
import org.drools.task.TaskData;
import org.drools.task.User;
import org.drools.task.event.TaskCompletedEvent;
import org.drools.task.event.TaskEvent;
import org.drools.task.event.TaskEventKey;
import org.drools.task.event.TaskFailedEvent;
import org.drools.task.event.TaskSkippedEvent;
import org.drools.task.service.Command;
import org.drools.task.service.ContentData;
import org.drools.task.service.responsehandlers.AbstractBaseResponseHandler;

public class CommandBasedServicesWSHumanTaskHandler
implements WorkItemHandler {
    private String ipAddress = "127.0.0.1";
    private int port = 9124;
    private SocketAddress address;
    private GenericNodeConnector connector;
    private HumanTaskServiceImpl client;
    private KnowledgeRuntime session;
    private Map<Long, Long> idMapping = new HashMap<Long, Long>();
    private Map<Long, WorkItemManager> managers = new HashMap<Long, WorkItemManager>();

    public CommandBasedServicesWSHumanTaskHandler(KnowledgeRuntime session) {
        this.session = session;
        this.address = new InetSocketAddress(this.ipAddress, this.port);
    }

    public void connect() throws RemoteException {
        if (this.connector == null) {
            NioSocketConnector htclientConnector = new NioSocketConnector();
            htclientConnector.setHandler((IoHandler)new MinaIoHandler(SystemEventListenerFactory.getSystemEventListener()));
            this.connector = new MinaNodeConnector("client ht", (SocketConnector)htclientConnector, this.address, SystemEventListenerFactory.getSystemEventListener());
            boolean connected = this.connector.connect();
            if (!connected) {
                throw new IllegalArgumentException("Could not connect task client");
            }
            int id = ((StatefulKnowledgeSession)this.session).getId();
            this.client = new HumanTaskServiceImpl(this.connector, id);
        }
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String groupId;
        String subTaskStrategiesCommaSeparated;
        String comment;
        try {
            this.connect();
        }
        catch (RemoteException ex) {
            Logger.getLogger(CommandBasedServicesWSHumanTaskHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        Task task = new Task();
        String taskName = (String)workItem.getParameter("TaskName");
        if (taskName != null) {
            ArrayList<I18NText> names = new ArrayList<I18NText>();
            names.add(new I18NText("en-UK", taskName));
            task.setNames(names);
        }
        if ((comment = (String)workItem.getParameter("Comment")) != null) {
            ArrayList<I18NText> descriptions = new ArrayList<I18NText>();
            descriptions.add(new I18NText("en-UK", comment));
            task.setDescriptions(descriptions);
            ArrayList<I18NText> subjects = new ArrayList<I18NText>();
            subjects.add(new I18NText("en-UK", comment));
            task.setSubjects(subjects);
        }
        String priorityString = (String)workItem.getParameter("Priority");
        int priority = 0;
        if (priorityString != null) {
            try {
                priority = new Integer(priorityString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        task.setPriority(priority);
        TaskData taskData = new TaskData();
        taskData.setWorkItemId(workItem.getId());
        taskData.setSkipable(!"false".equals(workItem.getParameter("Skippable")));
        Long parentId = (Long)workItem.getParameter("ParentId");
        if (parentId != null) {
            taskData.setParentId(parentId.longValue());
        }
        if ((subTaskStrategiesCommaSeparated = (String)workItem.getParameter("SubTaskStrategies")) != null && !subTaskStrategiesCommaSeparated.equals("")) {
            String[] subTaskStrategies = subTaskStrategiesCommaSeparated.split(",");
            ArrayList<SubTasksStrategy> strategies = new ArrayList<SubTasksStrategy>();
            for (String subTaskStrategyString : subTaskStrategies) {
                SubTasksStrategy subTaskStrategy = SubTasksStrategyFactory.newStrategy((String)subTaskStrategyString);
                strategies.add(subTaskStrategy);
            }
            task.setSubTaskStrategies(strategies);
        }
        PeopleAssignments assignments = new PeopleAssignments();
        ArrayList<Object> potentialOwners = new ArrayList<Object>();
        String actorId = (String)workItem.getParameter("ActorId");
        if (actorId != null) {
            String[] actorIds;
            for (String id : actorIds = actorId.split(",")) {
                User user = new User();
                user.setId(id.trim());
                potentialOwners.add(user);
            }
            if (potentialOwners.size() > 0) {
                taskData.setCreatedBy((User)potentialOwners.get(0));
            }
        }
        if ((groupId = (String)workItem.getParameter("GroupId")) != null) {
            String[] groupIds;
            for (String id : groupIds = groupId.split(",")) {
                potentialOwners.add(new Group(id));
            }
        }
        assignments.setPotentialOwners(potentialOwners);
        ArrayList<User> businessAdministrators = new ArrayList<User>();
        businessAdministrators.add(new User("Administrator"));
        assignments.setBusinessAdministrators(businessAdministrators);
        task.setPeopleAssignments(assignments);
        task.setTaskData(taskData);
        ContentData content = null;
        Object contentObject = workItem.getParameter("Content");
        if (contentObject != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream out = new ObjectOutputStream(bos);
                out.writeObject(contentObject);
                out.close();
                content = new ContentData();
                content.setContent(bos.toByteArray());
                content.setAccessType(AccessType.Inline);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        TaskWorkItemAddTaskMessageResponseHandler taskResponseHandler = new TaskWorkItemAddTaskMessageResponseHandler(workItem.getId(), this.managers, this.idMapping, manager);
        this.client.addTask(task, content, taskResponseHandler);
    }

    public void dispose() throws RemoteException {
        if (this.connector != null) {
            this.connector.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        Long taskId = this.idMapping.get(workItem.getId());
        if (taskId != null) {
            Map<Long, Long> map = this.idMapping;
            synchronized (map) {
                this.idMapping.remove(taskId);
            }
            map = this.managers;
            synchronized (map) {
                this.managers.remove(taskId);
            }
            this.client.skip(taskId, "Administrator", null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetResultContentMessageResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientMessageHandlerImpl.GetContentMessageResponseHandler {
        private Task task;
        private final WorkItemManager manager;
        private Map<String, Object> results;

        public GetResultContentMessageResponseHandler(WorkItemManager manager, Task task, Map<String, Object> results) {
            this.manager = manager;
            this.task = task;
            this.results = results;
        }

        public void receive(Message message) {
            Command cmd = (Command)message.getPayload();
            Content content = (Content)cmd.getArguments().get(0);
            ByteArrayInputStream bis = new ByteArrayInputStream(content.getContent());
            try {
                ObjectInputStream in = new ObjectInputStream(bis);
                Object result = in.readObject();
                in.close();
                this.results.put("Result", result);
                if (result instanceof Map) {
                    Map map = (Map)result;
                    for (Map.Entry entry : map.entrySet()) {
                        if (!(entry.getKey() instanceof String)) continue;
                        this.results.put((String)entry.getKey(), entry.getValue());
                    }
                }
                this.manager.completeWorkItem(this.task.getTaskData().getWorkItemId(), this.results);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void execute(Content content) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class GetCompletedTaskMessageResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler {
        private WorkItemManager manager;

        public GetCompletedTaskMessageResponseHandler(WorkItemManager manager) {
            this.manager = manager;
        }

        public void receive(Message message) {
            Command cmd = (Command)message.getPayload();
            Task task = (Task)cmd.getArguments().get(0);
            long workItemId = task.getTaskData().getWorkItemId();
            String userId = task.getTaskData().getActualOwner().getId();
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("ActorId", userId);
            long contentId = task.getTaskData().getOutputContentId();
            if (contentId != -1L) {
                GetResultContentMessageResponseHandler getContentResponseHandler = new GetResultContentMessageResponseHandler(this.manager, task, results);
                CommandBasedServicesWSHumanTaskHandler.this.client.getContent(contentId, getContentResponseHandler);
            } else {
                this.manager.completeWorkItem(workItemId, results);
            }
        }

        public void execute(Task task) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskCompletedMessageHandler
    extends AbstractBaseResponseHandler
    implements EventMessageResponseHandler {
        private long workItemId;
        private long taskId;
        private final Map<Long, WorkItemManager> managers;

        public TaskCompletedMessageHandler(long workItemId, long taskId, Map<Long, WorkItemManager> managers) {
            this.workItemId = workItemId;
            this.taskId = taskId;
            this.managers = managers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(Message message) {
            Command cmd = (Command)message.getPayload();
            Payload payload = (Payload)cmd.getArguments().get(0);
            TaskEvent event = (TaskEvent)payload.get();
            if (event.getTaskId() != this.taskId) {
                this.setError(new IllegalStateException("Expected task id and arrived task id do not march"));
                return;
            }
            if (event instanceof TaskCompletedEvent) {
                Map<Long, WorkItemManager> map = this.managers;
                synchronized (map) {
                    WorkItemManager manager = this.managers.get(this.taskId);
                    if (manager != null) {
                        GetCompletedTaskMessageResponseHandler getTaskResponseHandler = new GetCompletedTaskMessageResponseHandler(manager);
                        CommandBasedServicesWSHumanTaskHandler.this.client.getTask(this.taskId, getTaskResponseHandler);
                    }
                }
            }
            Map<Long, WorkItemManager> map = this.managers;
            synchronized (map) {
                WorkItemManager manager = this.managers.get(this.taskId);
                if (manager != null) {
                    manager.abortWorkItem(this.workItemId);
                }
            }
        }

        @Override
        public void execute(Payload payload) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TaskWorkItemAddTaskMessageResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientMessageHandlerImpl.AddTaskMessageResponseHandler {
        private Map<Long, WorkItemManager> managers;
        private Map<Long, Long> idMapping;
        private WorkItemManager manager;
        private long workItemId;

        public TaskWorkItemAddTaskMessageResponseHandler(long workItemId, Map<Long, WorkItemManager> managers, Map<Long, Long> idMapping, WorkItemManager manager) {
            this.workItemId = workItemId;
            this.managers = managers;
            this.idMapping = idMapping;
            this.manager = manager;
        }

        @Override
        public void execute(long taskId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(Message message) {
            Command command = (Command)message.getPayload();
            Long taskId = (Long)command.getArguments().get(0);
            Map<Long, Object> map = this.managers;
            synchronized (map) {
                this.managers.put(taskId, this.manager);
            }
            map = this.idMapping;
            synchronized (map) {
                this.idMapping.put(this.workItemId, taskId);
            }
            System.out.println("Created task " + taskId + " for work item " + this.workItemId);
            TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, taskId.longValue());
            TaskCompletedMessageHandler eventResponseHandler = new TaskCompletedMessageHandler(this.workItemId, taskId, this.managers);
            CommandBasedServicesWSHumanTaskHandler.this.client.registerForEvent((EventKey)key, true, eventResponseHandler);
            key = new TaskEventKey(TaskFailedEvent.class, taskId.longValue());
            CommandBasedServicesWSHumanTaskHandler.this.client.registerForEvent((EventKey)key, true, eventResponseHandler);
            key = new TaskEventKey(TaskSkippedEvent.class, taskId.longValue());
            CommandBasedServicesWSHumanTaskHandler.this.client.registerForEvent((EventKey)key, true, eventResponseHandler);
        }
    }
}

