/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.task;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.SystemEventListener;
import org.drools.eventmessaging.Payload;
import org.drools.grid.generic.GenericIoWriter;
import org.drools.grid.generic.GenericMessageHandler;
import org.drools.grid.generic.Message;
import org.drools.grid.generic.MessageResponseHandler;
import org.drools.grid.task.eventmessaging.EventMessageResponseHandler;
import org.drools.grid.task.responseHandlers.BlockingTaskSummaryMessageResponseHandler;
import org.drools.task.Content;
import org.drools.task.Task;
import org.drools.task.query.TaskSummary;
import org.drools.task.service.Command;

public class TaskClientMessageHandlerImpl
implements GenericMessageHandler {
    private SystemEventListener systemEventListener;
    protected Map<Integer, MessageResponseHandler> responseHandlers;

    public TaskClientMessageHandlerImpl(SystemEventListener systemEventListener) {
        this.systemEventListener = systemEventListener;
        this.responseHandlers = new ConcurrentHashMap<Integer, MessageResponseHandler>();
    }

    public void exceptionCaught(GenericIoWriter session, Throwable cause) throws Exception {
        this.systemEventListener.exception("Uncaught exception on client", cause);
    }

    public void messageReceived(GenericIoWriter session, Message msg) throws Exception {
        Command cmd = (Command)msg.getPayload();
        this.systemEventListener.debug("Message receieved redirected to the client 1111111111: " + cmd.getName());
        this.systemEventListener.debug("Arguments : " + Arrays.toString(cmd.getArguments().toArray()));
        switch (cmd.getName()) {
            case OperationResponse: {
                TaskOperationMessageResponseHandler responseHandler = (TaskOperationMessageResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.setIsDone(true);
                System.out.println("IS DONDEEEE");
                break;
            }
            case GetTaskResponse: {
                GetTaskMessageResponseHandler responseHandler = (GetTaskMessageResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                Task task = (Task)cmd.getArguments().get(0);
                responseHandler.execute(task);
                break;
            }
            case AddTaskResponse: {
                AddTaskMessageResponseHandler responseHandler = (AddTaskMessageResponseHandler)this.responseHandlers.remove(msg.getResponseId());
                System.out.println("response id searched: " + msg.getResponseId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                long taskId = (Long)cmd.getArguments().get(0);
                responseHandler.execute(taskId);
                break;
            }
            case AddCommentResponse: {
                AddCommentMessageResponseHandler responseHandler = (AddCommentMessageResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                long commentId = (Long)cmd.getArguments().get(0);
                responseHandler.execute(commentId);
                break;
            }
            case DeleteCommentResponse: {
                DeleteCommentMessageResponseHandler responseHandler = (DeleteCommentMessageResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.setIsDone(true);
                break;
            }
            case AddAttachmentResponse: {
                AddAttachmentMessageResponseHandler responseHandler = (AddAttachmentMessageResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                long attachmentId = (Long)cmd.getArguments().get(0);
                long contentId = (Long)cmd.getArguments().get(1);
                responseHandler.execute(attachmentId, contentId);
                break;
            }
            case DeleteAttachmentResponse: {
                DeleteAttachmentMessageResponseHandler responseHandler = (DeleteAttachmentMessageResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.setIsDone(true);
                break;
            }
            case GetContentResponse: {
                GetContentMessageResponseHandler responseHandler = (GetContentMessageResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                Content content = (Content)cmd.getArguments().get(0);
                responseHandler.execute(content);
                break;
            }
            case SetDocumentContentResponse: {
                SetDocumentMessageResponseHandler responseHandler = (SetDocumentMessageResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                long contentId = (Long)cmd.getArguments().get(0);
                responseHandler.execute(contentId);
                break;
            }
            case QueryTaskSummaryResponse: {
                BlockingTaskSummaryMessageResponseHandler responseHandler = (BlockingTaskSummaryMessageResponseHandler)this.responseHandlers.remove(msg.getResponseId());
                System.out.println("responseHandler: " + responseHandler + " id searched: " + msg.getResponseId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                List results = (List)cmd.getArguments().get(0);
                responseHandler.execute(results);
                break;
            }
            case EventTriggerResponse: {
                EventMessageResponseHandler responseHandler = (EventMessageResponseHandler)this.responseHandlers.remove(cmd.getId());
                System.out.println("EVENT TRIGGER RESPONSE " + responseHandler + " size " + this.responseHandlers.size() + " id " + cmd.getId());
                if (responseHandler == null) break;
                System.out.println("responseHandler---: " + responseHandler);
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    System.out.println("EEerror");
                    break;
                }
                Payload payload = (Payload)cmd.getArguments().get(0);
                System.out.println("EExecute ");
                responseHandler.execute(payload);
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TaskSummaryMessageResponseHandler
    extends MessageResponseHandler {
        public void execute(List<TaskSummary> var1);
    }

    public static interface GetContentMessageResponseHandler
    extends MessageResponseHandler {
        public void execute(Content var1);
    }

    public static interface SetDocumentMessageResponseHandler
    extends MessageResponseHandler {
        public void execute(long var1);
    }

    public static interface DeleteAttachmentMessageResponseHandler
    extends MessageResponseHandler {
        public void setIsDone(boolean var1);
    }

    public static interface AddAttachmentMessageResponseHandler
    extends MessageResponseHandler {
        public void execute(long var1, long var3);
    }

    public static interface DeleteCommentMessageResponseHandler
    extends MessageResponseHandler {
        public void setIsDone(boolean var1);
    }

    public static interface AddCommentMessageResponseHandler
    extends MessageResponseHandler {
        public void execute(long var1);
    }

    public static interface TaskOperationMessageResponseHandler
    extends MessageResponseHandler {
        public void setIsDone(boolean var1);
    }

    public static interface AddTaskMessageResponseHandler
    extends MessageResponseHandler {
        public void execute(long var1);
    }

    public static interface GetTaskMessageResponseHandler
    extends MessageResponseHandler {
        public void execute(Task var1);
    }
}

