/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.models.commons.backend.rule;

import com.thoughtworks.xstream.XStream;
import java.util.List;
import org.drools.guvnor.models.commons.shared.rule.ActionRetractFact;
import org.drools.guvnor.models.commons.shared.rule.ActionSetField;
import org.drools.guvnor.models.commons.shared.rule.CompositeFactPattern;
import org.drools.guvnor.models.commons.shared.rule.CompositeFieldConstraint;
import org.drools.guvnor.models.commons.shared.rule.DSLSentence;
import org.drools.guvnor.models.commons.shared.rule.ExpressionField;
import org.drools.guvnor.models.commons.shared.rule.ExpressionPart;
import org.drools.guvnor.models.commons.shared.rule.FactPattern;
import org.drools.guvnor.models.commons.shared.rule.FieldConstraint;
import org.drools.guvnor.models.commons.shared.rule.FromCompositeFactPattern;
import org.drools.guvnor.models.commons.shared.rule.IAction;
import org.drools.guvnor.models.commons.shared.rule.IPattern;
import org.drools.guvnor.models.commons.shared.rule.RuleAttribute;
import org.drools.guvnor.models.commons.shared.rule.RuleMetadata;
import org.drools.guvnor.models.commons.shared.rule.RuleModel;
import org.drools.guvnor.models.commons.shared.rule.SingleFieldConstraint;
import org.drools.guvnor.models.commons.shared.rule.SingleFieldConstraintEBLeftSide;
import org.junit.Assert;
import org.junit.Test;

public class RuleModelTest {
    @Test
    public void testAddItemLhs() {
        RuleModel model = new RuleModel();
        FactPattern x = new FactPattern();
        model.addLhsItem((IPattern)x);
        Assert.assertEquals((long)1L, (long)model.lhs.length);
        FactPattern y = new FactPattern();
        model.addLhsItem((IPattern)y);
        Assert.assertEquals((long)2L, (long)model.lhs.length);
        Assert.assertEquals((Object)x, (Object)model.lhs[0]);
        Assert.assertEquals((Object)y, (Object)model.lhs[1]);
    }

    @Test
    public void testAddItemRhs() {
        RuleModel model = new RuleModel();
        ActionSetField a0 = new ActionSetField();
        ActionSetField a1 = new ActionSetField();
        model.addRhsItem((IAction)a0);
        Assert.assertEquals((long)1L, (long)model.rhs.length);
        model.addRhsItem((IAction)a1);
        Assert.assertEquals((long)2L, (long)model.rhs.length);
        Assert.assertEquals((Object)a0, (Object)model.rhs[0]);
        Assert.assertEquals((Object)a1, (Object)model.rhs[1]);
    }

    @Test
    public void testAllVariableBindings() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[2];
        FactPattern x = new FactPattern("Car");
        model.lhs[0] = x;
        x.setBoundName("boundFact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("q");
        x.addConstraint((FieldConstraint)sfc);
        sfc.setFieldBinding("field1");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("q");
        x.addConstraint((FieldConstraint)sfc2);
        sfc2.setFieldBinding("field2");
        model.lhs[1] = new CompositeFactPattern();
        List vars = model.getAllVariables();
        Assert.assertEquals((long)3L, (long)vars.size());
        Assert.assertEquals((Object)"boundFact", vars.get(0));
        Assert.assertEquals((Object)"field1", vars.get(1));
        Assert.assertEquals((Object)"field2", vars.get(2));
        Assert.assertTrue((boolean)model.isVariableNameUsed("field2"));
    }

    @Test
    public void testAllVariableBindings2() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[1];
        FactPattern fp = new FactPattern("Car");
        model.lhs[0] = fp;
        fp.setBoundName("$c");
        SingleFieldConstraintEBLeftSide sfc = new SingleFieldConstraintEBLeftSide("make");
        sfc.getExpressionValue().appendPart((ExpressionPart)new ExpressionField("make", "java.lang.String", "String"));
        sfc.setFieldBinding("$m");
        fp.addConstraint((FieldConstraint)sfc);
        List vars = model.getAllVariables();
        Assert.assertEquals((long)2L, (long)vars.size());
        Assert.assertEquals((Object)"$c", vars.get(0));
        Assert.assertEquals((Object)"$m", vars.get(1));
    }

    @Test
    public void testAttributes() {
        RuleModel m = new RuleModel();
        RuleAttribute at = new RuleAttribute("salience", "42");
        m.addAttribute(at);
        Assert.assertEquals((long)1L, (long)m.attributes.length);
        Assert.assertEquals((Object)at, (Object)m.attributes[0]);
        RuleAttribute at2 = new RuleAttribute("agenda-group", "x");
        m.addAttribute(at2);
        Assert.assertEquals((long)2L, (long)m.attributes.length);
        Assert.assertEquals((Object)at2, (Object)m.attributes[1]);
        m.removeAttribute(0);
        Assert.assertEquals((long)1L, (long)m.attributes.length);
        Assert.assertEquals((Object)at2, (Object)m.attributes[0]);
    }

    @Test
    public void testBoundFactFinder() {
        RuleModel model = new RuleModel();
        Assert.assertNull((Object)model.getLHSBoundFact("x"));
        model.lhs = new IPattern[3];
        FactPattern x = new FactPattern("Car");
        model.lhs[0] = x;
        x.setBoundName("x");
        Assert.assertNotNull((Object)model.getLHSBoundFact("x"));
        Assert.assertEquals((Object)x, (Object)model.getLHSBoundFact("x"));
        FactPattern y = new FactPattern("Car");
        model.lhs[1] = y;
        y.setBoundName("y");
        FactPattern other = new FactPattern("House");
        model.lhs[2] = other;
        Assert.assertEquals((Object)y, (Object)model.getLHSBoundFact("y"));
        Assert.assertEquals((Object)x, (Object)model.getLHSBoundFact("x"));
        model.rhs = new IAction[1];
        ActionSetField set = new ActionSetField();
        set.setVariable("x");
        model.rhs[0] = set;
        Assert.assertTrue((boolean)model.isBoundFactUsed("x"));
        Assert.assertFalse((boolean)model.isBoundFactUsed("y"));
        Assert.assertEquals((long)3L, (long)model.lhs.length);
        Assert.assertFalse((boolean)model.removeLhsItem(0));
        Assert.assertEquals((long)3L, (long)model.lhs.length);
        ActionRetractFact fact = new ActionRetractFact("q");
        model.rhs[0] = fact;
        Assert.assertTrue((boolean)model.isBoundFactUsed("q"));
        Assert.assertFalse((boolean)model.isBoundFactUsed("x"));
        XStream xt = new XStream();
        xt.alias("rule", RuleModel.class);
        xt.alias("fact", FactPattern.class);
        xt.alias("retract", ActionRetractFact.class);
        xt.aliasPackage("org.drools.guvnor.client", "org.drools.ide.common.client");
        String brl = xt.toXML((Object)model);
        System.out.println(brl);
    }

    @Test
    public void testGetVariableNameForRHS() {
        RuleModel m = new RuleModel();
        m.name = "blah";
        FactPattern pat = new FactPattern("Person");
        pat.setBoundName("pat");
        m.addLhsItem((IPattern)pat);
        List l = m.getAllVariables();
        Assert.assertEquals((long)1L, (long)l.size());
        Assert.assertEquals((Object)"pat", l.get(0));
    }

    @Test
    public void testIsDSLEnhanced() throws Exception {
        RuleModel m = new RuleModel();
        Assert.assertFalse((boolean)m.hasDSLSentences());
        m.addLhsItem((IPattern)new FactPattern());
        Assert.assertFalse((boolean)m.hasDSLSentences());
        m.addRhsItem((IAction)new ActionSetField("q"));
        Assert.assertFalse((boolean)m.hasDSLSentences());
        m.addLhsItem((IPattern)new DSLSentence());
        Assert.assertTrue((boolean)m.hasDSLSentences());
        m.addRhsItem((IAction)new DSLSentence());
        Assert.assertTrue((boolean)m.hasDSLSentences());
        m = new RuleModel();
        m.addLhsItem((IPattern)new DSLSentence());
        Assert.assertTrue((boolean)m.hasDSLSentences());
        m = new RuleModel();
        m.addRhsItem((IAction)new DSLSentence());
        Assert.assertTrue((boolean)m.hasDSLSentences());
    }

    @Test
    public void testMetaData() {
        RuleModel m = new RuleModel();
        RuleMetadata rm = new RuleMetadata("foo", "bar");
        m.addMetadata(rm);
        Assert.assertEquals((long)1L, (long)m.metadataList.length);
        Assert.assertEquals((Object)rm, (Object)m.metadataList[0]);
        RuleMetadata gm = m.getMetaData("foo");
        Assert.assertNotNull((Object)gm);
        RuleMetadata rm2 = new RuleMetadata("foo2", "bar2");
        m.addMetadata(rm2);
        Assert.assertEquals((long)2L, (long)m.metadataList.length);
        Assert.assertEquals((Object)rm2, (Object)m.metadataList[1]);
        Assert.assertEquals((Object)"@foo(bar)", (Object)rm.toString());
        m.removeMetadata(0);
        Assert.assertEquals((long)1L, (long)m.metadataList.length);
        Assert.assertEquals((Object)rm2, (Object)m.metadataList[0]);
        Assert.assertEquals((Object)"@foo2(bar2)", (Object)m.metadataList[0].toString());
        gm = m.getMetaData("foo");
        Assert.assertNull((Object)gm);
        m.updateMetadata(rm);
        gm = m.getMetaData("foo");
        Assert.assertNotNull((Object)gm);
        rm.setValue("bar2");
        m.updateMetadata(rm);
        gm = m.getMetaData("foo");
        Assert.assertNotNull((Object)gm);
        Assert.assertEquals((Object)"bar2", (Object)gm.getValue());
    }

    @Test
    public void testRemoveItemLhs() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[3];
        FactPattern x = new FactPattern("Car");
        model.lhs[0] = x;
        x.setBoundName("x");
        FactPattern y = new FactPattern("Car");
        model.lhs[1] = y;
        y.setBoundName("y");
        FactPattern other = new FactPattern("House");
        model.lhs[2] = other;
        Assert.assertEquals((long)3L, (long)model.lhs.length);
        Assert.assertEquals((Object)x, (Object)model.lhs[0]);
        model.removeLhsItem(0);
        Assert.assertEquals((long)2L, (long)model.lhs.length);
        Assert.assertEquals((Object)y, (Object)model.lhs[0]);
    }

    @Test
    public void testRemoveItemRhs() {
        RuleModel model = new RuleModel();
        model.rhs = new IAction[3];
        ActionRetractFact r0 = new ActionRetractFact("x");
        ActionRetractFact r1 = new ActionRetractFact("y");
        ActionRetractFact r2 = new ActionRetractFact("z");
        model.rhs[0] = r0;
        model.rhs[1] = r1;
        model.rhs[2] = r2;
        model.removeRhsItem(1);
        Assert.assertEquals((long)2L, (long)model.rhs.length);
        Assert.assertEquals((Object)r0, (Object)model.rhs[0]);
        Assert.assertEquals((Object)r2, (Object)model.rhs[1]);
    }

    @Test
    public void testScopedVariablesWithCompositeFact() {
        RuleModel m = new RuleModel();
        FactPattern p = new FactPattern();
        CompositeFieldConstraint cf = new CompositeFieldConstraint();
        cf.addConstraint((FieldConstraint)new SingleFieldConstraint("x"));
        p.addConstraint((FieldConstraint)cf);
        SingleFieldConstraint sf = new SingleFieldConstraint("q");
        sf.setFieldBinding("abc");
        p.addConstraint((FieldConstraint)sf);
        SingleFieldConstraint sf2 = new SingleFieldConstraint("q");
        sf2.setFieldBinding("qed");
        cf.addConstraint((FieldConstraint)sf2);
        m.addLhsItem((IPattern)p);
        List vars = m.getAllVariables();
        Assert.assertEquals((long)1L, (long)vars.size());
        Assert.assertEquals((Object)"abc", vars.get(0));
    }

    @Test
    public void testAddItemLhsAtSpecificPosition() {
        RuleModel model = new RuleModel();
        FactPattern a = new FactPattern();
        model.addLhsItem((IPattern)a);
        Assert.assertEquals((long)1L, (long)model.lhs.length);
        FactPattern b = new FactPattern();
        model.addLhsItem((IPattern)b);
        Assert.assertEquals((long)2L, (long)model.lhs.length);
        FactPattern c = new FactPattern();
        model.addLhsItem((IPattern)c, true);
        Assert.assertEquals((long)3L, (long)model.lhs.length);
        Assert.assertEquals((Object)a, (Object)model.lhs[0]);
        Assert.assertEquals((Object)b, (Object)model.lhs[1]);
        Assert.assertEquals((Object)c, (Object)model.lhs[2]);
        FactPattern d = new FactPattern();
        model.addLhsItem((IPattern)d, false);
        Assert.assertEquals((long)4L, (long)model.lhs.length);
        Assert.assertEquals((Object)d, (Object)model.lhs[0]);
        Assert.assertEquals((Object)a, (Object)model.lhs[1]);
        Assert.assertEquals((Object)b, (Object)model.lhs[2]);
        Assert.assertEquals((Object)c, (Object)model.lhs[3]);
        FactPattern e = new FactPattern();
        model.addLhsItem((IPattern)e, 2);
        Assert.assertEquals((long)5L, (long)model.lhs.length);
        Assert.assertEquals((Object)d, (Object)model.lhs[0]);
        Assert.assertEquals((Object)a, (Object)model.lhs[1]);
        Assert.assertEquals((Object)e, (Object)model.lhs[2]);
        Assert.assertEquals((Object)b, (Object)model.lhs[3]);
        Assert.assertEquals((Object)c, (Object)model.lhs[4]);
        FactPattern f = new FactPattern();
        FactPattern g = new FactPattern();
        model.addLhsItem((IPattern)f, -1);
        model.addLhsItem((IPattern)g, 100);
        Assert.assertEquals((long)7L, (long)model.lhs.length);
        Assert.assertEquals((Object)f, (Object)model.lhs[0]);
        Assert.assertEquals((Object)d, (Object)model.lhs[1]);
        Assert.assertEquals((Object)a, (Object)model.lhs[2]);
        Assert.assertEquals((Object)e, (Object)model.lhs[3]);
        Assert.assertEquals((Object)b, (Object)model.lhs[4]);
        Assert.assertEquals((Object)c, (Object)model.lhs[5]);
        Assert.assertEquals((Object)g, (Object)model.lhs[6]);
        model.moveLhsItemDown(5);
        model.moveLhsItemUp(3);
        Assert.assertEquals((long)7L, (long)model.lhs.length);
        Assert.assertEquals((Object)f, (Object)model.lhs[0]);
        Assert.assertEquals((Object)d, (Object)model.lhs[1]);
        Assert.assertEquals((Object)e, (Object)model.lhs[2]);
        Assert.assertEquals((Object)a, (Object)model.lhs[3]);
        Assert.assertEquals((Object)b, (Object)model.lhs[4]);
        Assert.assertEquals((Object)g, (Object)model.lhs[5]);
        Assert.assertEquals((Object)c, (Object)model.lhs[6]);
        model.moveLhsItemUp(0);
        model.moveLhsItemDown(6);
        Assert.assertEquals((long)7L, (long)model.lhs.length);
        Assert.assertEquals((Object)f, (Object)model.lhs[0]);
        Assert.assertEquals((Object)d, (Object)model.lhs[1]);
        Assert.assertEquals((Object)e, (Object)model.lhs[2]);
        Assert.assertEquals((Object)a, (Object)model.lhs[3]);
        Assert.assertEquals((Object)b, (Object)model.lhs[4]);
        Assert.assertEquals((Object)g, (Object)model.lhs[5]);
        Assert.assertEquals((Object)c, (Object)model.lhs[6]);
    }

    @Test
    public void testAddItemRhsAtSpecificPosition() {
        RuleModel model = new RuleModel();
        ActionSetField a = new ActionSetField();
        model.addRhsItem((IAction)a);
        Assert.assertEquals((long)1L, (long)model.rhs.length);
        ActionSetField b = new ActionSetField();
        model.addRhsItem((IAction)b);
        Assert.assertEquals((long)2L, (long)model.rhs.length);
        ActionSetField c = new ActionSetField();
        model.addRhsItem((IAction)c, true);
        Assert.assertEquals((long)3L, (long)model.rhs.length);
        Assert.assertEquals((Object)a, (Object)model.rhs[0]);
        Assert.assertEquals((Object)b, (Object)model.rhs[1]);
        Assert.assertEquals((Object)c, (Object)model.rhs[2]);
        ActionSetField d = new ActionSetField();
        model.addRhsItem((IAction)d, false);
        Assert.assertEquals((long)4L, (long)model.rhs.length);
        Assert.assertEquals((Object)d, (Object)model.rhs[0]);
        Assert.assertEquals((Object)a, (Object)model.rhs[1]);
        Assert.assertEquals((Object)b, (Object)model.rhs[2]);
        Assert.assertEquals((Object)c, (Object)model.rhs[3]);
        ActionSetField e = new ActionSetField();
        model.addRhsItem((IAction)e, 2);
        Assert.assertEquals((long)5L, (long)model.rhs.length);
        Assert.assertEquals((Object)d, (Object)model.rhs[0]);
        Assert.assertEquals((Object)a, (Object)model.rhs[1]);
        Assert.assertEquals((Object)e, (Object)model.rhs[2]);
        Assert.assertEquals((Object)b, (Object)model.rhs[3]);
        Assert.assertEquals((Object)c, (Object)model.rhs[4]);
        ActionSetField f = new ActionSetField();
        ActionSetField g = new ActionSetField();
        model.addRhsItem((IAction)f, -1);
        model.addRhsItem((IAction)g, 100);
        Assert.assertEquals((long)7L, (long)model.rhs.length);
        Assert.assertEquals((Object)f, (Object)model.rhs[0]);
        Assert.assertEquals((Object)d, (Object)model.rhs[1]);
        Assert.assertEquals((Object)a, (Object)model.rhs[2]);
        Assert.assertEquals((Object)e, (Object)model.rhs[3]);
        Assert.assertEquals((Object)b, (Object)model.rhs[4]);
        Assert.assertEquals((Object)c, (Object)model.rhs[5]);
        Assert.assertEquals((Object)g, (Object)model.rhs[6]);
        model.moveRhsItemDown(5);
        model.moveRhsItemUp(3);
        Assert.assertEquals((long)7L, (long)model.rhs.length);
        Assert.assertEquals((Object)f, (Object)model.rhs[0]);
        Assert.assertEquals((Object)d, (Object)model.rhs[1]);
        Assert.assertEquals((Object)e, (Object)model.rhs[2]);
        Assert.assertEquals((Object)a, (Object)model.rhs[3]);
        Assert.assertEquals((Object)b, (Object)model.rhs[4]);
        Assert.assertEquals((Object)g, (Object)model.rhs[5]);
        Assert.assertEquals((Object)c, (Object)model.rhs[6]);
        model.moveRhsItemUp(0);
        model.moveRhsItemDown(6);
        Assert.assertEquals((long)7L, (long)model.rhs.length);
        Assert.assertEquals((Object)f, (Object)model.rhs[0]);
        Assert.assertEquals((Object)d, (Object)model.rhs[1]);
        Assert.assertEquals((Object)e, (Object)model.rhs[2]);
        Assert.assertEquals((Object)a, (Object)model.rhs[3]);
        Assert.assertEquals((Object)b, (Object)model.rhs[4]);
        Assert.assertEquals((Object)g, (Object)model.rhs[5]);
        Assert.assertEquals((Object)c, (Object)model.rhs[6]);
    }

    @Test
    public void testBoundFromCompositeFactFinder() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[1];
        FromCompositeFactPattern fcfp = new FromCompositeFactPattern();
        FactPattern x = new FactPattern("Car");
        x.setBoundName("x");
        SingleFieldConstraint a = new SingleFieldConstraint("name");
        a.setFieldBinding("a");
        a.setFieldType("String");
        x.addConstraint((FieldConstraint)a);
        fcfp.setFactPattern(x);
        model.lhs[0] = fcfp;
        Assert.assertEquals((Object)x, (Object)model.getLHSBoundFact("x"));
        Assert.assertEquals((long)1L, (long)model.getLHSBoundFacts().size());
        Assert.assertEquals((Object)"x", model.getLHSBoundFacts().get(0));
        Assert.assertEquals((Object)a, (Object)model.getLHSBoundField("a"));
        Assert.assertEquals((Object)"Car", (Object)model.getLHSBindingType("x"));
        Assert.assertEquals((Object)"String", (Object)model.getLHSBindingType("a"));
        Assert.assertEquals((Object)x, (Object)model.getLHSParentFactPatternForBinding("a"));
        Assert.assertEquals((long)2L, (long)model.getAllLHSVariables().size());
        Assert.assertTrue((boolean)model.getAllLHSVariables().contains("x"));
        Assert.assertTrue((boolean)model.getAllLHSVariables().contains("a"));
        model.rhs = new IAction[1];
        ActionSetField set = new ActionSetField();
        set.setVariable("x");
        model.rhs[0] = set;
        Assert.assertTrue((boolean)model.isBoundFactUsed("x"));
        Assert.assertEquals((long)1L, (long)model.lhs.length);
        Assert.assertFalse((boolean)model.removeLhsItem(0));
        Assert.assertEquals((long)1L, (long)model.lhs.length);
    }
}

