/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integration.console;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.definition.process.Process;
import org.drools.integration.console.DroolsFlowCommandDelegate;
import org.drools.integration.console.DroolsFlowTransform;
import org.drools.process.audit.ProcessInstanceLog;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.server.integration.ProcessManagement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsFlowProcessManagement
implements ProcessManagement {
    private DroolsFlowCommandDelegate delegate = new DroolsFlowCommandDelegate();

    public List<ProcessDefinitionRef> getProcessDefinitions() {
        List<Process> processes = this.delegate.getProcesses();
        ArrayList<ProcessDefinitionRef> result = new ArrayList<ProcessDefinitionRef>();
        for (Process process : processes) {
            result.add(DroolsFlowTransform.processDefinition(process));
        }
        return result;
    }

    public ProcessDefinitionRef getProcessDefinition(String definitionId) {
        Process process = this.delegate.getProcess(definitionId);
        return DroolsFlowTransform.processDefinition(process);
    }

    public List<ProcessDefinitionRef> removeProcessDefinition(String definitionId) {
        this.delegate.removeProcess(definitionId);
        return this.getProcessDefinitions();
    }

    public ProcessInstanceRef getProcessInstance(String instanceId) {
        ProcessInstanceLog processInstance = this.delegate.getProcessInstanceLog(instanceId);
        return DroolsFlowTransform.processInstance(processInstance);
    }

    public List<ProcessInstanceRef> getProcessInstances(String definitionId) {
        List<ProcessInstanceLog> processInstances = this.delegate.getProcessInstanceLogsByProcessId(definitionId);
        ArrayList<ProcessInstanceRef> result = new ArrayList<ProcessInstanceRef>();
        for (ProcessInstanceLog processInstance : processInstances) {
            if (processInstance.getEnd() != null) continue;
            result.add(DroolsFlowTransform.processInstance(processInstance));
        }
        return result;
    }

    public ProcessInstanceRef newInstance(String definitionId) {
        return this.newInstance(definitionId, null);
    }

    public ProcessInstanceRef newInstance(String definitionId, Map<String, Object> processVars) {
        ProcessInstanceLog processInstance = this.delegate.startProcess(definitionId, processVars);
        return DroolsFlowTransform.processInstance(processInstance);
    }

    public void setProcessState(String instanceId, ProcessInstanceRef.STATE nextState) {
        if (nextState != ProcessInstanceRef.STATE.ENDED) {
            throw new UnsupportedOperationException();
        }
        this.delegate.abortProcessInstance(instanceId);
    }

    public Map<String, Object> getInstanceData(String instanceId) {
        return this.delegate.getProcessInstanceVariables(instanceId);
    }

    public void setInstanceData(String instanceId, Map<String, Object> data) {
        this.delegate.setProcessInstanceVariables(instanceId, data);
    }

    public void signalExecution(String executionId, String signal) {
        this.delegate.signalExecution(executionId, signal);
    }

    public void deleteInstance(String instanceId) {
        this.delegate.abortProcessInstance(instanceId);
    }

    public void endInstance(String instanceId, ProcessInstanceRef.RESULT result) {
        this.delegate.abortProcessInstance(instanceId);
    }
}

