/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integration.console;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentFactory;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.process.Process;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.io.ResourceFactory;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.process.audit.ProcessInstanceDbLog;
import org.drools.process.audit.ProcessInstanceLog;
import org.drools.process.audit.WorkingMemoryDbLogger;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.process.workitem.wsht.CommandBasedWSHumanTaskHandler;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.workflow.instance.impl.WorkflowProcessInstanceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsFlowCommandDelegate {
    private static StatefulKnowledgeSession ksession;

    public DroolsFlowCommandDelegate() {
        this.getSession();
    }

    private StatefulKnowledgeSession newStatefulKnowledgeSession() {
        try {
            KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"Guvnor default");
            kagent.applyChangeSet(ResourceFactory.newClassPathResource((String)"ChangeSet.xml"));
            kagent.monitorResourceChangeEvents(false);
            KnowledgeBase kbase = kagent.getKnowledgeBase();
            StatefulKnowledgeSession ksession = null;
            EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa");
            Environment env = KnowledgeBaseFactory.newEnvironment();
            env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
            try {
                System.out.println("Loading session data ...");
                ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)1, (KnowledgeBase)kbase, null, (Environment)env);
            }
            catch (RuntimeException e) {
                System.out.println("Error loading session data: " + e.getMessage());
                if (e instanceof IllegalStateException) {
                    Throwable cause = ((IllegalStateException)e).getCause();
                    if (cause instanceof InvocationTargetException) {
                        if ((cause = cause.getCause()) != null && "Could not find session data for id 1".equals(cause.getMessage())) {
                            System.out.println("Creating new session data ...");
                            ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
                        }
                        System.err.println("Error loading session data: " + cause);
                        throw e;
                    }
                    System.err.println("Error loading session data: " + cause);
                    throw e;
                }
                System.err.println("Error loading session data: " + e.getMessage());
                throw e;
            }
            new WorkingMemoryDbLogger((KnowledgeRuntimeEventManager)ksession);
            CommandBasedWSHumanTaskHandler handler = new CommandBasedWSHumanTaskHandler((KnowledgeRuntime)ksession);
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
            handler.connect();
            System.out.println("Successfully loaded default package from Guvnor");
            return ksession;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not initialize stateful knowledge session: " + t.getMessage(), t);
        }
    }

    private StatefulKnowledgeSession getSession() {
        if (ksession == null) {
            ksession = this.newStatefulKnowledgeSession();
        }
        return ksession;
    }

    public List<Process> getProcesses() {
        ArrayList<Process> result = new ArrayList<Process>();
        for (KnowledgePackage kpackage : this.getSession().getKnowledgeBase().getKnowledgePackages()) {
            result.addAll(kpackage.getProcesses());
        }
        return result;
    }

    public Process getProcess(String processId) {
        for (KnowledgePackage kpackage : this.getSession().getKnowledgeBase().getKnowledgePackages()) {
            for (Process process : kpackage.getProcesses()) {
                if (!processId.equals(process.getId())) continue;
                return process;
            }
        }
        return null;
    }

    public Process getProcessByName(String name) {
        for (KnowledgePackage kpackage : this.getSession().getKnowledgeBase().getKnowledgePackages()) {
            for (Process process : kpackage.getProcesses()) {
                if (!name.equals(process.getName())) continue;
                return process;
            }
        }
        return null;
    }

    public void removeProcess(String processId) {
        throw new UnsupportedOperationException();
    }

    public ProcessInstanceLog getProcessInstanceLog(String processInstanceId) {
        return ProcessInstanceDbLog.findProcessInstance((long)new Long(processInstanceId));
    }

    public List<ProcessInstanceLog> getProcessInstanceLogsByProcessId(String processId) {
        return ProcessInstanceDbLog.findProcessInstances((String)processId);
    }

    public ProcessInstanceLog startProcess(String processId, Map<String, Object> parameters) {
        long processInstanceId = ksession.startProcess(processId, parameters).getId();
        return ProcessInstanceDbLog.findProcessInstance((long)processInstanceId);
    }

    public void abortProcessInstance(String processInstanceId) {
        ProcessInstance processInstance = ksession.getProcessInstance(new Long(processInstanceId).longValue());
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance " + processInstanceId);
        }
        ksession.abortProcessInstance(new Long(processInstanceId).longValue());
    }

    public Map<String, Object> getProcessInstanceVariables(String processInstanceId) {
        ProcessInstance processInstance = ksession.getProcessInstance(new Long(processInstanceId).longValue());
        if (processInstance != null) {
            Map variables = ((WorkflowProcessInstanceImpl)processInstance).getVariables();
            if (variables == null) {
                return new HashMap<String, Object>();
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : variables.entrySet()) {
                if (entry.getValue() == null) continue;
                result.put((String)entry.getKey(), entry.getValue());
            }
            return result;
        }
        throw new IllegalArgumentException("Could not find process instance " + processInstanceId);
    }

    public void setProcessInstanceVariables(String processInstanceId, Map<String, Object> variables) {
        ProcessInstance processInstance = ksession.getProcessInstance(new Long(processInstanceId).longValue());
        if (processInstance != null) {
            VariableScopeInstance variableScope = (VariableScopeInstance)((org.drools.process.instance.ProcessInstance)processInstance).getContextInstance("VariableScope");
            if (variableScope == null) {
                throw new IllegalArgumentException("Could not find variable scope for process instance " + processInstanceId);
            }
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                variableScope.setVariable(entry.getKey(), entry.getValue());
            }
        } else {
            throw new IllegalArgumentException("Could not find process instance " + processInstanceId);
        }
    }

    public void signalExecution(String executionId, String signal) {
        ksession.getProcessInstance(new Long(executionId).longValue()).signalEvent("signal", (Object)signal);
    }
}

