/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integration.console;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.SystemEventListenerFactory;
import org.drools.integration.console.DroolsFlowTransform;
import org.drools.process.workitem.wsht.BlockingGetTaskResponseHandler;
import org.drools.task.AccessType;
import org.drools.task.Status;
import org.drools.task.Task;
import org.drools.task.query.TaskSummary;
import org.drools.task.service.ContentData;
import org.drools.task.service.TaskClient;
import org.drools.task.service.TaskClientConnector;
import org.drools.task.service.TaskClientHandler;
import org.drools.task.service.mina.BaseMinaHandler;
import org.drools.task.service.mina.MinaTaskClientConnector;
import org.drools.task.service.mina.MinaTaskClientHandler;
import org.drools.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.drools.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.server.integration.TaskManagement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsFlowTaskManagement
implements TaskManagement {
    private String ipAddress = "127.0.0.1";
    private int port = 9123;
    private TaskClient client;

    public void setConnection(String ipAddress, int port) {
        this.ipAddress = ipAddress;
        this.port = port;
    }

    public void connect() {
        if (this.client == null) {
            this.client = new TaskClient((TaskClientConnector)new MinaTaskClientConnector("org.drools.process.workitem.wsht.WSHumanTaskHandler", (BaseMinaHandler)new MinaTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
            boolean connected = this.client.connect(this.ipAddress, this.port);
            if (!connected) {
                throw new IllegalArgumentException("Could not connect task client");
            }
        }
    }

    public TaskRef getTaskById(long taskId) {
        this.connect();
        BlockingGetTaskResponseHandler responseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)responseHandler);
        Task task = responseHandler.getTask();
        return DroolsFlowTransform.task(task);
    }

    public void assignTask(long taskId, String idRef, String userId) {
        this.connect();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        if (idRef == null) {
            this.client.release(taskId, userId, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        } else if (idRef.equals(userId)) {
            this.client.claim(taskId, idRef, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        } else {
            this.client.delegate(taskId, userId, idRef, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        }
        responseHandler.waitTillDone(5000L);
    }

    public void completeTask(long taskId, Map data, String userId) {
        this.connect();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, userId, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        responseHandler = new BlockingTaskOperationResponseHandler();
        ContentData contentData = null;
        if (data != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream out = new ObjectOutputStream(bos);
                out.writeObject(data);
                out.close();
                contentData = new ContentData();
                contentData.setContent(bos.toByteArray());
                contentData.setAccessType(AccessType.Inline);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.client.complete(taskId, userId, contentData, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
    }

    public void completeTask(long taskId, String outcome, Map data, String userId) {
        data.put("outcome", outcome);
        this.completeTask(taskId, data, userId);
    }

    public void releaseTask(long taskId, String userId) {
        this.connect();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.release(taskId, userId, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
    }

    public List<TaskRef> getAssignedTasks(String idRef) {
        this.connect();
        ArrayList<TaskRef> result = new ArrayList<TaskRef>();
        try {
            BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
            this.client.getTasksOwned(idRef, "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
            List tasks = responseHandler.getResults();
            for (TaskSummary task : tasks) {
                if (task.getStatus() != Status.Reserved) continue;
                result.add(DroolsFlowTransform.task(task));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return result;
    }

    public List<TaskRef> getUnassignedTasks(String idRef, String participationType) {
        this.connect();
        ArrayList<TaskRef> result = new ArrayList<TaskRef>();
        try {
            BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
            this.client.getTasksAssignedAsPotentialOwner(idRef, "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
            List tasks = responseHandler.getResults();
            for (TaskSummary task : tasks) {
                result.add(DroolsFlowTransform.task(task));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return result;
    }
}

