/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarInputStream;
import junit.framework.TestCase;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.rules.SuggestionCompletionLoader;

public class SuggestionCompletionEngine2Test
extends TestCase {
    public void testAccessorsAndMutatorsDeclaredModel() throws Exception {
        String pkg = "package org.test\n";
        pkg = String.valueOf(pkg) + "declare Test\n";
        pkg = String.valueOf(pkg) + "number: Integer\n";
        pkg = String.valueOf(pkg) + "end\n";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList(), new ArrayList());
        String[] accessors = engine.getFieldCompletions(FieldAccessorsAndMutators.ACCESSOR, "Test");
        SuggestionCompletionEngine2Test.assertEquals((int)2, (int)accessors.length);
        String[] mutators = engine.getFieldCompletions(FieldAccessorsAndMutators.MUTATOR, "Test");
        SuggestionCompletionEngine2Test.assertEquals((int)2, (int)mutators.length);
    }

    public void testAccessorsAndMutatorsJavaClass() throws Exception {
        String pkg = "package org.test\n import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine2Test.Person\n";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList(), new ArrayList());
        String[] accessors = engine.getFieldCompletions(FieldAccessorsAndMutators.ACCESSOR, "SuggestionCompletionEngine2Test$Person");
        SuggestionCompletionEngine2Test.assertEquals((int)3, (int)accessors.length);
        String[] mutators = engine.getFieldCompletions(FieldAccessorsAndMutators.MUTATOR, "SuggestionCompletionEngine2Test$Person");
        SuggestionCompletionEngine2Test.assertEquals((int)3, (int)mutators.length);
    }

    public void testArrayList() {
        String pkg = "package org.test\n global java.util.ArrayList testList";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList(), new ArrayList());
        List methodNames = engine.getMethodNames("ArrayList");
        SuggestionCompletionEngine2Test.assertNotNull((Object)methodNames);
        SuggestionCompletionEngine2Test.assertFalse((boolean)methodNames.isEmpty());
        for (String s : methodNames) {
            SuggestionCompletionEngine2Test.assertFalse((String)("Method " + s + " is not allowed."), (boolean)this.allowedMethod(s));
        }
    }

    public void testJarFileWithSourceFiles() {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        String header = "package foo \n import org.test.Person \n import org.test.Banana \n ";
        ArrayList<JarInputStream> jars = new ArrayList<JarInputStream>();
        JarInputStream jis = null;
        SuggestionCompletionEngine suggestionCompletionEngine = null;
        try {
            jis = new JarInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/JarWithSourceFiles.jar"));
            jars.add(jis);
        }
        catch (IOException e) {
            SuggestionCompletionEngine2Test.fail((String)"Could not load jar");
        }
        try {
            suggestionCompletionEngine = loader.getSuggestionEngine(header, jars, new ArrayList());
        }
        catch (ClassFormatError e) {
            SuggestionCompletionEngine2Test.fail((String)("Can not load suggestions " + e));
        }
        SuggestionCompletionEngine2Test.assertNotNull((Object)jis);
        SuggestionCompletionEngine2Test.assertNotNull((Object)suggestionCompletionEngine);
        SuggestionCompletionEngine2Test.assertEquals((int)2, (int)suggestionCompletionEngine.getFactTypes().length);
        List<String> list = Arrays.asList(suggestionCompletionEngine.getFactTypes());
        SuggestionCompletionEngine2Test.assertTrue((boolean)list.contains("Person"));
        SuggestionCompletionEngine2Test.assertTrue((boolean)list.contains("Banana"));
        SuggestionCompletionEngine2Test.assertEquals((String)"java.util.Collection", (String)suggestionCompletionEngine.getFieldClassName("Person", "bananas"));
        SuggestionCompletionEngine2Test.assertEquals((String)"Collection", (String)suggestionCompletionEngine.getFieldType("Person", "bananas"));
        SuggestionCompletionEngine2Test.assertEquals((String)"Banana", (String)suggestionCompletionEngine.getParametricFieldType("Person", "bananas"));
    }

    private boolean allowedMethod(String methodName) {
        return "hashCode".equals(methodName) || "equals".equals(methodName) || "listIterator".equals(methodName) || "lastIndexOf".equals(methodName) || "indexOf".equals(methodName) || "subList".equals(methodName) || "get".equals(methodName) || "isEmpty".equals(methodName) || "containsKey".equals(methodName) || "values".equals(methodName) || "entrySet".equals(methodName) || "containsValue".equals(methodName) || "keySet".equals(methodName) || "size".equals(methodName) || "toArray".equals(methodName) || "iterator".equals(methodName) || "contains".equals(methodName) || "isEmpty".equals(methodName) || "containsAll".equals(methodName) || "size".equals(methodName);
    }

    public static class Person {
        private String name;
        private int age;
        private String something;

        public String getSomething() {
            return this.something;
        }

        public void setSomething(String something) {
            this.something = something;
        }

        public int getAge() {
            return this.age;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void addPet(String petName) {
        }
    }
}

