/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.TestCase;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionGlobalCollectionAdd;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.server.util.BRLPersistence;
import org.drools.ide.common.server.util.BRXMLPersistence;

public class BRLPersistenceTest
extends TestCase {
    public void testGenerateEmptyXML() {
        BRLPersistence p = BRXMLPersistence.getInstance();
        String xml = p.marshal(new RuleModel());
        BRLPersistenceTest.assertNotNull((Object)xml);
        BRLPersistenceTest.assertFalse((boolean)xml.equals(""));
        BRLPersistenceTest.assertTrue((boolean)xml.startsWith("<rule>"));
        BRLPersistenceTest.assertTrue((boolean)xml.endsWith("</rule>"));
    }

    public void testBasics() {
        BRLPersistence p = BRXMLPersistence.getInstance();
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        ActionGlobalCollectionAdd ag = new ActionGlobalCollectionAdd();
        ag.factName = "x";
        ag.globalName = "g";
        m.addRhsItem((IAction)ag);
        m.name = "my rule";
        String xml = p.marshal(m);
        System.out.println(xml);
        BRLPersistenceTest.assertTrue((xml.indexOf("Person") > -1 ? 1 : 0) != 0);
        BRLPersistenceTest.assertTrue((xml.indexOf("Accident") > -1 ? 1 : 0) != 0);
        BRLPersistenceTest.assertTrue((xml.indexOf("no-loop") > -1 ? 1 : 0) != 0);
        BRLPersistenceTest.assertTrue((xml.indexOf("org.drools") == -1 ? 1 : 0) != 0);
        BRLPersistenceTest.assertTrue((xml.indexOf("addToGlobal") > -1 ? 1 : 0) != 0);
        RuleModel rm_ = BRXMLPersistence.getInstance().unmarshal(xml);
        BRLPersistenceTest.assertEquals((int)2, (int)rm_.rhs.length);
    }

    public void testMoreComplexRendering() {
        BRLPersistence p = BRXMLPersistence.getInstance();
        RuleModel m = this.getComplexModel();
        String xml = p.marshal(m);
        System.out.println(xml);
        BRLPersistenceTest.assertTrue((xml.indexOf("org.drools") == -1 ? 1 : 0) != 0);
    }

    public void testRoundTrip() {
        RuleModel m = this.getComplexModel();
        String xml = BRXMLPersistence.getInstance().marshal(m);
        RuleModel m2 = BRXMLPersistence.getInstance().unmarshal(xml);
        BRLPersistenceTest.assertNotNull((Object)m2);
        BRLPersistenceTest.assertEquals((String)m.name, (String)m2.name);
        BRLPersistenceTest.assertEquals((int)m.lhs.length, (int)m2.lhs.length);
        BRLPersistenceTest.assertEquals((int)m.rhs.length, (int)m2.rhs.length);
        BRLPersistenceTest.assertEquals((int)1, (int)m.attributes.length);
        RuleAttribute at = m.attributes[0];
        BRLPersistenceTest.assertEquals((String)"no-loop", (String)at.attributeName);
        BRLPersistenceTest.assertEquals((String)"true", (String)at.value);
        String newXML = BRXMLPersistence.getInstance().marshal(m2);
        BRLPersistenceTest.assertEquals((String)xml, (String)newXML);
    }

    public void testCompositeConstraintsRoundTrip() throws Exception {
        RuleModel m = new RuleModel();
        m.name = "with composite";
        FactPattern p1 = new FactPattern("Person");
        p1.boundName = "p1";
        m.addLhsItem((IPattern)p1);
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.compositeJunctionType = "||";
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.fieldName = "goo";
        X.constraintValueType = 1;
        X.value = "foo";
        X.operator = "==";
        X.connectives = new ConnectiveConstraint[1];
        X.connectives[0] = new ConnectiveConstraint();
        X.connectives[0].constraintValueType = 1;
        X.connectives[0].operator = "|| ==";
        X.connectives[0].value = "bar";
        comp.addConstraint((FieldConstraint)X);
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.fieldName = "goo2";
        Y.constraintValueType = 1;
        Y.value = "foo";
        Y.operator = "==";
        comp.addConstraint((FieldConstraint)Y);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.compositeJunctionType = "&&";
        SingleFieldConstraint Q1 = new SingleFieldConstraint();
        Q1.fieldName = "goo";
        Q1.operator = "==";
        Q1.value = "whee";
        Q1.constraintValueType = 1;
        comp2.addConstraint((FieldConstraint)Q1);
        SingleFieldConstraint Q2 = new SingleFieldConstraint();
        Q2.fieldName = "gabba";
        Q2.operator = "==";
        Q2.value = "whee";
        Q2.constraintValueType = 1;
        comp2.addConstraint((FieldConstraint)Q2);
        comp.addConstraint((FieldConstraint)comp2);
        SingleFieldConstraint Z = new SingleFieldConstraint();
        Z.fieldName = "goo3";
        Z.constraintValueType = 1;
        Z.value = "foo";
        Z.operator = "==";
        p.addConstraint((FieldConstraint)Z);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String xml = BRXMLPersistence.getInstance().marshal(m);
        RuleModel m2 = BRXMLPersistence.getInstance().unmarshal(xml);
        BRLPersistenceTest.assertNotNull((Object)m2);
        BRLPersistenceTest.assertEquals((String)"with composite", (String)m2.name);
        BRLPersistenceTest.assertEquals((int)m2.lhs.length, (int)m.lhs.length);
        BRLPersistenceTest.assertEquals((int)m2.rhs.length, (int)m.rhs.length);
    }

    public void testFreeFormLine() {
        RuleModel m = new RuleModel();
        m.name = "with composite";
        m.lhs = new IPattern[1];
        m.rhs = new IAction[1];
        FreeFormLine fl = new FreeFormLine();
        fl.text = "Person()";
        m.lhs[0] = fl;
        FreeFormLine fr = new FreeFormLine();
        fr.text = "fun()";
        m.rhs[0] = fr;
        String xml = BRXMLPersistence.getInstance().marshal(m);
        BRLPersistenceTest.assertNotNull((Object)xml);
        RuleModel m_ = BRXMLPersistence.getInstance().unmarshal(xml);
        BRLPersistenceTest.assertEquals((int)1, (int)m_.lhs.length);
        BRLPersistenceTest.assertEquals((int)1, (int)m_.rhs.length);
        BRLPersistenceTest.assertEquals((String)"Person()", (String)((FreeFormLine)m_.lhs[0]).text);
        BRLPersistenceTest.assertEquals((String)"fun()", (String)((FreeFormLine)m_.rhs[0]).text);
    }

    public void testBackwardsCompat() throws Exception {
        RuleModel m2 = BRXMLPersistence.getInstance().unmarshal(BRLPersistenceTest.loadResource("existing_brl.xml"));
        BRLPersistenceTest.assertNotNull((Object)m2);
        BRLPersistenceTest.assertEquals((int)3, (int)m2.rhs.length);
    }

    public static String loadResource(String name) throws Exception {
        InputStream in = BRLPersistenceTest.class.getResourceAsStream(name);
        InputStreamReader reader = new InputStreamReader(in);
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }

    private RuleModel getComplexModel() {
        RuleModel m = new RuleModel();
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        FactPattern pat = new FactPattern();
        pat.boundName = "p1";
        pat.factType = "Person";
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.fieldBinding = "f1";
        con.fieldName = "age";
        con.operator = "<";
        con.value = "42";
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        CompositeFactPattern comp = new CompositeFactPattern("not");
        comp.addFactPattern(new FactPattern("Cancel"));
        m.addLhsItem((IPattern)comp);
        ActionUpdateField set = new ActionUpdateField();
        set.variable = "p1";
        set.addFieldValue(new ActionFieldValue("status", "rejected", "String"));
        m.addRhsItem((IAction)set);
        ActionRetractFact ret = new ActionRetractFact("p1");
        m.addRhsItem((IAction)ret);
        DSLSentence sen = new DSLSentence();
        sen.sentence = "Send an email to {administrator}";
        m.addRhsItem((IAction)sen);
        return m;
    }

    public void testLoadEmpty() {
        RuleModel m = BRXMLPersistence.getInstance().unmarshal(null);
        BRLPersistenceTest.assertNotNull((Object)m);
        m = BRXMLPersistence.getInstance().unmarshal("");
        BRLPersistenceTest.assertNotNull((Object)m);
    }
}

