/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleMetadata;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionRetractFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.GuidedDTDRLPersistence;

public class GuidedDTDRLPersistenceTest
extends TestCase {
    public void test2Rules() throws Exception {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        dt.tableName = "michael";
        AttributeCol attr = new AttributeCol();
        attr.attr = "salience";
        attr.defaultValue = "66";
        dt.attributeCols.add(attr);
        ConditionCol con = new ConditionCol();
        con.boundName = "f1";
        con.constraintValueType = 1;
        con.factField = "age";
        con.factType = "Driver";
        con.header = "Driver f1 age";
        con.operator = "==";
        dt.conditionCols.add(con);
        ConditionCol con2 = new ConditionCol();
        con2.boundName = "f1";
        con2.constraintValueType = 1;
        con2.factField = "name";
        con2.factType = "Driver";
        con2.header = "Driver f1 name";
        con2.operator = "==";
        dt.conditionCols.add(con2);
        ConditionCol con3 = new ConditionCol();
        con3.boundName = "f1";
        con3.constraintValueType = 3;
        con3.factField = "rating";
        con3.factType = "Driver";
        con3.header = "Driver rating";
        con3.operator = "==";
        dt.conditionCols.add(con3);
        ConditionCol con4 = new ConditionCol();
        con4.boundName = "f2";
        con4.constraintValueType = 5;
        con4.factType = "Driver";
        con4.header = "Driver 2 pimp";
        con4.factField = "(not needed)";
        dt.conditionCols.add(con4);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.boundName = "ins";
        ins.factType = "Cheese";
        ins.factField = "price";
        ins.type = "Numeric";
        dt.actionCols.add(ins);
        ActionRetractFactCol ret = new ActionRetractFactCol();
        ret.boundName = "f2";
        dt.actionCols.add(ret);
        ActionSetFieldCol set = new ActionSetFieldCol();
        set.boundName = "f1";
        set.factField = "goo1";
        set.type = "String";
        dt.actionCols.add(set);
        ActionSetFieldCol set2 = new ActionSetFieldCol();
        set2.boundName = "f1";
        set2.factField = "goo2";
        set2.defaultValue = "whee";
        set2.type = "String";
        dt.actionCols.add(set2);
        String[][] stringArrayArray = new String[2][];
        String[] stringArray = new String[11];
        stringArray[0] = "1";
        stringArray[1] = "desc";
        stringArray[2] = "42";
        stringArray[3] = "33";
        stringArray[4] = "michael";
        stringArray[5] = "age * 0.2";
        stringArray[6] = "age > 7";
        stringArray[7] = "6.60";
        stringArray[8] = "true";
        stringArray[9] = "gooVal1";
        stringArrayArray[0] = stringArray;
        stringArrayArray[1] = new String[]{"2", "desc", "", "39", "bob", "age * 0.3", "age > 7", "6.60", "", "gooVal1", ""};
        dt.data = stringArrayArray;
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("from row number") > -1 ? 1 : 0) != 0);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("rating == ( age * 0.2 )") > 0 ? 1 : 0) != 0);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("f2 : Driver( eval( age > 7 ))") > 0 ? 1 : 0) != 0);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("rating == ( age * 0.3 )") > drl.indexOf("rating == ( age * 0.2 )") ? 1 : 0) != 0);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("f1.setGoo2( \"whee\" )") > 0 ? 1 : 0) != 0);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("salience 66") > 0 ? 1 : 0) != 0);
    }

    public void testInterpolate() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        dt.tableName = "michael";
        AttributeCol attr = new AttributeCol();
        attr.attr = "salience";
        attr.defaultValue = "66";
        dt.attributeCols.add(attr);
        ConditionCol con = new ConditionCol();
        con.boundName = "f1";
        con.constraintValueType = 1;
        con.factField = "age";
        con.factType = "Driver";
        con.header = "Driver f1 age";
        con.operator = "==";
        dt.conditionCols.add(con);
        ConditionCol con2 = new ConditionCol();
        con2.boundName = "f1";
        con2.constraintValueType = 1;
        con2.factField = "name";
        con2.factType = "Driver";
        con2.header = "Driver f1 name";
        con2.operator = "==";
        dt.conditionCols.add(con2);
        ConditionCol con3 = new ConditionCol();
        con3.boundName = "f1";
        con3.constraintValueType = 3;
        con3.factField = "rating";
        con3.factType = "Driver";
        con3.header = "Driver rating";
        con3.operator = "==";
        dt.conditionCols.add(con3);
        ConditionCol con4 = new ConditionCol();
        con4.boundName = "f2";
        con4.constraintValueType = 5;
        con4.factType = "Driver";
        con4.header = "Driver 2 pimp";
        con4.factField = "this.hasSomething($param)";
        dt.conditionCols.add(con4);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.boundName = "ins";
        ins.factType = "Cheese";
        ins.factField = "price";
        ins.type = "Numeric";
        dt.actionCols.add(ins);
        ActionRetractFactCol ret = new ActionRetractFactCol();
        ret.boundName = "f2";
        dt.actionCols.add(ret);
        ActionSetFieldCol set = new ActionSetFieldCol();
        set.boundName = "f1";
        set.factField = "goo1";
        set.type = "String";
        dt.actionCols.add(set);
        ActionSetFieldCol set2 = new ActionSetFieldCol();
        set2.boundName = "f1";
        set2.factField = "goo2";
        set2.defaultValue = "whee";
        set2.type = "String";
        dt.actionCols.add(set2);
        String[][] stringArrayArray = new String[2][];
        String[] stringArray = new String[11];
        stringArray[0] = "1";
        stringArray[1] = "desc";
        stringArray[2] = "42";
        stringArray[3] = "33";
        stringArray[4] = "michael";
        stringArray[5] = "age * 0.2";
        stringArray[6] = "BAM";
        stringArray[7] = "6.60";
        stringArray[8] = "true";
        stringArray[9] = "gooVal1";
        stringArrayArray[0] = stringArray;
        stringArrayArray[1] = new String[]{"2", "desc", "", "39", "bob", "age * 0.3", "BAM", "6.60", "", "gooVal1", ""};
        dt.data = stringArrayArray;
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("from row number") > -1 ? 1 : 0) != 0);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("rating == ( age * 0.2 )") > 0 ? 1 : 0) != 0);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("f2 : Driver( eval( this.hasSomething(BAM) ))") > 0 ? 1 : 0) != 0);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("rating == ( age * 0.3 )") > drl.indexOf("rating == ( age * 0.2 )") ? 1 : 0) != 0);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("f1.setGoo2( \"whee\" )") > 0 ? 1 : 0) != 0);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("salience 66") > 0 ? 1 : 0) != 0);
    }

    public void testInOperator() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        dt.tableName = "michael";
        AttributeCol attr = new AttributeCol();
        attr.attr = "salience";
        attr.defaultValue = "66";
        dt.attributeCols.add(attr);
        ConditionCol con = new ConditionCol();
        con.boundName = "f1";
        con.constraintValueType = 1;
        con.factField = "age";
        con.factType = "Driver";
        con.header = "Driver f1 age";
        con.operator = "==";
        dt.conditionCols.add(con);
        ConditionCol con2 = new ConditionCol();
        con2.boundName = "f1";
        con2.constraintValueType = 1;
        con2.factField = "name";
        con2.factType = "Driver";
        con2.header = "Driver f1 name";
        con2.operator = "in";
        dt.conditionCols.add(con2);
        ConditionCol con3 = new ConditionCol();
        con3.boundName = "f1";
        con3.constraintValueType = 3;
        con3.factField = "rating";
        con3.factType = "Driver";
        con3.header = "Driver rating";
        con3.operator = "==";
        dt.conditionCols.add(con3);
        ConditionCol con4 = new ConditionCol();
        con4.boundName = "f2";
        con4.constraintValueType = 5;
        con4.factType = "Driver";
        con4.header = "Driver 2 pimp";
        con4.factField = "(not needed)";
        dt.conditionCols.add(con4);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.boundName = "ins";
        ins.factType = "Cheese";
        ins.factField = "price";
        ins.type = "Numeric";
        dt.actionCols.add(ins);
        ActionRetractFactCol ret = new ActionRetractFactCol();
        ret.boundName = "f2";
        dt.actionCols.add(ret);
        ActionSetFieldCol set = new ActionSetFieldCol();
        set.boundName = "f1";
        set.factField = "goo1";
        set.type = "String";
        dt.actionCols.add(set);
        ActionSetFieldCol set2 = new ActionSetFieldCol();
        set2.boundName = "f1";
        set2.factField = "goo2";
        set2.defaultValue = "whee";
        set2.type = "String";
        dt.actionCols.add(set2);
        String[][] stringArrayArray = new String[2][];
        String[] stringArray = new String[11];
        stringArray[0] = "1";
        stringArray[1] = "desc";
        stringArray[2] = "42";
        stringArray[3] = "33";
        stringArray[4] = "michael, manik";
        stringArray[5] = "age * 0.2";
        stringArray[6] = "age > 7";
        stringArray[7] = "6.60";
        stringArray[8] = "true";
        stringArray[9] = "gooVal1";
        stringArrayArray[0] = stringArray;
        stringArrayArray[1] = new String[]{"2", "desc", "", "39", "bob, frank", "age * 0.3", "age > 7", "6.60", "", "gooVal1", ""};
        dt.data = stringArrayArray;
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("name in (\"michael\",") > 0 ? 1 : 0) != 0);
    }

    public void testCellCSV() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        GuidedDTDRLPersistenceTest.assertEquals((String)"(\"Michael\", \"Mark\", \"Peter\")", (String)p.makeInList("Michael, Mark, Peter"));
        GuidedDTDRLPersistenceTest.assertEquals((String)"(\"Michael\")", (String)p.makeInList("Michael"));
        GuidedDTDRLPersistenceTest.assertEquals((String)"(\"Michael\")", (String)p.makeInList("\"Michael\""));
        GuidedDTDRLPersistenceTest.assertEquals((String)"(\"Michael\", \"Ma rk\", \"Peter\")", (String)p.makeInList("Michael, \"Ma rk\", Peter"));
        GuidedDTDRLPersistenceTest.assertEquals((String)"(WEE WAAH)", (String)p.makeInList("(WEE WAAH)"));
    }

    public void testCellVal() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        GuidedDTDRLPersistenceTest.assertFalse((boolean)p.validCell(null));
        GuidedDTDRLPersistenceTest.assertFalse((boolean)p.validCell(""));
        GuidedDTDRLPersistenceTest.assertFalse((boolean)p.validCell("  "));
    }

    public void testName() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        GuidedDTDRLPersistenceTest.assertEquals((String)"Row 42 XXX", (String)p.getName("XXX", "42"));
        GuidedDTDRLPersistenceTest.assertEquals((String)"Row 42 YYY", (String)p.getName("YYY", "42"));
    }

    public void testAttribs() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[] row = new String[]{"1", "desc", "a", ""};
        ArrayList<AttributeCol> attributeCols = new ArrayList<AttributeCol>();
        RuleModel rm = new RuleModel();
        RuleAttribute[] orig = rm.attributes;
        p.doAttribs(0, attributeCols, row, rm);
        GuidedDTDRLPersistenceTest.assertSame((Object)orig, (Object)rm.attributes);
        AttributeCol col1 = new AttributeCol();
        col1.attr = "salience";
        AttributeCol col2 = new AttributeCol();
        col2.attr = "agenda-group";
        attributeCols.add(col1);
        attributeCols.add(col2);
        p.doAttribs(0, attributeCols, row, rm);
        GuidedDTDRLPersistenceTest.assertEquals((int)1, (int)rm.attributes.length);
        GuidedDTDRLPersistenceTest.assertEquals((String)"salience", (String)rm.attributes[0].attributeName);
        GuidedDTDRLPersistenceTest.assertEquals((String)"a", (String)rm.attributes[0].value);
        row = new String[]{"1", "desc", "a", "b"};
        p.doAttribs(0, attributeCols, row, rm);
        GuidedDTDRLPersistenceTest.assertEquals((int)2, (int)rm.attributes.length);
        GuidedDTDRLPersistenceTest.assertEquals((String)"salience", (String)rm.attributes[0].attributeName);
        GuidedDTDRLPersistenceTest.assertEquals((String)"a", (String)rm.attributes[0].value);
        GuidedDTDRLPersistenceTest.assertEquals((String)"agenda-group", (String)rm.attributes[1].attributeName);
        GuidedDTDRLPersistenceTest.assertEquals((String)"b", (String)rm.attributes[1].value);
    }

    public void testMetaData() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[] row = new String[]{"1", "desc", "bar", ""};
        ArrayList<MetadataCol> metadataCols = new ArrayList<MetadataCol>();
        RuleModel rm = new RuleModel();
        RuleMetadata[] orig = rm.metadataList;
        p.doMetadata(metadataCols, row, rm);
        GuidedDTDRLPersistenceTest.assertSame((Object)orig, (Object)rm.metadataList);
        MetadataCol col1 = new MetadataCol();
        col1.attr = "foo";
        MetadataCol col2 = new MetadataCol();
        col2.attr = "foo2";
        metadataCols.add(col1);
        metadataCols.add(col2);
        p.doMetadata(metadataCols, row, rm);
        GuidedDTDRLPersistenceTest.assertEquals((int)1, (int)rm.metadataList.length);
        GuidedDTDRLPersistenceTest.assertEquals((String)"foo", (String)rm.metadataList[0].attributeName);
        GuidedDTDRLPersistenceTest.assertEquals((String)"bar", (String)rm.metadataList[0].value);
        row = new String[]{"1", "desc", "bar1", "bar2"};
        p.doMetadata(metadataCols, row, rm);
        GuidedDTDRLPersistenceTest.assertEquals((int)2, (int)rm.metadataList.length);
        GuidedDTDRLPersistenceTest.assertEquals((String)"foo", (String)rm.metadataList[0].attributeName);
        GuidedDTDRLPersistenceTest.assertEquals((String)"bar1", (String)rm.metadataList[0].value);
        GuidedDTDRLPersistenceTest.assertEquals((String)"foo2", (String)rm.metadataList[1].attributeName);
        GuidedDTDRLPersistenceTest.assertEquals((String)"bar2", (String)rm.metadataList[1].value);
    }

    public void testLHS() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[] row = new String[]{"1", "desc", "a", "mike", "33 + 1", "age > 6", "stilton"};
        ArrayList<ConditionCol> cols = new ArrayList<ConditionCol>();
        ConditionCol col = new ConditionCol();
        col.boundName = "p1";
        col.factType = "Person";
        col.factField = "name";
        col.constraintValueType = 1;
        col.operator = "==";
        cols.add(col);
        ConditionCol col2 = new ConditionCol();
        col2.boundName = "p1";
        col2.factType = "Person";
        col2.factField = "age";
        col2.constraintValueType = 3;
        col2.operator = "<";
        cols.add(col2);
        ConditionCol col3 = new ConditionCol();
        col3.boundName = "p1";
        col3.factType = "Person";
        col3.constraintValueType = 5;
        cols.add(col3);
        ConditionCol col4 = new ConditionCol();
        col4.boundName = "c";
        col4.factType = "Cheese";
        col4.factField = "type";
        col4.operator = "==";
        col4.constraintValueType = 1;
        cols.add(col4);
        RuleModel rm = new RuleModel();
        p.doConditions(1, cols, row, rm);
        GuidedDTDRLPersistenceTest.assertEquals((int)2, (int)rm.lhs.length);
        GuidedDTDRLPersistenceTest.assertEquals((String)"Person", (String)((FactPattern)rm.lhs[0]).factType);
        GuidedDTDRLPersistenceTest.assertEquals((String)"p1", (String)((FactPattern)rm.lhs[0]).boundName);
        GuidedDTDRLPersistenceTest.assertEquals((String)"Cheese", (String)((FactPattern)rm.lhs[1]).factType);
        GuidedDTDRLPersistenceTest.assertEquals((String)"c", (String)((FactPattern)rm.lhs[1]).boundName);
        FactPattern person = (FactPattern)rm.lhs[0];
        GuidedDTDRLPersistenceTest.assertEquals((int)3, (int)person.constraintList.constraints.length);
        SingleFieldConstraint cons = (SingleFieldConstraint)person.constraintList.constraints[0];
        GuidedDTDRLPersistenceTest.assertEquals((int)1, (int)cons.constraintValueType);
        GuidedDTDRLPersistenceTest.assertEquals((String)"name", (String)cons.fieldName);
        GuidedDTDRLPersistenceTest.assertEquals((String)"==", (String)cons.operator);
        GuidedDTDRLPersistenceTest.assertEquals((String)"mike", (String)cons.value);
        cons = (SingleFieldConstraint)person.constraintList.constraints[1];
        GuidedDTDRLPersistenceTest.assertEquals((int)3, (int)cons.constraintValueType);
        GuidedDTDRLPersistenceTest.assertEquals((String)"age", (String)cons.fieldName);
        GuidedDTDRLPersistenceTest.assertEquals((String)"<", (String)cons.operator);
        GuidedDTDRLPersistenceTest.assertEquals((String)"33 + 1", (String)cons.value);
        cons = (SingleFieldConstraint)person.constraintList.constraints[2];
        GuidedDTDRLPersistenceTest.assertEquals((int)5, (int)cons.constraintValueType);
        GuidedDTDRLPersistenceTest.assertEquals((String)"age > 6", (String)cons.value);
        FactPattern cheese = (FactPattern)rm.lhs[1];
        GuidedDTDRLPersistenceTest.assertEquals((int)1, (int)cheese.constraintList.constraints.length);
        cons = (SingleFieldConstraint)cheese.constraintList.constraints[0];
        GuidedDTDRLPersistenceTest.assertEquals((String)"type", (String)cons.fieldName);
        GuidedDTDRLPersistenceTest.assertEquals((String)"==", (String)cons.operator);
        GuidedDTDRLPersistenceTest.assertEquals((String)"stilton", (String)cons.value);
        GuidedDTDRLPersistenceTest.assertEquals((int)1, (int)cons.constraintValueType);
    }

    public void testRHS() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[] row = new String[]{"1", "desc", "a", "a condition", "actionsetfield1", "actionsetfield2", "retract", "actioninsertfact1", "actioninsertfact2"};
        ArrayList<Object> cols = new ArrayList<Object>();
        ActionSetFieldCol asf1 = new ActionSetFieldCol();
        asf1.boundName = "a";
        asf1.factField = "field1";
        asf1.type = "String";
        cols.add(asf1);
        ActionSetFieldCol asf2 = new ActionSetFieldCol();
        asf2.boundName = "a";
        asf2.factField = "field2";
        asf2.update = true;
        asf2.type = "Numeric";
        cols.add(asf2);
        ActionRetractFactCol ret = new ActionRetractFactCol();
        ret.boundName = "ret";
        cols.add(ret);
        ActionInsertFactCol ins1 = new ActionInsertFactCol();
        ins1.boundName = "ins";
        ins1.factType = "Cheese";
        ins1.factField = "price";
        ins1.type = "Numeric";
        cols.add(ins1);
        ActionInsertFactCol ins2 = new ActionInsertFactCol();
        ins2.boundName = "ins";
        ins2.factType = "Cheese";
        ins2.factField = "type";
        ins2.type = "Numeric";
        cols.add(ins2);
        RuleModel rm = new RuleModel();
        p.doActions(2, cols, row, rm);
        GuidedDTDRLPersistenceTest.assertEquals((int)3, (int)rm.rhs.length);
        ActionSetField a1 = (ActionSetField)rm.rhs[0];
        GuidedDTDRLPersistenceTest.assertEquals((String)"a", (String)a1.variable);
        GuidedDTDRLPersistenceTest.assertEquals((int)2, (int)a1.fieldValues.length);
        GuidedDTDRLPersistenceTest.assertEquals((String)"field1", (String)a1.fieldValues[0].field);
        GuidedDTDRLPersistenceTest.assertEquals((String)"actionsetfield1", (String)a1.fieldValues[0].value);
        GuidedDTDRLPersistenceTest.assertEquals((String)"String", (String)a1.fieldValues[0].type);
        GuidedDTDRLPersistenceTest.assertEquals((String)"field2", (String)a1.fieldValues[1].field);
        GuidedDTDRLPersistenceTest.assertEquals((String)"actionsetfield2", (String)a1.fieldValues[1].value);
        GuidedDTDRLPersistenceTest.assertEquals((String)"Numeric", (String)a1.fieldValues[1].type);
        ActionRetractFact a2 = (ActionRetractFact)rm.rhs[1];
        GuidedDTDRLPersistenceTest.assertEquals((String)"ret", (String)a2.variableName);
        ActionInsertFact a3 = (ActionInsertFact)rm.rhs[2];
        GuidedDTDRLPersistenceTest.assertEquals((String)"Cheese", (String)a3.factType);
        GuidedDTDRLPersistenceTest.assertEquals((int)2, (int)a3.fieldValues.length);
        GuidedDTDRLPersistenceTest.assertEquals((String)"price", (String)a3.fieldValues[0].field);
        GuidedDTDRLPersistenceTest.assertEquals((String)"actioninsertfact1", (String)a3.fieldValues[0].value);
        GuidedDTDRLPersistenceTest.assertEquals((String)"Numeric", (String)a3.fieldValues[0].type);
        GuidedDTDRLPersistenceTest.assertEquals((String)"type", (String)a3.fieldValues[1].field);
        GuidedDTDRLPersistenceTest.assertEquals((String)"actioninsertfact2", (String)a3.fieldValues[1].value);
        GuidedDTDRLPersistenceTest.assertEquals((String)"Numeric", (String)a3.fieldValues[1].type);
    }

    public void testNoConstraints() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        ConditionCol c = new ConditionCol();
        c.boundName = "x";
        c.factType = "Context";
        c.constraintValueType = 1;
        dt.conditionCols.add(c);
        ActionSetFieldCol asf = new ActionSetFieldCol();
        asf.boundName = "x";
        asf.factField = "age";
        asf.type = "String";
        dt.actionCols.add(asf);
        String[][] data = new String[][]{{"1", "desc", "y", "old"}};
        dt.data = data;
        String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("Context( )") > -1 ? 1 : 0) != 0);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("x.setAge") > drl.indexOf("Context( )") ? 1 : 0) != 0);
        GuidedDTDRLPersistenceTest.assertFalse((drl.indexOf("update( x );") > -1 ? 1 : 0) != 0);
        dt.data = new String[][]{{"1", "desc", "", "old"}};
        drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        GuidedDTDRLPersistenceTest.assertEquals((int)-1, (int)drl.indexOf("Context( )"));
    }

    public void testUpdateModify() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        ConditionCol c = new ConditionCol();
        c.boundName = "x";
        c.factType = "Context";
        c.constraintValueType = 1;
        dt.conditionCols.add(c);
        ActionSetFieldCol asf = new ActionSetFieldCol();
        asf.boundName = "x";
        asf.factField = "age";
        asf.type = "String";
        asf.update = true;
        dt.actionCols.add(asf);
        String[][] data = new String[][]{{"1", "desc", "y", "old"}};
        dt.data = data;
        String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        System.err.println(drl);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("Context( )") > -1 ? 1 : 0) != 0);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("x.setAge") > drl.indexOf("Context( )") ? 1 : 0) != 0);
        dt.data = new String[][]{{"1", "desc", "", "old"}};
        drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        GuidedDTDRLPersistenceTest.assertEquals((int)-1, (int)drl.indexOf("Context( )"));
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("update( x );") > -1 ? 1 : 0) != 0);
    }

    public void testNoOperator() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[] row = new String[]{"1", "desc", "a", "> 42", "33 + 1", "age > 6", "stilton"};
        ArrayList<ConditionCol> cols = new ArrayList<ConditionCol>();
        ConditionCol col2 = new ConditionCol();
        col2.boundName = "p1";
        col2.factType = "Person";
        col2.factField = "age";
        col2.constraintValueType = 1;
        col2.operator = "";
        cols.add(col2);
        RuleModel rm = new RuleModel();
        p.doConditions(1, cols, row, rm);
        String drl = BRDRLPersistence.getInstance().marshal(rm);
        GuidedDTDRLPersistenceTest.assertTrue((drl.indexOf("age > \"42\"") > 0 ? 1 : 0) != 0);
    }
}

