/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.graph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.LinkFilter;
import org.drools.impact.analysis.graph.Node;
import org.drools.impact.analysis.graph.ReactivityType;

public class GraphCollapsionHelper {
    private static final Pattern PREFIX_PATTERN = Pattern.compile("(.*)_\\d*");
    private LinkFilter linkFilter = LinkFilter.ALL;

    public GraphCollapsionHelper() {
    }

    public GraphCollapsionHelper(boolean positiveOnly) {
        this.linkFilter = positiveOnly ? LinkFilter.POSITIVE : LinkFilter.ALL;
    }

    public GraphCollapsionHelper(LinkFilter linkFilter) {
        this.linkFilter = linkFilter;
    }

    public Graph collapseWithRuleNamePrefix(Graph graph) {
        Map<String, Node> nodeMap = graph.getNodeMap();
        Map<String, Set<Node>> groupedNodeMap = this.groupWithRuleNamePrefix(nodeMap);
        Map<String, Node> collapsedNodeMap = this.collapseGroupedNodes(groupedNodeMap);
        return new Graph(collapsedNodeMap);
    }

    private Map<String, Node> collapseGroupedNodes(Map<String, Set<Node>> groupedNodeMap) {
        Set<Node> nodeSet;
        HashMap<String, Node> collapsedNodeMap = new HashMap<String, Node>();
        for (String prefixedKey : groupedNodeMap.keySet()) {
            nodeSet = groupedNodeMap.get(prefixedKey);
            Node tmpNode = nodeSet.iterator().next();
            String packageName = tmpNode.getPackageName();
            String ruleName = tmpNode.getRuleName();
            String ruleNamePrefix = this.getPrefix(ruleName);
            Node collapsedNode = new Node(packageName, ruleNamePrefix);
            collapsedNodeMap.put(prefixedKey, collapsedNode);
        }
        for (String prefixedKey : groupedNodeMap.keySet()) {
            nodeSet = groupedNodeMap.get(prefixedKey);
            nodeSet.stream().flatMap(node -> node.getOutgoingLinks().stream()).forEach(link -> {
                ReactivityType type = link.getReactivityType();
                Node sourceCollapsedNode = (Node)collapsedNodeMap.get(prefixedKey);
                Node target = link.getTarget();
                Node targetCollapsedNode = (Node)collapsedNodeMap.get(this.getPrefix(target.getFqdn()));
                if (this.linkFilter.accept(type)) {
                    Node.linkNodes(sourceCollapsedNode, targetCollapsedNode, type);
                }
            });
        }
        return collapsedNodeMap;
    }

    private Map<String, Set<Node>> groupWithRuleNamePrefix(Map<String, Node> nodeMap) {
        HashMap<String, Set<Node>> groupedNodeMap = new HashMap<String, Set<Node>>();
        nodeMap.keySet().stream().forEach(key -> {
            String prefixedKey = this.getPrefix((String)key);
            groupedNodeMap.computeIfAbsent(prefixedKey, k -> new HashSet()).add((Node)nodeMap.get(key));
        });
        return groupedNodeMap;
    }

    private String getPrefix(String key) {
        Matcher m = PREFIX_PATTERN.matcher(key);
        if (m.find()) {
            return m.group(1);
        }
        return key;
    }
}

