/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.impact.analysis.graph.AnalyzedRule;
import org.drools.impact.analysis.graph.Node;
import org.drools.impact.analysis.model.Rule;

public class GraphAnalysis {
    private final Map<String, Node> nodeMap = new HashMap<String, Node>();
    private final Map<Class<?>, Map<String, AnalyzedRuleSet>> propertyReactiveMap = new HashMap();
    private final Map<Class<?>, AnalyzedRuleSet> classReativeMap = new HashMap();
    private final Map<Class<?>, AnalyzedRuleSet> insertReactiveMap = new HashMap();

    public Node getNode(String fqn) {
        return this.nodeMap.get(fqn);
    }

    public Map<String, Node> getNodeMap() {
        return this.nodeMap;
    }

    public void addNode(Node node) {
        this.nodeMap.put(node.getId(), node);
    }

    public boolean isRegisteredClass(Class<?> clazz) {
        return this.propertyReactiveMap.containsKey(clazz) || this.classReativeMap.containsKey(clazz) || this.insertReactiveMap.containsKey(clazz);
    }

    public void addPropertyReactiveRule(Class<?> clazz, String property, Rule rule, boolean positive) {
        this.propertyReactiveMap.computeIfAbsent(clazz, k -> new HashMap()).computeIfAbsent(property, k -> new AnalyzedRuleSet()).add(new AnalyzedRule(rule, positive));
    }

    public void addClassReactiveRule(Class<?> clazz, Rule rule, boolean positive) {
        this.classReativeMap.computeIfAbsent(clazz, k -> new AnalyzedRuleSet()).add(new AnalyzedRule(rule, positive));
    }

    public void addInsertReactiveRule(Class<?> clazz, Rule rule, boolean positive) {
        this.insertReactiveMap.computeIfAbsent(clazz, k -> new AnalyzedRuleSet()).add(new AnalyzedRule(rule, positive));
    }

    public Collection<AnalyzedRule> getRulesReactiveTo(Class<?> clazz) {
        AnalyzedRuleSet rules = new AnalyzedRuleSet();
        rules.addAll(this.propertyReactiveMap.getOrDefault(clazz, Collections.emptyMap()).values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        rules.addAll(this.classReativeMap.getOrDefault(clazz, AnalyzedRuleSet.EMPTY));
        rules.addAll(this.insertReactiveMap.getOrDefault(clazz, AnalyzedRuleSet.EMPTY));
        return rules;
    }

    public Collection<AnalyzedRule> getRulesReactiveToWithoutProperty(Class<?> clazz) {
        AnalyzedRuleSet rules = new AnalyzedRuleSet();
        rules.addAll(this.classReativeMap.getOrDefault(clazz, AnalyzedRuleSet.EMPTY));
        rules.addAll(this.insertReactiveMap.getOrDefault(clazz, AnalyzedRuleSet.EMPTY));
        return rules;
    }

    public Collection<AnalyzedRule> getRulesReactiveTo(Class<?> clazz, String property) {
        AnalyzedRuleSet rules = new AnalyzedRuleSet();
        rules.addAll(this.propertyReactiveMap.getOrDefault(clazz, Collections.emptyMap()).getOrDefault(property, AnalyzedRuleSet.EMPTY));
        rules.addAll(this.classReativeMap.getOrDefault(clazz, AnalyzedRuleSet.EMPTY));
        return rules;
    }

    private static class AnalyzedRuleSet
    implements Collection<AnalyzedRule> {
        private static final AnalyzedRuleSet EMPTY = new AnalyzedRuleSet();
        private final Map<Rule, AnalyzedRule> rules = new HashMap<Rule, AnalyzedRule>();

        private AnalyzedRuleSet() {
        }

        @Override
        public int size() {
            return this.rules.size();
        }

        @Override
        public boolean isEmpty() {
            return this.rules.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof AnalyzedRule ? this.rules.containsKey(((AnalyzedRule)o).getRule()) : false;
        }

        @Override
        public Iterator<AnalyzedRule> iterator() {
            return this.rules.values().iterator();
        }

        @Override
        public Object[] toArray() {
            return this.rules.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.rules.keySet().toArray(new AnalyzedRule[this.rules.size()]);
        }

        @Override
        public boolean add(AnalyzedRule analyzedRule) {
            AnalyzedRule existingRule = this.rules.get(analyzedRule.getRule());
            if (existingRule == null) {
                this.rules.put(analyzedRule.getRule(), analyzedRule);
                return true;
            }
            existingRule.combineReactivityType(analyzedRule.getReactivityType());
            return false;
        }

        @Override
        public void clear() {
            this.rules.clear();
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof AnalyzedRule) {
                return this.rules.remove(((AnalyzedRule)o).getRule()) != null;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.stream().allMatch(this::contains);
        }

        @Override
        public boolean addAll(Collection<? extends AnalyzedRule> c) {
            boolean result = false;
            for (AnalyzedRule analyzedRule : c) {
                if (!this.add(analyzedRule)) continue;
                result = true;
            }
            return result;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean result = false;
            for (Object o : c) {
                if (!(o instanceof AnalyzedRule) || !this.remove(o)) continue;
                result = true;
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }
}

