/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.graph;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.Link;
import org.drools.impact.analysis.graph.Node;

public class TextReporter {
    public static String INDENT = "  ";

    private TextReporter() {
    }

    public static String toFlatText(Graph g) {
        StringBuilder sb = new StringBuilder();
        List keyList = g.getNodeMap().keySet().stream().sorted().collect(Collectors.toList());
        for (String key : keyList) {
            Node node = g.getNodeMap().get(key);
            TextReporter.appendNodeText(sb, node);
        }
        return sb.toString();
    }

    private static void appendNodeText(StringBuilder sb, Node node) {
        String ruleName = node.getRuleName();
        sb.append(ruleName);
        sb.append(TextReporter.statusToMark(node.getStatus()));
        sb.append(System.lineSeparator());
    }

    private static String statusToMark(Node.Status status) {
        switch (status) {
            case CHANGED: {
                return "[*]";
            }
            case IMPACTED: {
                return "[+]";
            }
            case TARGET: {
                return "[@]";
            }
            case IMPACTING: {
                return "[!]";
            }
        }
        return "";
    }

    public static String toHierarchyText(Graph g) {
        StringBuilder sb = new StringBuilder();
        List keyList = g.getNodeMap().keySet().stream().sorted().collect(Collectors.toList());
        HashSet<Node> pickedNodeSet = new HashSet<Node>();
        for (String key : keyList) {
            Node node = g.getNodeMap().get(key);
            if (pickedNodeSet.contains(node)) continue;
            TextReporter.addNode(g, node, "", pickedNodeSet, sb);
        }
        return sb.toString();
    }

    private static void addNode(Graph g, Node node, String indent, Set<Node> pickedNodeSet, StringBuilder sb) {
        sb.append(indent);
        TextReporter.appendNodeText(sb, node);
        pickedNodeSet.add(node);
        for (Link link : node.getOutgoingLinks()) {
            Node target = link.getTarget();
            if (!g.getNodeMap().containsValue(target)) continue;
            if (pickedNodeSet.contains(target)) {
                TextReporter.addNodeWithoutCircular(target, indent + INDENT, sb);
                continue;
            }
            TextReporter.addNode(g, target, indent + INDENT, pickedNodeSet, sb);
        }
    }

    private static void addNodeWithoutCircular(Node node, String indent, StringBuilder sb) {
        sb.append(indent);
        sb.append("(" + node.getRuleName() + ")" + System.lineSeparator());
    }
}

