/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.graph.graphviz;

import guru.nidi.graphviz.engine.Graphviz;
import java.io.File;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.Node;
import org.drools.impact.analysis.graph.ReactivityType;
import org.drools.impact.analysis.graph.graphviz.GraphImageGenerator;
import org.drools.impact.analysis.model.Rule;
import org.junit.After;
import org.junit.Test;

public class GraphvizOutputTest {
    @After
    public void tearDown() {
        Graphviz.releaseEngine();
    }

    @Test
    public void generate_simpleGraph() throws URISyntaxException {
        Graph graph = this.createSimpleGraph();
        GraphImageGenerator generator = new GraphImageGenerator("simple");
        String filePath = generator.generateDot(graph);
        File actual = new File(filePath);
        File expected = new File(this.getClass().getResource("simple.dot").toURI());
        Assertions.assertThat((List)Assertions.linesOf((File)actual)).containsExactlyInAnyOrderElementsOf((Iterable)Assertions.linesOf((File)expected));
        generator.generateSvg(graph);
        generator.generatePng(graph);
    }

    private Graph createSimpleGraph() {
        Node node1 = new Node(new Rule("org.example", "rule1", "example"));
        Node node2 = new Node(new Rule("org.example", "rule2", "example"));
        Node node3 = new Node(new Rule("org.example", "rule3", "example"));
        Node node4 = new Node(new Rule("org.example", "rule4", "example"));
        Node node5 = new Node(new Rule("org.example", "rule5", "example"));
        Node.linkNodes((Node)node1, (Node)node2, (ReactivityType)ReactivityType.POSITIVE);
        Node.linkNodes((Node)node1, (Node)node3, (ReactivityType)ReactivityType.NEGATIVE);
        Node.linkNodes((Node)node2, (Node)node4, (ReactivityType)ReactivityType.UNKNOWN);
        Node.linkNodes((Node)node3, (Node)node5, (ReactivityType)ReactivityType.POSITIVE);
        HashMap<String, Node> nodeMap = new HashMap<String, Node>();
        nodeMap.put(node1.getFqdn(), node1);
        nodeMap.put(node2.getFqdn(), node2);
        nodeMap.put(node3.getFqdn(), node3);
        nodeMap.put(node4.getFqdn(), node4);
        nodeMap.put(node5.getFqdn(), node5);
        Graph graph = new Graph(nodeMap);
        return graph;
    }

    @Test
    public void generate_simulateEngineFailure() throws URISyntaxException {
        Graph graph = this.createSimpleGraph();
        GraphImageGenerator generator = GraphImageGenerator.getGraphImageGeneratorWithErrorGraphvizEngine((String)"simple");
        String filePathDot = generator.generateDot(graph);
        File actual = new File(filePathDot);
        File expected = new File(this.getClass().getResource("simple.dot").toURI());
        Assertions.assertThat((List)Assertions.linesOf((File)actual)).containsExactlyInAnyOrderElementsOf((Iterable)Assertions.linesOf((File)expected));
        String filePathSvg = generator.generateSvg(graph);
        Assertions.assertThat((String)filePathSvg).isNull();
        String filePathPng = generator.generatePng(graph);
        Assertions.assertThat((String)filePathPng).isNull();
    }
}

