/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.integrationtests;

import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.ModelToGraphConverter;
import org.drools.impact.analysis.graph.ReactivityType;
import org.drools.impact.analysis.integrationtests.AbstractGraphTest;
import org.drools.impact.analysis.integrationtests.domain.Address;
import org.drools.impact.analysis.integrationtests.domain.Person;
import org.drools.impact.analysis.model.AnalysisModel;
import org.drools.impact.analysis.parser.ModelBuilder;
import org.junit.Test;

public class PropertyTest
extends AbstractGraphTest {
    @Test
    public void testNestedProperty() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\n  $p : Person()\nthen\n  modify ($p) {getAddress().setNumber(10)};end\nrule R2 when\n  $p : Person(address.number == 10)\nthen\nend\n";
        this.runRule(str, new Object[]{new Person("John", 20, new Address())});
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.UNKNOWN);
        this.generatePng(graph);
    }

    @Test
    public void testPropertyInFunction() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\n  $p : Person()\nthen\n  modify ($p) {setAge(42)};end\nrule R2 when\n  $p : Person(calculateToMonth(age) > 480)\nthen\nend\n";
        this.runRule(str, new Object[]{new Person("John")});
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.UNKNOWN);
        this.generatePng(graph);
    }
}

