/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.integrationtests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.drools.core.event.DefaultAgendaEventListener;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.Node;
import org.drools.impact.analysis.graph.ReactivityType;
import org.drools.impact.analysis.graph.graphviz.GraphImageGenerator;
import org.drools.impact.analysis.integrationtests.RuleExecutionHelper;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractGraphTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractGraphTest.class);
    @Rule
    public TestName testName = new TestName();

    protected String getTestMethodName() {
        return this.testName.getMethodName();
    }

    protected void generatePng(Graph graph) {
        this.generatePng(graph, "");
    }

    protected void generateSvg(Graph graph) {
        this.generateSvg(graph, "");
    }

    protected void generatePng(Graph graph, String suffix) {
        GraphImageGenerator generator = new GraphImageGenerator(this.getTestMethodName() + suffix);
        generator.generatePng(graph);
    }

    protected void generateSvg(Graph graph, String suffix) {
        GraphImageGenerator generator = new GraphImageGenerator(this.getTestMethodName() + suffix);
        generator.generateSvg(graph);
    }

    protected void assertLink(Graph graph, String sourceFqdn, String targetFqdn, ReactivityType ... expectedTypes) {
        Node source = (Node)graph.getNodeMap().get(sourceFqdn);
        Node target = (Node)graph.getNodeMap().get(targetFqdn);
        List outgoingLinks = source.getOutgoingLinks().stream().filter(l -> l.getTarget().equals((Object)target)).collect(Collectors.toList());
        List incomingLinks = target.getIncomingLinks().stream().filter(l -> l.getSource().equals((Object)source)).collect(Collectors.toList());
        Assertions.assertThat(outgoingLinks).hasSameElementsAs(incomingLinks);
        List outgoingLinkTypelist = outgoingLinks.stream().map(l -> l.getReactivityType()).collect(Collectors.toList());
        List<ReactivityType> expectedTypeList = Arrays.asList(expectedTypes);
        Assertions.assertThat(outgoingLinkTypelist).hasSameElementsAs(expectedTypeList);
    }

    protected void runRule(String drl, Object ... facts) {
        KieSession ksession = RuleExecutionHelper.getKieSession(drl);
        ksession.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void afterMatchFired(AfterMatchFiredEvent event) {
                logger.info(event.getMatch().getRule().getName() + " : fired");
            }
        });
        for (Object fact : facts) {
            ksession.insert(fact);
        }
        int fired = ksession.fireAllRules(100);
        logger.info("fired = " + fired);
        ksession.dispose();
    }

    protected void runRule(KieFileSystem kfs, Object ... facts) {
        KieSession ksession = RuleExecutionHelper.getKieSession(kfs);
        for (Object fact : facts) {
            ksession.insert(fact);
        }
        int fired = ksession.fireAllRules(100);
        logger.info("fired = " + fired);
        ksession.dispose();
    }

    protected KieFileSystem createKieFileSystemWithClassPathResourceNames(ReleaseId releaseId, Class<?> classForClassLoader, String ... resourceNames) throws IOException {
        KieServices ks = KieServices.Factory.get();
        KieResources kieResources = ks.getResources();
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (String resourceName : resourceNames) {
            Resource resource = kieResources.newClassPathResource(resourceName, classForClassLoader);
            resource.setSourcePath("src/main/resources/" + resource.getSourcePath());
            resourceList.add(resource);
        }
        return this.createKieFileSystem(releaseId, resourceList.toArray(new Resource[0]));
    }

    protected KieFileSystem createKieFileSystem(ReleaseId releaseId, Resource ... resources) throws IOException {
        KieServices ks = KieServices.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writePomXML(RuleExecutionHelper.getPom(releaseId));
        for (Resource resource : resources) {
            kfs.write(resource.getSourcePath(), resource);
        }
        return kfs;
    }
}

