/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.integrationtests;

import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.ModelToGraphConverter;
import org.drools.impact.analysis.graph.ReactivityType;
import org.drools.impact.analysis.integrationtests.AbstractGraphTest;
import org.drools.impact.analysis.integrationtests.domain.Address;
import org.drools.impact.analysis.integrationtests.domain.ControlFact;
import org.drools.impact.analysis.integrationtests.domain.FunctionUtils;
import org.drools.impact.analysis.integrationtests.domain.Person;
import org.drools.impact.analysis.integrationtests.domain.ProductItem;
import org.drools.impact.analysis.model.AnalysisModel;
import org.drools.impact.analysis.parser.ModelBuilder;
import org.junit.Test;

public class SpecialUsageTest
extends AbstractGraphTest {
    @Test
    public void testModifyMap() {
        String str = "package mypkg;\nimport " + ControlFact.class.getCanonicalName() + ";dialect \"mvel\"rule R1 when\n  $c : ControlFact()\nthen\n  $c.mapData[\"Key1\"] = \"Value1\";  modify ($c) {mapData = $c.mapData};end\nrule R2 when\n  $c : ControlFact(mapData[\"Key1\"] == \"Value1\")\nthen\nend\nrule R3 when\n  $c : ControlFact(mapData[\"Key1\"] != \"Value1\")\nthen\nend\nrule R4 when\n  $c : ControlFact(mapData[\"Key2\"] == \"Value1\")\nthen\nend\nrule R5 when\n  $c : ControlFact(mapData[\"Key1\"] == \"Value2\")\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R4", ReactivityType.UNKNOWN);
        this.assertLink(graph, "mypkg.R1", "mypkg.R5", ReactivityType.NEGATIVE);
    }

    @Test
    public void testModifyMapInt() {
        String str = "package mypkg;\nimport " + ControlFact.class.getCanonicalName() + ";dialect \"mvel\"rule R1 when\n  $c : ControlFact()\nthen\n  $c.mapDataInt[\"Key1\"] = 100;  modify ($c) {mapDataInt = $c.mapDataInt};end\nrule R2 when\n  $c : ControlFact(mapDataInt[\"Key1\"] == 100)\nthen\nend\nrule R3 when\n  $c : ControlFact(mapDataInt[\"Key1\"] != 100)\nthen\nend\nrule R4 when\n  $c : ControlFact(mapDataInt[\"Key2\"] == 100)\nthen\nend\nrule R5 when\n  $c : ControlFact(mapDataInt[\"Key1\"] == 200)\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R4", ReactivityType.UNKNOWN);
        this.assertLink(graph, "mypkg.R1", "mypkg.R5", ReactivityType.NEGATIVE);
    }

    @Test
    public void testInsertWithValue() {
        String str = "package mypkg;\nimport " + ControlFact.class.getCanonicalName() + ";dialect \"mvel\"rule R1 when\n  $c : ControlFact(keyword == \"ABC\", $orderId : orderId)\nthen\n  ControlFact $newFact = new ControlFact();  $newFact.keyword = \"DEF\";  $newFact.orderId = $orderId;  insert($newFact);end\nrule R2 when\n  $c : ControlFact(keyword == \"DEF\")\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
    }

    @Test
    public void testExistsNot() {
        String str = "package mypkg;\nimport " + ControlFact.class.getCanonicalName() + ";dialect \"mvel\"rule R1 when\n  $c : ControlFact(keyword == \"ABC\", $orderId : orderId)\nthen\n  ControlFact $newFact = new ControlFact();  $newFact.keyword = \"DEF\";  $newFact.orderId = $orderId;  insert($newFact);end\nrule R2 when\n  $c : ControlFact(keyword == \"ABC\")\n  exists(not ControlFact(keyword == \"DEF\", $orderId : orderId))\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.NEGATIVE, ReactivityType.UNKNOWN);
    }

    @Test
    public void testMapWithFunction() {
        String str = "package mypkg;\nimport " + ControlFact.class.getCanonicalName() + ";import " + ProductItem.class.getCanonicalName() + ";import static " + FunctionUtils.class.getCanonicalName() + ".convertMapToBigDecimal;dialect \"mvel\"rule R1 when\n  $c : ControlFact()\nthen\n  $c.mapData[\"Price\"] = \"100.0\";  modify ($c) {mapData = $c.mapData};end\nrule R2 when\n  ControlFact($price : convertMapToBigDecimal(mapData, \"Price\"))\n  ProductItem(price == $price)\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.UNKNOWN);
    }

    @Test
    public void testBindVariableLiteralModify() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\n  $p : Person($data : \"ABC\")\nthen\n  modify($p) { setLikes( $data ) };end\nrule R2 when\n  $p : Person(likes == \"ABC\")\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
    }

    @Test
    public void testBindVariableLiteralInsert() {
        String str = "package mypkg;\nimport " + Address.class.getCanonicalName() + ";import " + Person.class.getCanonicalName() + ";rule R1 when\n  Address(city == \"Tokyo\", $data : \"ABC\")\nthen\n  Person person = new Person(\"John\");\n  person.setLikes($data);\n  insert(person);\nend\nrule R2 when\n  $p : Person(likes == \"ABC\")\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
    }

    @Test
    public void testBindVariableLiteralModifyMap() {
        String str = "package mypkg;\nimport " + ControlFact.class.getCanonicalName() + ";dialect \"mvel\"rule R1\nwhen\n  $c : ControlFact( $value : \"Value1\" )\nthen\n  $c.mapData[\"Key1\"] = $value;\n  modify ($c) {mapData = $c.mapData};\nend\nrule R2 when\n  $c : ControlFact(mapData[\"Key1\"] == \"Value1\")\nthen\nend";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
    }
}

