/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.integrationtests;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.core.util.StringUtils;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.ModelToGraphConverter;
import org.drools.impact.analysis.graph.ReactivityType;
import org.drools.impact.analysis.integrationtests.AbstractGraphTest;
import org.drools.impact.analysis.integrationtests.domain.PropHolder;
import org.drools.impact.analysis.model.AnalysisModel;
import org.drools.impact.analysis.parser.ModelBuilder;
import org.junit.Test;

public class TypeTest
extends AbstractGraphTest {
    @Test
    public void testBooleanPrimitive() {
        this.testLiteralsEqualityMvel("booleanPrimitive", "true", "false");
        this.testLiteralsEqualityJava("booleanPrimitive", "true", "false");
    }

    @Test
    public void testCharPrimitive() {
        this.testLiteralsEqualityJava("charPrimitive", "'a'", "'b'");
    }

    @Test
    public void testBytePrimitive() {
        this.testLiteralsEqualityMvel("bytePrimitive", "(byte)0", "(byte)1");
        this.testLiteralsEqualityJava("bytePrimitive", "(byte)0", "(byte)1");
    }

    @Test
    public void testShortPrimitive() {
        this.testLiteralsEqualityMvel("shortPrimitive", "(short)0", "(short)1");
        this.testLiteralsEqualityJava("shortPrimitive", "(short)0", "(short)1");
    }

    @Test
    public void testIntPrimitive() {
        this.testLiteralsEqualityMvel("intPrimitive", "0", "1");
        this.testLiteralsEqualityJava("intPrimitive", "0", "1");
    }

    @Test
    public void testLongPrimitive() {
        this.testLiteralsEqualityMvel("longPrimitive", "0l", "1l");
        this.testLiteralsEqualityJava("longPrimitive", "0l", "1l");
    }

    @Test
    public void testFloatPrimitive() {
        this.testLiteralsInequalityMvel("floatPrimitive", "0.1f", "0.2f", "0.15f");
        this.testLiteralsInequalityJava("floatPrimitive", "0.1f", "0.2f", "0.15f");
    }

    @Test
    public void testDoublePrimitive() {
        this.testLiteralsInequalityMvel("doublePrimitive", "0.1d", "0.2d", "0.15d");
        this.testLiteralsInequalityJava("doublePrimitive", "0.1d", "0.2d", "0.15d");
    }

    @Test
    public void testBooleanWrapper() {
        this.testLiteralsEqualityMvel("booleanWrapper", "true", "false");
        this.testLiteralsEqualityJava("booleanWrapper", "true", "false");
    }

    @Test
    public void testCharWrapper() {
        this.testLiteralsEqualityJava("charWrapper", "'a'", "'b'");
    }

    @Test
    public void testByteWrapper() {
        this.testLiteralsEqualityMvel("byteWrapper", "(byte)0", "(byte)1");
        this.testLiteralsEqualityJava("byteWrapper", "(byte)0", "(byte)1");
    }

    @Test
    public void testShortWrapper() {
        this.testLiteralsEqualityMvel("shortWrapper", "(short)0", "(short)1");
        this.testLiteralsEqualityJava("shortWrapper", "(short)0", "(short)1");
    }

    @Test
    public void testIntWrapper() {
        this.testLiteralsEqualityMvel("intWrapper", "0", "1");
        this.testLiteralsEqualityJava("intWrapper", "0", "1");
    }

    @Test
    public void testLongWrapper() {
        this.testLiteralsEqualityMvel("longWrapper", "0l", "1l");
        this.testLiteralsEqualityJava("longWrapper", "0l", "1l");
    }

    @Test
    public void testFloatWrapper() {
        this.testLiteralsInequalityMvel("floatWrapper", "0.1f", "0.2f", "0.15f");
        this.testLiteralsInequalityJava("floatWrapper", "0.1f", "0.2f", "0.15f");
    }

    @Test
    public void testDoubleWrapper() {
        this.testLiteralsInequalityMvel("doubleWrapper", "0.1d", "0.2d", "0.15d");
        this.testLiteralsInequalityJava("doubleWrapper", "0.1d", "0.2d", "0.15d");
    }

    @Test
    public void testString() {
        this.testLiteralsEqualityMvel("stringAttribute", "\"ABC\"", "\"XYZ\"");
        this.testLiteralsEqualityJava("stringAttribute", "\"ABC\"", "\"XYZ\"");
    }

    @Test
    public void testObjectString() {
        this.testLiteralsEqualityMvel("object", "\"ABC\"", "\"XYZ\"");
        this.testLiteralsEqualityJava("object", "\"ABC\"", "\"XYZ\"");
    }

    @Test
    public void testBigDecimal() {
        this.testLiteralsEqualityMvel("bigDecimal", "10.1B", "10.2B");
        this.testLiteralsEqualityJava("bigDecimal", "new BigDecimal(\"10.1\")", "new BigDecimal(\"10.2\")");
    }

    @Test
    public void testBigInteger() {
        this.testLiteralsEqualityMvel("bigInteger", "0I", "1I");
        this.testLiteralsEqualityJava("bigInteger", "new BigInteger(\"0\")", "new BigInteger(\"1\")");
    }

    private void testLiteralsEqualityMvel(String propName, String value1, String value2) {
        this.testLiteralsEquality(propName, value1, value2, "mvel");
    }

    private void testLiteralsEqualityJava(String propName, String value1, String value2) {
        this.testLiteralsEquality(propName, value1, value2, "java");
    }

    private void testLiteralsEquality(String propName, String value1, String value2, String dialect) {
        String setter = "set" + StringUtils.ucFirst((String)propName);
        String str = "package mypkg;\nimport " + BigDecimal.class.getCanonicalName() + ";\nimport " + BigInteger.class.getCanonicalName() + ";\nimport " + PropHolder.class.getCanonicalName() + ";\ndialect \"" + dialect + "\"\nrule R1 when\n  $p : PropHolder(id == 0)\nthen\n  modify ($p) {" + setter + "(" + value1 + ")};\nend\nrule R2 when\n  $p : PropHolder(id == 1)\nthen\n  modify ($p) {" + setter + "(" + value2 + ")};\nend\nrule R3 when\n  $p : PropHolder(" + propName + " == " + value1 + ")\nthen\nend\nrule R4 when\n  $p : PropHolder(" + propName + " == " + value2 + ")\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R4", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R2", "mypkg.R3", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R2", "mypkg.R4", ReactivityType.POSITIVE);
    }

    private void testLiteralsInequalityMvel(String propName, String value1, String value2, String thresholdValue) {
        this.testLiteralsInequality(propName, value1, value2, thresholdValue, "mvel");
    }

    private void testLiteralsInequalityJava(String propName, String value1, String value2, String thresholdValue) {
        this.testLiteralsInequality(propName, value1, value2, thresholdValue, "java");
    }

    private void testLiteralsInequality(String propName, String value1, String value2, String thresholdValue, String dialect) {
        String setter = "set" + StringUtils.ucFirst((String)propName);
        String str = "package mypkg;\nimport " + PropHolder.class.getCanonicalName() + ";\ndialect \"" + dialect + "\"\nrule R1 when\n  $p : PropHolder(id == 0)\nthen\n  modify ($p) {" + setter + "(" + value1 + ")};\nend\nrule R2 when\n  $p : PropHolder(id == 1)\nthen\n  modify ($p) {" + setter + "(" + value2 + ")};\nend\nrule R3 when\n  $p : PropHolder(" + propName + " < " + thresholdValue + ")\nthen\nend\nrule R4 when\n  $p : PropHolder(" + propName + " > " + thresholdValue + ")\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R4", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R2", "mypkg.R3", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R2", "mypkg.R4", ReactivityType.POSITIVE);
    }
}

