/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.integrationtests;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.ImpactAnalysisHelper;
import org.drools.impact.analysis.graph.ModelToGraphConverter;
import org.drools.impact.analysis.graph.Node;
import org.drools.impact.analysis.graph.TextReporter;
import org.drools.impact.analysis.integrationtests.AbstractGraphTest;
import org.drools.impact.analysis.integrationtests.domain.Order;
import org.drools.impact.analysis.model.AnalysisModel;
import org.drools.impact.analysis.parser.ModelBuilder;
import org.junit.Assert;
import org.junit.Test;

public class ImpactAnalysisTest
extends AbstractGraphTest {
    @Test
    public void testOrderRules() {
        String str = "package mypkg;\nimport " + Order.class.getCanonicalName() + ";\nrule R1\n  when\n    $o : Order(customerMembershipRank > 5)\n  then\n    modify($o) {\n      setDiscount(1000);\n    }\nend\n\nrule R2\n  when\n    $o : Order(customerAge > 60)\n  then\n    modify($o) {\n      setDiscount(2000);\n    }\nend\n\nrule R3\n  when\n    $o : Order(itemPrice < 2000, discount >= 2000)\n  then\n    modify($o) {\n      setStatus(\"Too much discount\");\n    }\nend\n\nrule R4\n  when\n    $o : Order(itemPrice > 5000)\n  then\n    modify($o) {\n      setStatus(\"Exclusive order\");\n    }\nend\n\nrule R5\n  when\n    $o : Order(status == \"Too much discount\")\n  then\n    modify($o) {\n      setDiscount(500);\n    }\nend\n\nrule R6\n  when\n    Order(status == \"Exclusive order\")\n  then\n    // Do some work...\nend";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.generatePng(graph, "_all");
        Node changedNode = (Node)graph.getNodeMap().get("mypkg.R2");
        ImpactAnalysisHelper impactFilter = new ImpactAnalysisHelper();
        Graph impactedSubGraph = impactFilter.filterImpactedNodes(graph, changedNode);
        this.generatePng(impactedSubGraph, "_impactedSubGraph");
        this.generatePng(graph, "_impacted");
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg.R1"));
        Assert.assertEquals((Object)Node.Status.CHANGED, (Object)((Node)impactedSubGraph.getNodeMap().get("mypkg.R2")).getStatus());
        Assert.assertEquals((Object)Node.Status.IMPACTED, (Object)((Node)impactedSubGraph.getNodeMap().get("mypkg.R3")).getStatus());
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg.R4"));
        Assert.assertEquals((Object)Node.Status.IMPACTED, (Object)((Node)impactedSubGraph.getNodeMap().get("mypkg.R5")).getStatus());
        Assert.assertEquals((Object)Node.Status.IMPACTED, (Object)((Node)impactedSubGraph.getNodeMap().get("mypkg.R6")).getStatus());
        System.out.println("--- toHierarchyText ---");
        String hierarchyText = TextReporter.toHierarchyText((Graph)impactedSubGraph);
        System.out.println(hierarchyText);
        List<String> lines = Arrays.asList(hierarchyText.split(System.lineSeparator()));
        Assertions.assertThat(lines).containsExactlyInAnyOrder((Object[])new String[]{"R2[*]", TextReporter.INDENT + "R3[+]", TextReporter.INDENT + TextReporter.INDENT + "R6[+]", TextReporter.INDENT + TextReporter.INDENT + "R5[+]", TextReporter.INDENT + TextReporter.INDENT + TextReporter.INDENT + "(R3)"});
        System.out.println("--- toFlatText ---");
        String flatText = TextReporter.toFlatText((Graph)impactedSubGraph);
        System.out.println(flatText);
        List<String> lines2 = Arrays.asList(flatText.split(System.lineSeparator()));
        Assertions.assertThat(lines2).containsExactlyInAnyOrder((Object[])new String[]{"R2[*]", "R3[+]", "R6[+]", "R5[+]"});
    }
}

