/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.integrationtests;

import java.io.IOException;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.GraphCollapsionHelper;
import org.drools.impact.analysis.graph.ImpactAnalysisHelper;
import org.drools.impact.analysis.graph.ModelToGraphConverter;
import org.drools.impact.analysis.graph.Node;
import org.drools.impact.analysis.graph.ReactivityType;
import org.drools.impact.analysis.integrationtests.AbstractGraphTest;
import org.drools.impact.analysis.integrationtests.domain.Order;
import org.drools.impact.analysis.model.AnalysisModel;
import org.drools.impact.analysis.parser.ModelBuilder;
import org.drools.impact.analysis.parser.internal.ImpactAnalysisKieModule;
import org.drools.impact.analysis.parser.internal.ImpactAnalysisProject;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;

public class GraphCollapsionTest
extends AbstractGraphTest {
    @Test
    public void testDrlRuleNamePrefix() {
        String str = "package mypkg;\nimport " + Order.class.getCanonicalName() + ";\nrule CustomerCheck_1\n  when\n    $o : Order(customerMembershipRank > 5)\n  then\n    modify($o) {\n      setDiscount(1000);\n    }\nend\n\nrule CustomerCheck_2\n  when\n    $o : Order(customerAge > 60)\n  then\n    modify($o) {\n      setDiscount(2000);\n    }\nend\n\nrule PriceCheck_1\n  when\n    $o : Order(itemPrice < 2000, discount >= 2000)\n  then\n    modify($o) {\n      setStatus(\"Too much discount\");\n    }\nend\n\nrule PriceCheck_2\n  when\n    $o : Order(itemPrice > 5000)\n  then\n    modify($o) {\n      setStatus(\"Exclusive order\");\n    }\nend\n\nrule StatusCheck_1\n  when\n    $o : Order(status == \"Too much discount\")\n  then\n    modify($o) {\n      setDiscount(500);\n    }\nend\n\nrule StatusCheck_2\n  when\n    Order(status == \"Exclusive order\")\n  then\n    // Do some work...\nend";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        Graph collapsedGraph = new GraphCollapsionHelper().collapseWithRuleNamePrefix(graph);
        this.generatePng(collapsedGraph);
        Assert.assertEquals((long)3L, (long)collapsedGraph.getNodeMap().size());
        this.assertLink(collapsedGraph, "mypkg.CustomerCheck", "mypkg.PriceCheck", ReactivityType.POSITIVE, ReactivityType.NEGATIVE);
        this.assertLink(collapsedGraph, "mypkg.PriceCheck", "mypkg.StatusCheck", ReactivityType.POSITIVE, ReactivityType.NEGATIVE);
        this.assertLink(collapsedGraph, "mypkg.StatusCheck", "mypkg.PriceCheck", ReactivityType.NEGATIVE);
        Node changedNode = (Node)collapsedGraph.getNodeMap().get("mypkg.PriceCheck");
        ImpactAnalysisHelper impactFilter = new ImpactAnalysisHelper();
        Graph impactedSubGraph = impactFilter.filterImpactedNodes(collapsedGraph, changedNode);
        this.generatePng(impactedSubGraph, "_impactedSubGraph");
        this.generatePng(collapsedGraph, "_impacted");
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg.CustomerCheck"));
        Assert.assertEquals((Object)Node.Status.CHANGED, (Object)((Node)impactedSubGraph.getNodeMap().get("mypkg.PriceCheck")).getStatus());
        Assert.assertEquals((Object)Node.Status.IMPACTED, (Object)((Node)impactedSubGraph.getNodeMap().get("mypkg.StatusCheck")).getStatus());
    }

    @Test
    public void testSpreadsheet() throws IOException {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.drools.impact.analysis.integrationtests", "spreadsheet-test", "1.0.0");
        KieFileSystem kfs = this.createKieFileSystemWithClassPathResourceNames(releaseId, this.getClass(), "collapsion01.xls", "collapsion02.xls", "collapsion03.xls");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(ImpactAnalysisProject.class);
        ImpactAnalysisKieModule analysisKieModule = (ImpactAnalysisKieModule)kieBuilder.getKieModule();
        AnalysisModel analysisModel = analysisKieModule.getAnalysisModel();
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        Graph collapsedGraph = new GraphCollapsionHelper().collapseWithRuleNamePrefix(graph);
        this.generatePng(collapsedGraph, "_collapsed");
        Assert.assertEquals((long)3L, (long)collapsedGraph.getNodeMap().size());
        this.assertLink(collapsedGraph, "mypkg2.CustomerCheck", "mypkg2.PriceCheck", ReactivityType.POSITIVE, ReactivityType.NEGATIVE);
        this.assertLink(collapsedGraph, "mypkg2.PriceCheck", "mypkg2.StatusCheck", ReactivityType.POSITIVE, ReactivityType.NEGATIVE);
        this.assertLink(collapsedGraph, "mypkg2.StatusCheck", "mypkg2.PriceCheck", ReactivityType.NEGATIVE);
        Node changedNode = (Node)collapsedGraph.getNodeMap().get("mypkg2.PriceCheck");
        ImpactAnalysisHelper impactFilter = new ImpactAnalysisHelper();
        Graph impactedSubGraph = impactFilter.filterImpactedNodes(collapsedGraph, changedNode);
        this.generatePng(impactedSubGraph, "_impactedSubGraph");
        this.generatePng(collapsedGraph, "_impacted");
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg2.CustomerCheck"));
        Assert.assertEquals((Object)Node.Status.CHANGED, (Object)((Node)impactedSubGraph.getNodeMap().get("mypkg2.PriceCheck")).getStatus());
        Assert.assertEquals((Object)Node.Status.IMPACTED, (Object)((Node)impactedSubGraph.getNodeMap().get("mypkg2.StatusCheck")).getStatus());
    }
}

