/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.integrationtests;

import java.util.List;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.ModelToGraphConverter;
import org.drools.impact.analysis.graph.ReactivityType;
import org.drools.impact.analysis.integrationtests.AbstractGraphTest;
import org.drools.impact.analysis.integrationtests.domain.Address;
import org.drools.impact.analysis.integrationtests.domain.Person;
import org.drools.impact.analysis.model.AnalysisModel;
import org.drools.impact.analysis.parser.ModelBuilder;
import org.junit.Test;

public class RhsTest
extends AbstractGraphTest {
    @Test
    public void testForEachInsert() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";import " + Address.class.getCanonicalName() + ";rule R1\n  when\n    $person : Person()\n  then\n    for(Address $address : $person.getAddresses()){\n      insert($address);\n    }\nend\nrule R2\n  when\n    Address()\n  then\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
    }

    @Test
    public void testForEachDelete() {
        String str = "package mypkg;\nimport " + List.class.getCanonicalName() + ";rule R1\n  when\n    $objectList : List() from collect(Object())\n  then\n    for(Object $object : $objectList){\n      delete($object);\n    }\nend";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R1", new ReactivityType[0]);
    }
}

