/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.integrationtests;

import java.util.ArrayList;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.ModelToGraphConverter;
import org.drools.impact.analysis.graph.ReactivityType;
import org.drools.impact.analysis.integrationtests.AbstractGraphTest;
import org.drools.impact.analysis.integrationtests.domain.Address;
import org.drools.impact.analysis.integrationtests.domain.Person;
import org.drools.impact.analysis.model.AnalysisModel;
import org.drools.impact.analysis.parser.ModelBuilder;
import org.junit.Test;

public class DrlSyntaxTest
extends AbstractGraphTest {
    @Test
    public void testExists1() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\nthen\n  insert(new Person());end\nrule R2 when\n  exists (Person())\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
    }

    @Test
    public void testExists2() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";import " + Address.class.getCanonicalName() + ";rule R1 when\n  $p : Person()\nthen\n  delete($p);end\nrule R2 when\n  exists (Person())\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R1", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.NEGATIVE);
    }

    @Test
    public void testNot1() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\nthen\n  insert(new Person());end\nrule R2 when\n  not (Person())\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.NEGATIVE);
    }

    @Test
    public void testNot2() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";import " + Address.class.getCanonicalName() + ";rule R1 when\n  $p : Person()\nthen\n  delete($p);end\nrule R2 when\n  not (Person())\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R1", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
    }

    @Test
    public void testGlobal() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";global java.util.List resultList;rule R1 when\n  $p : Person(name == \"Mario\")\nthen\n  modify($p) { setAge( 18 ) };  insert(\"Done\");\nend\nrule R2 when\n  $p : Person(age > 15)\nthen\nend\nrule R3 when\n  $p : String(this == \"Done\")\nthen\n  resultList.add($p);end\n";
        ArrayList resultList = new ArrayList();
        this.runRuleWithGlobal(str, "resultList", resultList, new Object[]{new Person("Mario", 10)});
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", ReactivityType.POSITIVE);
    }
}

