/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.integrationtests;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.ImpactAnalysisHelper;
import org.drools.impact.analysis.graph.ModelToGraphConverter;
import org.drools.impact.analysis.graph.Node;
import org.drools.impact.analysis.graph.TextReporter;
import org.drools.impact.analysis.integrationtests.AbstractGraphTest;
import org.drools.impact.analysis.integrationtests.domain.Order;
import org.drools.impact.analysis.model.AnalysisModel;
import org.drools.impact.analysis.parser.ModelBuilder;
import org.junit.Assert;
import org.junit.Test;

public class ImpactAnalysisTest
extends AbstractGraphTest {
    private static final String ORDER_RULES = "package mypkg;\nimport " + Order.class.getCanonicalName() + ";\nrule R1\n  when\n    $o : Order(customerMembershipRank > 5)\n  then\n    modify($o) {\n      setDiscount(1000);\n    }\nend\n\nrule R2\n  when\n    $o : Order(customerAge > 60)\n  then\n    modify($o) {\n      setDiscount(2000);\n    }\nend\n\nrule R3\n  when\n    $o : Order(itemPrice < 2000, discount >= 2000)\n  then\n    modify($o) {\n      setStatus(\"Too much discount\");\n    }\nend\n\nrule R4\n  when\n    $o : Order(itemPrice > 5000)\n  then\n    modify($o) {\n      setStatus(\"Exclusive order\");\n    }\nend\n\nrule R5\n  when\n    $o : Order(status == \"Too much discount\")\n  then\n    modify($o) {\n      setDiscount(500);\n    }\nend\n\nrule R6\n  when\n    Order(status == \"Exclusive order\")\n  then\n    // Do some work...\nend";

    @Test
    public void testOrderRules() {
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{ORDER_RULES});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        ImpactAnalysisHelper impactFilter = new ImpactAnalysisHelper();
        Graph impactedSubGraph = impactFilter.filterImpactedNodes(graph, "mypkg.R2");
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg.R1"));
        Assert.assertEquals((Object)Node.Status.CHANGED, (Object)((Node)impactedSubGraph.getNodeMap().get("mypkg.R2")).getStatus());
        Assert.assertEquals((Object)Node.Status.IMPACTED, (Object)((Node)impactedSubGraph.getNodeMap().get("mypkg.R3")).getStatus());
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg.R4"));
        Assert.assertEquals((Object)Node.Status.IMPACTED, (Object)((Node)impactedSubGraph.getNodeMap().get("mypkg.R5")).getStatus());
        Assert.assertEquals((Object)Node.Status.IMPACTED, (Object)((Node)impactedSubGraph.getNodeMap().get("mypkg.R6")).getStatus());
        String hierarchyText = TextReporter.toHierarchyText((Graph)impactedSubGraph);
        List<String> lines = Arrays.asList(hierarchyText.split(System.lineSeparator()));
        Assertions.assertThat(lines).containsExactlyInAnyOrder((Object[])new String[]{"R2[*]", TextReporter.INDENT + "R3[+]", TextReporter.INDENT + TextReporter.INDENT + "R6[+]", TextReporter.INDENT + TextReporter.INDENT + "R5[+]", TextReporter.INDENT + TextReporter.INDENT + TextReporter.INDENT + "(R3)"});
        String flatText = TextReporter.toFlatText((Graph)impactedSubGraph);
        List<String> lines2 = Arrays.asList(flatText.split(System.lineSeparator()));
        Assertions.assertThat(lines2).containsExactlyInAnyOrder((Object[])new String[]{"R2[*]", "R3[+]", "R6[+]", "R5[+]"});
    }

    @Test
    public void testOrderRulesBackward() {
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{ORDER_RULES});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        ImpactAnalysisHelper impactFilter = new ImpactAnalysisHelper();
        Graph impactingSubGraph = impactFilter.filterImpactingNodes(graph, "mypkg.R5");
        Assert.assertEquals((Object)Node.Status.IMPACTING, (Object)((Node)impactingSubGraph.getNodeMap().get("mypkg.R1")).getStatus());
        Assert.assertEquals((Object)Node.Status.IMPACTING, (Object)((Node)impactingSubGraph.getNodeMap().get("mypkg.R2")).getStatus());
        Assert.assertEquals((Object)Node.Status.IMPACTING, (Object)((Node)impactingSubGraph.getNodeMap().get("mypkg.R3")).getStatus());
        Assert.assertEquals((Object)Node.Status.IMPACTING, (Object)((Node)impactingSubGraph.getNodeMap().get("mypkg.R4")).getStatus());
        Assert.assertEquals((Object)Node.Status.TARGET, (Object)((Node)impactingSubGraph.getNodeMap().get("mypkg.R5")).getStatus());
        Assert.assertNull(impactingSubGraph.getNodeMap().get("mypkg.R6"));
        String hierarchyText = TextReporter.toHierarchyText((Graph)impactingSubGraph);
        List<String> lines = Arrays.asList(hierarchyText.split(System.lineSeparator()));
        Assertions.assertThat(lines).containsExactlyInAnyOrder((Object[])new String[]{"R1[!]", TextReporter.INDENT + "R3[!]", TextReporter.INDENT + TextReporter.INDENT + "R5[@]", TextReporter.INDENT + TextReporter.INDENT + TextReporter.INDENT + "(R3)", "R2[!]", TextReporter.INDENT + "(R3)", "R4[!]", TextReporter.INDENT + "(R5)"});
        String flatText = TextReporter.toFlatText((Graph)impactingSubGraph);
        List<String> lines2 = Arrays.asList(flatText.split(System.lineSeparator()));
        Assertions.assertThat(lines2).containsExactlyInAnyOrder((Object[])new String[]{"R1[!]", "R2[!]", "R3[!]", "R4[!]", "R5[@]"});
    }
}

