/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.integrationtests;

import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.GraphCollapsionHelper;
import org.drools.impact.analysis.graph.ImpactAnalysisHelper;
import org.drools.impact.analysis.graph.LinkFilter;
import org.drools.impact.analysis.graph.ModelToGraphConverter;
import org.drools.impact.analysis.graph.ReactivityType;
import org.drools.impact.analysis.integrationtests.AbstractGraphTest;
import org.drools.impact.analysis.integrationtests.domain.Order;
import org.drools.impact.analysis.integrationtests.domain.Person;
import org.drools.impact.analysis.model.AnalysisModel;
import org.drools.impact.analysis.parser.ModelBuilder;
import org.junit.Assert;
import org.junit.Test;

public class LinkFilterTest
extends AbstractGraphTest {
    private static final String SIMPLE_RULE = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\n  $p : Person(name == \"John\")\nthen\n  modify($p) { setAge( 18 ), setLikes(\"cheddar\"), setEmployed(true) };end\nrule R2 when\n  $p : Person(age > 15)\nthen\nend\nrule R3 when\n  $p : Person(likes != \"cheddar\")\nthen\nend\nrule R4 when\n  $b : Boolean()\n  $p : Person(employed == $b)\nthen\nend\n";
    private static final String RULE_WITH_PREFIX = "package mypkg;\nimport " + Order.class.getCanonicalName() + ";\nrule CustomerCheck_1\n  when\n    $o : Order(customerMembershipRank > 5)\n  then\n    modify($o) {\n      setDiscount(1000);\n    }\nend\n\nrule CustomerCheck_2\n  when\n    $o : Order(customerAge > 60)\n  then\n    modify($o) {\n      setDiscount(2000);\n    }\nend\n\nrule PriceCheck_1\n  when\n    $o : Order(itemPrice < 2000, discount >= 2000)\n  then\n    modify($o) {\n      setStatus(\"Too much discount\");\n    }\nend\n\nrule PriceCheck_2\n  when\n    $o : Order(itemPrice > 5000)\n  then\n    modify($o) {\n      setStatus(\"Exclusive order\");\n    }\nend\n\nrule StatusCheck_1\n  when\n    $o : Order(status == \"Too much discount\")\n  then\n    modify($o) {\n      setDiscount(500);\n    }\nend\n\nrule StatusCheck_2\n  when\n    $s : String()\n    Order(status == $s)\n  then\n    // Do some work...\nend";

    @Test
    public void testModelToGraphConverter() {
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{SIMPLE_RULE});
        ModelToGraphConverter converter = new ModelToGraphConverter(LinkFilter.POSITIVE);
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", new ReactivityType[0]);
        this.assertLink(graph, "mypkg.R1", "mypkg.R4", new ReactivityType[0]);
        converter = new ModelToGraphConverter(LinkFilter.NEGATIVE);
        graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", new ReactivityType[0]);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R4", new ReactivityType[0]);
        converter = new ModelToGraphConverter(LinkFilter.UNKNOWN);
        graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", new ReactivityType[0]);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", new ReactivityType[0]);
        this.assertLink(graph, "mypkg.R1", "mypkg.R4", ReactivityType.UNKNOWN);
        converter = new ModelToGraphConverter(LinkFilter.POSITIVE_NEGATIVE);
        graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R4", new ReactivityType[0]);
        converter = new ModelToGraphConverter(LinkFilter.POSITIVE_UNKNOWN);
        graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", new ReactivityType[0]);
        this.assertLink(graph, "mypkg.R1", "mypkg.R4", ReactivityType.UNKNOWN);
        converter = new ModelToGraphConverter(LinkFilter.NEGATIVE_UNKNOWN);
        graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", new ReactivityType[0]);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R4", ReactivityType.UNKNOWN);
        converter = new ModelToGraphConverter(LinkFilter.ALL);
        graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R4", ReactivityType.UNKNOWN);
    }

    @Test
    public void testImpactAnalysisHelper() {
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{SIMPLE_RULE});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        ImpactAnalysisHelper impactFilter = new ImpactAnalysisHelper(LinkFilter.POSITIVE);
        Graph impactedSubGraph = impactFilter.filterImpactedNodes(graph, "mypkg.R1");
        this.assertLink(impactedSubGraph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg.R3"));
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg.R4"));
        graph = converter.toGraph(analysisModel);
        impactFilter = new ImpactAnalysisHelper(LinkFilter.NEGATIVE);
        impactedSubGraph = impactFilter.filterImpactedNodes(graph, "mypkg.R1");
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg.R2"));
        this.assertLink(impactedSubGraph, "mypkg.R1", "mypkg.R3", ReactivityType.NEGATIVE);
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg.R4"));
        graph = converter.toGraph(analysisModel);
        impactFilter = new ImpactAnalysisHelper(LinkFilter.UNKNOWN);
        impactedSubGraph = impactFilter.filterImpactedNodes(graph, "mypkg.R1");
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg.R2"));
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg.R3"));
        this.assertLink(impactedSubGraph, "mypkg.R1", "mypkg.R4", ReactivityType.UNKNOWN);
        graph = converter.toGraph(analysisModel);
        impactFilter = new ImpactAnalysisHelper(LinkFilter.POSITIVE_NEGATIVE);
        impactedSubGraph = impactFilter.filterImpactedNodes(graph, "mypkg.R1");
        this.assertLink(impactedSubGraph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(impactedSubGraph, "mypkg.R1", "mypkg.R3", ReactivityType.NEGATIVE);
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg.R4"));
        graph = converter.toGraph(analysisModel);
        impactFilter = new ImpactAnalysisHelper(LinkFilter.POSITIVE_UNKNOWN);
        impactedSubGraph = impactFilter.filterImpactedNodes(graph, "mypkg.R1");
        this.assertLink(impactedSubGraph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg.R3"));
        this.assertLink(impactedSubGraph, "mypkg.R1", "mypkg.R4", ReactivityType.UNKNOWN);
        graph = converter.toGraph(analysisModel);
        impactFilter = new ImpactAnalysisHelper(LinkFilter.NEGATIVE_UNKNOWN);
        impactedSubGraph = impactFilter.filterImpactedNodes(graph, "mypkg.R1");
        Assert.assertNull(impactedSubGraph.getNodeMap().get("mypkg.R2"));
        this.assertLink(impactedSubGraph, "mypkg.R1", "mypkg.R3", ReactivityType.NEGATIVE);
        this.assertLink(impactedSubGraph, "mypkg.R1", "mypkg.R4", ReactivityType.UNKNOWN);
        graph = converter.toGraph(analysisModel);
        impactFilter = new ImpactAnalysisHelper(LinkFilter.ALL);
        impactedSubGraph = impactFilter.filterImpactedNodes(graph, "mypkg.R1");
        this.assertLink(impactedSubGraph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(impactedSubGraph, "mypkg.R1", "mypkg.R3", ReactivityType.NEGATIVE);
        this.assertLink(impactedSubGraph, "mypkg.R1", "mypkg.R4", ReactivityType.UNKNOWN);
    }

    @Test
    public void testGraphCollapsionHelper() {
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{RULE_WITH_PREFIX});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        GraphCollapsionHelper collapsionHelper = new GraphCollapsionHelper(LinkFilter.POSITIVE);
        Graph collapsedGraph = collapsionHelper.collapseWithRuleNamePrefix(graph);
        this.assertLink(collapsedGraph, "mypkg.CustomerCheck", "mypkg.PriceCheck", ReactivityType.POSITIVE);
        this.assertLink(collapsedGraph, "mypkg.PriceCheck", "mypkg.StatusCheck", ReactivityType.POSITIVE);
        this.assertLink(collapsedGraph, "mypkg.StatusCheck", "mypkg.PriceCheck", new ReactivityType[0]);
        collapsionHelper = new GraphCollapsionHelper(LinkFilter.NEGATIVE);
        collapsedGraph = collapsionHelper.collapseWithRuleNamePrefix(graph);
        this.assertLink(collapsedGraph, "mypkg.CustomerCheck", "mypkg.PriceCheck", ReactivityType.NEGATIVE);
        this.assertLink(collapsedGraph, "mypkg.PriceCheck", "mypkg.StatusCheck", ReactivityType.NEGATIVE);
        this.assertLink(collapsedGraph, "mypkg.StatusCheck", "mypkg.PriceCheck", ReactivityType.NEGATIVE);
        collapsionHelper = new GraphCollapsionHelper(LinkFilter.UNKNOWN);
        collapsedGraph = collapsionHelper.collapseWithRuleNamePrefix(graph);
        this.assertLink(collapsedGraph, "mypkg.CustomerCheck", "mypkg.PriceCheck", new ReactivityType[0]);
        this.assertLink(collapsedGraph, "mypkg.PriceCheck", "mypkg.StatusCheck", ReactivityType.UNKNOWN);
        this.assertLink(collapsedGraph, "mypkg.StatusCheck", "mypkg.PriceCheck", new ReactivityType[0]);
        collapsionHelper = new GraphCollapsionHelper(LinkFilter.POSITIVE_NEGATIVE);
        collapsedGraph = collapsionHelper.collapseWithRuleNamePrefix(graph);
        this.assertLink(collapsedGraph, "mypkg.CustomerCheck", "mypkg.PriceCheck", ReactivityType.POSITIVE, ReactivityType.NEGATIVE);
        this.assertLink(collapsedGraph, "mypkg.PriceCheck", "mypkg.StatusCheck", ReactivityType.POSITIVE, ReactivityType.NEGATIVE);
        this.assertLink(collapsedGraph, "mypkg.StatusCheck", "mypkg.PriceCheck", ReactivityType.NEGATIVE);
        collapsionHelper = new GraphCollapsionHelper(LinkFilter.POSITIVE_UNKNOWN);
        collapsedGraph = collapsionHelper.collapseWithRuleNamePrefix(graph);
        this.assertLink(collapsedGraph, "mypkg.CustomerCheck", "mypkg.PriceCheck", ReactivityType.POSITIVE);
        this.assertLink(collapsedGraph, "mypkg.PriceCheck", "mypkg.StatusCheck", ReactivityType.POSITIVE, ReactivityType.UNKNOWN);
        this.assertLink(collapsedGraph, "mypkg.StatusCheck", "mypkg.PriceCheck", new ReactivityType[0]);
        collapsionHelper = new GraphCollapsionHelper(LinkFilter.NEGATIVE_UNKNOWN);
        collapsedGraph = collapsionHelper.collapseWithRuleNamePrefix(graph);
        this.assertLink(collapsedGraph, "mypkg.CustomerCheck", "mypkg.PriceCheck", ReactivityType.NEGATIVE);
        this.assertLink(collapsedGraph, "mypkg.PriceCheck", "mypkg.StatusCheck", ReactivityType.NEGATIVE, ReactivityType.UNKNOWN);
        this.assertLink(collapsedGraph, "mypkg.StatusCheck", "mypkg.PriceCheck", ReactivityType.NEGATIVE);
        collapsionHelper = new GraphCollapsionHelper(LinkFilter.ALL);
        collapsedGraph = collapsionHelper.collapseWithRuleNamePrefix(graph);
        this.assertLink(collapsedGraph, "mypkg.CustomerCheck", "mypkg.PriceCheck", ReactivityType.POSITIVE, ReactivityType.NEGATIVE);
        this.assertLink(collapsedGraph, "mypkg.PriceCheck", "mypkg.StatusCheck", ReactivityType.POSITIVE, ReactivityType.NEGATIVE, ReactivityType.UNKNOWN);
        this.assertLink(collapsedGraph, "mypkg.StatusCheck", "mypkg.PriceCheck", ReactivityType.NEGATIVE);
    }
}

