/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impact.analysis.integrationtests;

import org.drools.impact.analysis.graph.Graph;
import org.drools.impact.analysis.graph.ModelToGraphConverter;
import org.drools.impact.analysis.graph.ReactivityType;
import org.drools.impact.analysis.integrationtests.AbstractGraphTest;
import org.drools.impact.analysis.integrationtests.domain.Address;
import org.drools.impact.analysis.integrationtests.domain.Person;
import org.drools.impact.analysis.model.AnalysisModel;
import org.drools.impact.analysis.parser.ModelBuilder;
import org.junit.Test;

public class BasicGraphTest
extends AbstractGraphTest {
    @Test
    public void test3Rules() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\n  $p : Person(name == \"Mario\")\nthen\n  modify($p) { setAge( 18 ) };  insert(\"Done\");\nend\nrule R2 when\n  $p : Person(age > 15)\nthen\nend\nrule R3 when\n  $p : String(this == \"Done\")\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", ReactivityType.POSITIVE);
    }

    @Test
    public void test5Rules() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";import " + Address.class.getCanonicalName() + ";rule R1 when\n  $p : Person(name == \"Mario\")\nthen\n  modify($p) { setAge( 18 ) };end\nrule R2 when\n  $p : Person(age > 15)\nthen\n  insert(new Address(\"Milan\"));end\nrule R3 when\n  $p : Person(age < 15)\nthen\n  insert(new Address(\"Milan\"));end\nrule R4 when\n  $a : Address()\nthen\nend\nrule R5 when\n  $i : Integer()\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R2", "mypkg.R4", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R3", "mypkg.R4", ReactivityType.POSITIVE);
        ModelToGraphConverter converterPositiveOnly = new ModelToGraphConverter(true);
        Graph graph2 = converterPositiveOnly.toGraph(analysisModel);
        this.assertLink(graph2, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(graph2, "mypkg.R1", "mypkg.R3", new ReactivityType[0]);
        this.assertLink(graph2, "mypkg.R2", "mypkg.R4", ReactivityType.POSITIVE);
        this.assertLink(graph2, "mypkg.R3", "mypkg.R4", ReactivityType.POSITIVE);
    }

    @Test
    public void testBeta() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\n  $p : Person(name == \"Mario\")\nthen\n  modify($p) { setAge( 18 ) };end\nrule R2 when\n  $a : Integer()\n  $p2 : Person(age > $a)\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.UNKNOWN);
    }

    @Test
    public void testLoop() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\n  $p : Person(name == \"Mario\")\nthen\n  modify($p) { setAge( 18 ) };end\nrule R2 when\n  $p : Person(age > 10)\nthen\n  modify($p) { setName( \"Toshiya\" ) };end\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R2", "mypkg.R1", ReactivityType.NEGATIVE);
    }

    @Test
    public void testNoConstraint() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\n  $p : Person()\nthen\n  modify($p) { setAge( 18 ) };end\nrule R2 when\n  $p : Person()\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", new ReactivityType[0]);
    }

    @Test
    public void testBlackBoxMethod() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\n  $p : Person(name == \"Mario\")\nthen\n  modify($p) { setAge( 18 ) };end\nrule R2 when\n  $p : Person(blackBoxMethod())\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.UNKNOWN);
    }

    @Test
    public void testInsertDelete() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";import " + Address.class.getCanonicalName() + ";rule R1 when\n  $p : Person()\nthen\n  insert(new Address());end\nrule R2 when\n  $p : Person()\n  $a : Address()\nthen\n  delete($p);end\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R2", "mypkg.R1", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R2", "mypkg.R2", ReactivityType.NEGATIVE);
    }

    @Test
    public void testInsertRelation() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\n  String(this == \"Start\")\nthen\n  Person p = new Person();\n  p.setName(\"John\");\n  insert(p);\nend\nrule R2 when\n  $p : Person(name == \"John\")\nthen\nend\nrule R3 when\n  $p : Person(name == \"Paul\")\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.POSITIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", new ReactivityType[0]);
    }

    @Test
    public void testInsertRelationNot() {
        String str = "package mypkg;\nimport " + Person.class.getCanonicalName() + ";rule R1 when\n  String(this == \"Start\")\nthen\n  Person p = new Person();\n  p.setName(\"John\");\n  insert(p);\nend\nrule R2 when\n  not( Person(name == \"John\") )\nthen\nend\nrule R3 when\n  not( Person(name == \"Paul\") )\nthen\nend\n";
        AnalysisModel analysisModel = new ModelBuilder().build(new String[]{str});
        ModelToGraphConverter converter = new ModelToGraphConverter();
        Graph graph = converter.toGraph(analysisModel);
        this.assertLink(graph, "mypkg.R1", "mypkg.R2", ReactivityType.NEGATIVE);
        this.assertLink(graph, "mypkg.R1", "mypkg.R3", new ReactivityType[0]);
    }
}

