/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession;

import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ObjectType;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PhreakPropagationContextFactory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.phreak.BuildtimeSegmentUtilities;
import org.drools.core.phreak.PhreakNotNode;
import org.drools.core.phreak.RuntimeSegmentUtilities;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockObjectSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.junit.Test;
import org.kie.api.definition.rule.Rule;

public class NodeSegmentUnlinkingTest {
    InternalKnowledgeBase kBase;
    BuildContext buildContext;
    PropagationContext context;
    LeftInputAdapterNode liaNode;
    BetaNode n1;
    BetaNode n2;
    BetaNode n3;
    BetaNode n4;
    BetaNode n5;
    BetaNode n6;
    BetaNode n7;
    BetaNode n8;
    RuleImpl rule1;
    RuleImpl rule2;
    RuleImpl rule3;
    RuleImpl rule4;
    RuleImpl rule5;
    static final int JOIN_NODE = 0;
    static final int EXISTS_NODE = 1;
    static final int NOT_NODE = 2;

    private BetaNode createBetaNode(int id, int type, LeftTupleSource leftTupleSource) {
        MockObjectSource mockObjectSource = new MockObjectSource(8);
        JoinNode betaNode = null;
        switch (type) {
            case 0: {
                betaNode = new JoinNode(id, leftTupleSource, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), this.buildContext);
                break;
            }
            case 1: {
                betaNode = new ExistsNode(id, leftTupleSource, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), this.buildContext);
                break;
            }
            case 2: {
                betaNode = new NotNode(id, leftTupleSource, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), this.buildContext);
            }
        }
        mockObjectSource.attach(this.buildContext);
        betaNode.attach(this.buildContext);
        return betaNode;
    }

    public void setUp(int type) {
        this.setUp(type, type, type, type, type, type, type, type);
    }

    public void setUp(int ... type) {
        this.kBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext((RuleBase)this.kBase, Collections.emptyList());
        PhreakPropagationContextFactory pctxFactory = new PhreakPropagationContextFactory();
        this.context = pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null);
        MockTupleSource mockTupleSource = new MockTupleSource(9, this.buildContext);
        this.rule1 = new RuleImpl("rule1");
        this.rule2 = new RuleImpl("rule2");
        this.rule3 = new RuleImpl("rule3");
        ObjectTypeNode otn = new ObjectTypeNode(3, null, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        this.liaNode = new LeftInputAdapterNode(4, (ObjectSource)otn, this.buildContext);
        this.n1 = this.createBetaNode(10, type[0], (LeftTupleSource)this.liaNode);
        this.n2 = this.createBetaNode(11, type[1], (LeftTupleSource)this.n1);
        RuleTerminalNode rtn1 = new RuleTerminalNode(18, (LeftTupleSource)this.n2, this.rule1, this.rule1.getLhs(), 0, this.buildContext);
        rtn1.attach(this.buildContext);
        this.n3 = this.createBetaNode(12, type[2], (LeftTupleSource)this.n1);
        this.n4 = this.createBetaNode(13, type[3], (LeftTupleSource)this.n3);
        this.n5 = this.createBetaNode(14, type[4], (LeftTupleSource)this.n4);
        this.n6 = this.createBetaNode(15, type[5], (LeftTupleSource)this.n5);
        RuleTerminalNode rtn2 = new RuleTerminalNode(19, (LeftTupleSource)this.n6, this.rule2, this.rule2.getLhs(), 0, this.buildContext);
        rtn2.attach(this.buildContext);
        this.n7 = this.createBetaNode(16, type[6], (LeftTupleSource)this.n6);
        this.n8 = this.createBetaNode(17, type[7], (LeftTupleSource)this.n7);
        RuleTerminalNode rtn3 = new RuleTerminalNode(20, (LeftTupleSource)this.n8, this.rule3, this.rule3.getLhs(), 0, this.buildContext);
        rtn3.attach(this.buildContext);
        this.n1.addAssociation((Rule)this.rule1);
        this.n1.addAssociation((Rule)this.rule2);
        this.n1.addAssociation((Rule)this.rule3);
        this.n2.addAssociation((Rule)this.rule1);
        this.n2.addAssociation((Rule)this.rule2);
        this.n2.addAssociation((Rule)this.rule3);
        this.n3.addAssociation((Rule)this.rule2);
        this.n3.addAssociation((Rule)this.rule3);
        this.n4.addAssociation((Rule)this.rule2);
        this.n4.addAssociation((Rule)this.rule3);
        this.n5.addAssociation((Rule)this.rule2);
        this.n5.addAssociation((Rule)this.rule3);
        this.n6.addAssociation((Rule)this.rule2);
        this.n6.addAssociation((Rule)this.rule3);
        this.n7.addAssociation((Rule)this.rule3);
        this.n8.addAssociation((Rule)this.rule3);
        for (TerminalNode tn : new TerminalNode[]{rtn1, rtn2, rtn3}) {
            tn.setPathEndNodes(new PathEndNode[]{tn});
            tn.resetPathMemSpec(null);
            BuildtimeSegmentUtilities.createPathProtoMemories((TerminalNode)tn, null, (RuleBase)this.kBase);
        }
    }

    @Test
    public void testSingleNodeinSegment() {
        this.rule1 = new RuleImpl("rule1");
        this.rule2 = new RuleImpl("rule2");
        this.rule3 = new RuleImpl("rule3");
        this.kBase = KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext buildContext = new BuildContext((RuleBase)this.kBase, Collections.emptyList());
        MockObjectSource mockObjectSource = new MockObjectSource(8);
        MockTupleSource mockTupleSource = new MockTupleSource(9, buildContext);
        ObjectTypeNode otn = new ObjectTypeNode(2, null, (ObjectType)new ClassObjectType(String.class), buildContext);
        JoinNode n1 = new JoinNode(10, (LeftTupleSource)new LeftInputAdapterNode(3, (ObjectSource)otn, buildContext), (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), buildContext);
        JoinNode n2 = new JoinNode(11, (LeftTupleSource)n1, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), buildContext);
        JoinNode n3 = new JoinNode(12, (LeftTupleSource)n1, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), buildContext);
        JoinNode n4 = new JoinNode(13, (LeftTupleSource)n2, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), buildContext);
        JoinNode n5 = new JoinNode(14, (LeftTupleSource)n2, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), buildContext);
        n1.addAssociation((Rule)this.rule1);
        n1.addAssociation((Rule)this.rule2);
        n1.addAssociation((Rule)this.rule3);
        n2.addAssociation((Rule)this.rule2);
        n2.addAssociation((Rule)this.rule3);
        n3.addAssociation((Rule)this.rule1);
        n4.addAssociation((Rule)this.rule2);
        n5.addAssociation((Rule)this.rule3);
        mockObjectSource.attach(buildContext);
        mockTupleSource.attach(buildContext);
        n1.attach(buildContext);
        n2.attach(buildContext);
        n3.attach(buildContext);
        n4.attach(buildContext);
        n5.attach(buildContext);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        SegmentMemory.SegmentPrototype[] protos = BuildtimeSegmentUtilities.createLeftTupleNodeProtoMemories((LeftTupleNode)n3, null, (RuleBase)this.kBase);
        Arrays.stream(protos).forEach(p -> p.setPathEndNodes(new PathEndNode[0]));
        protos = BuildtimeSegmentUtilities.createLeftTupleNodeProtoMemories((LeftTupleNode)n4, null, (RuleBase)this.kBase);
        Arrays.stream(protos).forEach(p -> p.setPathEndNodes(new PathEndNode[0]));
        protos = BuildtimeSegmentUtilities.createLeftTupleNodeProtoMemories((LeftTupleNode)n5, null, (RuleBase)this.kBase);
        Arrays.stream(protos).forEach(p -> p.setPathEndNodes(new PathEndNode[0]));
        NodeSegmentUnlinkingTest.createSegmentMemory((BetaNode)n2, (InternalWorkingMemory)ksession);
        BetaMemory bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)n1);
        Assertions.assertThat((Object)bm.getSegmentMemory()).isNull();
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)n3);
        Assertions.assertThat((Object)bm.getSegmentMemory()).isNull();
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)n4);
        Assertions.assertThat((Object)bm.getSegmentMemory()).isNull();
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)n2);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(1L);
    }

    @Test
    public void testLiaNodeInitialisation() {
        this.setUp(0);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        RuntimeSegmentUtilities.getOrCreateSegmentMemory((LeftTupleNode)this.liaNode, (ReteEvaluator)ksession);
        this.liaNode.assertObject((InternalFactHandle)ksession.insert((Object)"str"), this.context, (ReteEvaluator)ksession);
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)ksession.getNodeMemory((MemoryFactory)this.liaNode);
        Assertions.assertThat((long)liaMem.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)liaMem.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(3L);
        BetaMemory bm1 = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n1);
        Assertions.assertThat((long)bm1.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)bm1.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(3L);
        ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        this.n1.assertObject((InternalFactHandle)ksession.insert((Object)"str"), this.context, (ReteEvaluator)ksession);
        liaMem = (LeftInputAdapterNode.LiaNodeMemory)ksession.getNodeMemory((MemoryFactory)this.liaNode);
        Assertions.assertThat((long)liaMem.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)liaMem.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(3L);
        bm1 = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n1);
        Assertions.assertThat((long)bm1.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)bm1.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(3L);
    }

    @Test
    public void testLiaNodeLinking() {
        this.setUp(0);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        RuntimeSegmentUtilities.getOrCreateSegmentMemory((LeftTupleNode)this.liaNode, (ReteEvaluator)ksession);
        InternalFactHandle fh1 = (InternalFactHandle)ksession.insert((Object)"str1");
        this.n1.assertObject(fh1, this.context, (ReteEvaluator)ksession);
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)ksession.getNodeMemory((MemoryFactory)this.liaNode);
        Assertions.assertThat((long)liaMem.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)liaMem.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(3L);
        BetaMemory bm1 = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n1);
        Assertions.assertThat((long)bm1.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)bm1.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(3L);
        Assertions.assertThat((boolean)liaMem.getSegmentMemory().isSegmentLinked()).isFalse();
        InternalFactHandle fh2 = (InternalFactHandle)ksession.insert((Object)"str2");
        this.liaNode.assertObject(fh2, this.context, (ReteEvaluator)ksession);
        Assertions.assertThat((boolean)liaMem.getSegmentMemory().isSegmentLinked()).isTrue();
        this.liaNode.retractLeftTuple(fh2.getFirstLeftTuple(), this.context, (ReteEvaluator)ksession);
        Assertions.assertThat((boolean)liaMem.getSegmentMemory().isSegmentLinked()).isFalse();
        InternalFactHandle fh3 = (InternalFactHandle)ksession.insert((Object)"str3");
        InternalFactHandle fh4 = (InternalFactHandle)ksession.insert((Object)"str4");
        this.liaNode.assertObject(fh3, this.context, (ReteEvaluator)ksession);
        this.liaNode.assertObject(fh4, this.context, (ReteEvaluator)ksession);
        Assertions.assertThat((boolean)liaMem.getSegmentMemory().isSegmentLinked()).isTrue();
        this.liaNode.retractLeftTuple(fh3.getFirstLeftTuple(), this.context, (ReteEvaluator)ksession);
        Assertions.assertThat((boolean)liaMem.getSegmentMemory().isSegmentLinked()).isTrue();
        this.liaNode.retractLeftTuple(fh4.getFirstLeftTuple(), this.context, (ReteEvaluator)ksession);
        Assertions.assertThat((boolean)liaMem.getSegmentMemory().isSegmentLinked()).isFalse();
    }

    @Test
    public void tesMultiNodeSegmentDifferentInitialisationPoints() {
        this.setUp(0);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        NodeSegmentUnlinkingTest.createSegmentMemory(this.n3, (InternalWorkingMemory)ksession);
        BetaMemory bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n1);
        Assertions.assertThat((Object)bm.getSegmentMemory()).isNull();
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n3);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n4);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n5);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n6);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(8L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        bm = NodeSegmentUnlinkingTest.createSegmentMemory(this.n4, (InternalWorkingMemory)ksession);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n1);
        Assertions.assertThat((Object)bm.getSegmentMemory()).isNull();
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n3);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n4);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n5);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n6);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(8L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        NodeSegmentUnlinkingTest.createSegmentMemory(this.n5, (InternalWorkingMemory)ksession);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n1);
        Assertions.assertThat((Object)bm.getSegmentMemory()).isNull();
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n3);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n4);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n5);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n6);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(8L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        NodeSegmentUnlinkingTest.createSegmentMemory(this.n6, (InternalWorkingMemory)ksession);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n1);
        Assertions.assertThat((Object)bm.getSegmentMemory()).isNull();
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n3);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n4);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n5);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n6);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(8L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
    }

    @Test
    public void testAllLinkedInWithJoinNodesOnly() {
        this.setUp(0);
        Assertions.assertThat(this.n3.getClass()).isEqualTo(JoinNode.class);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        DefaultFactHandle f1 = (DefaultFactHandle)ksession.insert((Object)"test1");
        this.n3.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)ksession);
        BetaMemory bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n3);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isFalse();
        this.n4.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)ksession);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isFalse();
        this.n5.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)ksession);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isFalse();
        this.n6.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)ksession);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isTrue();
    }

    @Test
    public void testAllLinkedInWithExistsNodesOnly() {
        this.setUp(1);
        Assertions.assertThat(this.n3.getClass()).isEqualTo(ExistsNode.class);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        DefaultFactHandle f1 = (DefaultFactHandle)ksession.insert((Object)"test1");
        this.n3.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)ksession);
        BetaMemory bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n3);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isFalse();
        this.n4.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)ksession);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isFalse();
        this.n5.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)ksession);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isFalse();
        this.n6.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)ksession);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isTrue();
    }

    private static BetaMemory createSegmentMemory(BetaNode node, InternalWorkingMemory wm) {
        BetaMemory betaMemory = (BetaMemory)wm.getNodeMemory((MemoryFactory)node);
        if (betaMemory.getSegmentMemory() == null) {
            RuntimeSegmentUtilities.getOrCreateSegmentMemory((LeftTupleNode)node, (ReteEvaluator)wm);
        }
        return betaMemory;
    }

    @Test
    public void testAllLinkedInWithNotNodesOnly() {
        this.setUp(2);
        Assertions.assertThat(this.n3.getClass()).isEqualTo(NotNode.class);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        BetaMemory bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n3);
        NodeSegmentUnlinkingTest.createSegmentMemory(this.n3, (InternalWorkingMemory)ksession);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isTrue();
        DefaultFactHandle f1 = (DefaultFactHandle)ksession.insert((Object)"test1");
        this.n3.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)ksession);
        PhreakNotNode.unlinkNotNodeOnRightInsert((NotNode)((NotNode)this.n3), (BetaMemory)bm, (ReteEvaluator)ksession);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isFalse();
        this.n3.retractRightTuple(f1.getFirstRightTuple(), this.context, (ReteEvaluator)ksession);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isTrue();
    }
}

