/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession;

import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.PriorityQueueAgendaGroupFactory;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.junit.Test;
import org.kie.internal.conf.CompositeConfiguration;
import org.kie.internal.conf.ConfigurationFactory;
import org.kie.internal.utils.ChainedProperties;

public class RuleBaseConfigurationTest {
    public RuleBaseConfiguration getRuleBaseConfiguration(Properties props) {
        RuleBaseConfiguration brconf = new RuleBaseConfiguration(new CompositeConfiguration(ChainedProperties.getChainedProperties(null).addProperties(props), null, new ConfigurationFactory[0]));
        return brconf;
    }

    @Test
    public void testSystemProperties() {
        RuleBaseConfiguration cfg = this.getRuleBaseConfiguration(null);
        Assertions.assertThat((Object)cfg.getAssertBehaviour()).isEqualTo((Object)RuleBaseConfiguration.AssertBehaviour.IDENTITY);
        System.setProperty("drools.equalityBehavior", "EQUALITY");
        cfg = this.getRuleBaseConfiguration(null);
        Assertions.assertThat((Object)cfg.getAssertBehaviour()).isEqualTo((Object)RuleBaseConfiguration.AssertBehaviour.EQUALITY);
        System.getProperties().remove("drools.equalityBehavior");
    }

    @Test
    public void testProgrammaticPropertiesFile() {
        RuleBaseConfiguration cfg = this.getRuleBaseConfiguration(null);
        Assertions.assertThat((boolean)cfg.isIndexLeftBetaMemory()).isEqualTo(true);
        Properties properties = new Properties();
        properties.setProperty("drools.indexLeftBetaMemory", "false");
        cfg = this.getRuleBaseConfiguration(properties);
        Assertions.assertThat((boolean)cfg.isIndexLeftBetaMemory()).isEqualTo(false);
        System.getProperties().remove("drools.indexLeftBetaMemory");
    }

    @Test
    public void testAssertBehaviour() {
        Properties properties = new Properties();
        properties.setProperty("drools.equalityBehavior", "identity");
        RuleBaseConfiguration cfg = this.getRuleBaseConfiguration(properties);
        Assertions.assertThat((Object)cfg.getAssertBehaviour()).isEqualTo((Object)RuleBaseConfiguration.AssertBehaviour.IDENTITY);
        properties = new Properties();
        properties.setProperty("drools.equalityBehavior", "equality");
        cfg = this.getRuleBaseConfiguration(properties);
        Assertions.assertThat((Object)cfg.getAssertBehaviour()).isEqualTo((Object)RuleBaseConfiguration.AssertBehaviour.EQUALITY);
    }

    @Test
    public void testSequential() {
        Properties properties = new Properties();
        properties.setProperty("drools.sequential", "false");
        RuleBaseConfiguration cfg = this.getRuleBaseConfiguration(properties);
        Assertions.assertThat((boolean)cfg.isSequential()).isFalse();
        Assertions.assertThat((boolean)(RuntimeComponentFactory.get().getAgendaGroupFactory() instanceof PriorityQueueAgendaGroupFactory)).isTrue();
        properties = new Properties();
        properties.setProperty("drools.sequential.agenda", "sequential");
        properties.setProperty("drools.sequential", "true");
        cfg = this.getRuleBaseConfiguration(properties);
        Assertions.assertThat((boolean)cfg.isSequential()).isTrue();
        Assertions.assertThat((Object)cfg.getSequentialAgenda()).isEqualTo((Object)RuleBaseConfiguration.SequentialAgenda.SEQUENTIAL);
        properties = new Properties();
        properties.setProperty("drools.sequential.agenda", "dynamic");
        properties.setProperty("drools.sequential", "true");
        cfg = this.getRuleBaseConfiguration(properties);
        Assertions.assertThat((boolean)cfg.isSequential()).isTrue();
        Assertions.assertThat((Object)cfg.getSequentialAgenda()).isEqualTo((Object)RuleBaseConfiguration.SequentialAgenda.DYNAMIC);
        Assertions.assertThat((boolean)(RuntimeComponentFactory.get().getAgendaGroupFactory() instanceof PriorityQueueAgendaGroupFactory)).isTrue();
    }
}

