/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ObjectType;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.PhreakPropagationContextFactory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.phreak.BuildtimeSegmentUtilities;
import org.drools.core.phreak.RuntimeSegmentUtilities;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockObjectSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.GroupElement;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.definition.rule.Rule;

public class RuleUnlinkingWithSegmentMemoryTest {
    InternalKnowledgeBase kBase;
    BuildContext buildContext;
    PropagationContext context;
    LeftInputAdapterNode lian;
    BetaNode n1;
    BetaNode n2;
    BetaNode n3;
    BetaNode n4;
    BetaNode n5;
    BetaNode n6;
    BetaNode n7;
    BetaNode n8;
    BetaNode n9;
    BetaNode n10;
    RuleTerminalNode rtn1;
    RuleTerminalNode rtn2;
    RuleTerminalNode rtn3;
    RuleImpl rule1;
    RuleImpl rule2;
    RuleImpl rule3;
    static final int JOIN_NODE = 0;
    static final int EXISTS_NODE = 1;
    static final int NOT_NODE = 2;
    static final int RULE_TERMINAL_NODE = 3;

    private NetworkNode createNetworkNode(int id, int type, LeftTupleSource leftTupleSource, RuleImpl rule) {
        MockObjectSource mockObjectSource = new MockObjectSource(8);
        JoinNode networkNode = null;
        switch (type) {
            case 0: {
                networkNode = new JoinNode(id, leftTupleSource, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), this.buildContext);
                break;
            }
            case 1: {
                networkNode = new ExistsNode(id, leftTupleSource, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), this.buildContext);
                break;
            }
            case 2: {
                networkNode = new NotNode(id, leftTupleSource, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), this.buildContext);
                break;
            }
            case 3: {
                networkNode = new RuleTerminalNode(id, leftTupleSource, rule, new GroupElement(GroupElement.Type.AND), 0, this.buildContext);
            }
        }
        mockObjectSource.attach();
        if (NodeTypeEnums.isLeftTupleSource(networkNode)) {
            ((LeftTupleSource)networkNode).attach(this.buildContext);
        } else {
            ((RuleTerminalNode)networkNode).attach(this.buildContext);
        }
        return networkNode;
    }

    public void setUp(int type) {
        KieBaseConfiguration kconf = RuleBaseFactory.newKnowledgeBaseConfiguration();
        this.kBase = KnowledgeBaseFactory.newKnowledgeBase((RuleBase)RuleBaseFactory.newRuleBase((KieBaseConfiguration)kconf));
        this.buildContext = new BuildContext((RuleBase)this.kBase, Collections.emptyList());
        PhreakPropagationContextFactory pctxFactory = new PhreakPropagationContextFactory();
        this.context = pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null);
        ObjectTypeNode otn = new ObjectTypeNode(4, null, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        this.lian = new LeftInputAdapterNode(5, (ObjectSource)otn, this.buildContext);
        this.n1 = (BetaNode)this.createNetworkNode(10, type, (LeftTupleSource)this.lian, null);
        this.n2 = (BetaNode)this.createNetworkNode(11, type, (LeftTupleSource)this.n1, null);
        this.n3 = (BetaNode)this.createNetworkNode(12, type, (LeftTupleSource)this.n2, null);
        this.rule1 = new RuleImpl("rule1");
        this.rule1.setActivationListener("agenda");
        this.rtn1 = (RuleTerminalNode)this.createNetworkNode(18, 3, (LeftTupleSource)this.n3, this.rule1);
        this.n4 = (BetaNode)this.createNetworkNode(13, type, (LeftTupleSource)this.n3, null);
        this.n5 = (BetaNode)this.createNetworkNode(14, type, (LeftTupleSource)this.n4, null);
        this.rule2 = new RuleImpl("rule2");
        this.rule2.setActivationListener("agenda");
        this.rtn2 = (RuleTerminalNode)this.createNetworkNode(19, 3, (LeftTupleSource)this.n5, this.rule2);
        this.n6 = (BetaNode)this.createNetworkNode(15, type, (LeftTupleSource)this.n5, null);
        this.n7 = (BetaNode)this.createNetworkNode(16, type, (LeftTupleSource)this.n6, null);
        this.n8 = (BetaNode)this.createNetworkNode(17, type, (LeftTupleSource)this.n7, null);
        this.rule3 = new RuleImpl("rule3");
        this.rule3.setActivationListener("agenda");
        this.rtn3 = (RuleTerminalNode)this.createNetworkNode(20, 3, (LeftTupleSource)this.n8, this.rule3);
        this.lian.addAssociation((Rule)this.rule1);
        this.lian.addAssociation((Rule)this.rule2);
        this.lian.addAssociation((Rule)this.rule3);
        this.n1.addAssociation((Rule)this.rule1);
        this.n1.addAssociation((Rule)this.rule2);
        this.n1.addAssociation((Rule)this.rule3);
        this.n2.addAssociation((Rule)this.rule1);
        this.n2.addAssociation((Rule)this.rule2);
        this.n2.addAssociation((Rule)this.rule3);
        this.n3.addAssociation((Rule)this.rule1);
        this.n3.addAssociation((Rule)this.rule2);
        this.n3.addAssociation((Rule)this.rule3);
        this.n4.addAssociation((Rule)this.rule2);
        this.n4.addAssociation((Rule)this.rule3);
        this.n5.addAssociation((Rule)this.rule2);
        this.n5.addAssociation((Rule)this.rule3);
        this.n6.addAssociation((Rule)this.rule3);
        this.n7.addAssociation((Rule)this.rule3);
        this.n8.addAssociation((Rule)this.rule3);
        for (TerminalNode tn : new TerminalNode[]{this.rtn1, this.rtn2, this.rtn3}) {
            tn.setPathEndNodes(new PathEndNode[]{tn});
            tn.resetPathMemSpec(null);
            BuildtimeSegmentUtilities.createPathProtoMemories((TerminalNode)tn, null, (RuleBase)this.kBase);
        }
    }

    @Test
    public void testRuleSegmentsAllLinkedTestMasks() {
        this.setUp(0);
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl wm = new StatefulKnowledgeSessionImpl(1L, kBase);
        PathMemory rs = (PathMemory)wm.getNodeMemory((MemoryFactory)this.rtn1);
        Assertions.assertThat((boolean)rs.isRuleLinked()).isFalse();
        Assertions.assertThat((long)rs.getAllLinkedMaskTest()).isEqualTo(1L);
        rs = (PathMemory)wm.getNodeMemory((MemoryFactory)this.rtn2);
        Assertions.assertThat((boolean)rs.isRuleLinked()).isFalse();
        Assertions.assertThat((long)rs.getAllLinkedMaskTest()).isEqualTo(3L);
        rs = (PathMemory)wm.getNodeMemory((MemoryFactory)this.rtn3);
        Assertions.assertThat((boolean)rs.isRuleLinked()).isFalse();
        Assertions.assertThat((long)rs.getAllLinkedMaskTest()).isEqualTo(7L);
    }

    @Test
    public void testSegmentNodeReferencesToSegments() {
        this.setUp(0);
        StatefulKnowledgeSessionImpl wm = new StatefulKnowledgeSessionImpl(1L, this.kBase);
        BetaMemory bm = null;
        PathMemory rtn1Rs = (PathMemory)wm.getNodeMemory((MemoryFactory)this.rtn1);
        PathMemory rtn2Rs = (PathMemory)wm.getNodeMemory((MemoryFactory)this.rtn2);
        PathMemory rtn3Rs = (PathMemory)wm.getNodeMemory((MemoryFactory)this.rtn3);
        RuntimeSegmentUtilities.getOrCreateSegmentMemory((LeftTupleNode)this.lian, (ReteEvaluator)wm);
        LeftInputAdapterNode.LiaNodeMemory lmem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)this.lian);
        Assertions.assertThat((long)lmem.getNodePosMaskBit()).isEqualTo(1L);
        RuntimeSegmentUtilities.getOrCreateSegmentMemory((LeftTupleNode)this.n1, (ReteEvaluator)wm);
        bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)this.n1);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        Assertions.assertThat((long)bm.getSegmentMemory().getSegmentPosMaskBit()).isEqualTo(1L);
        List list = bm.getSegmentMemory().getPathMemories();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((boolean)list.contains(rtn1Rs)).isTrue();
        Assertions.assertThat((boolean)list.contains(rtn2Rs)).isTrue();
        Assertions.assertThat((boolean)list.contains(rtn3Rs)).isTrue();
        bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)this.n2);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        Assertions.assertThat((long)bm.getSegmentMemory().getSegmentPosMaskBit()).isEqualTo(1L);
        list = bm.getSegmentMemory().getPathMemories();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((boolean)list.contains(rtn1Rs)).isTrue();
        Assertions.assertThat((boolean)list.contains(rtn2Rs)).isTrue();
        Assertions.assertThat((boolean)list.contains(rtn3Rs)).isTrue();
        bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)this.n3);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(8L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(15L);
        Assertions.assertThat((long)bm.getSegmentMemory().getSegmentPosMaskBit()).isEqualTo(1L);
        list = bm.getSegmentMemory().getPathMemories();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((boolean)list.contains(rtn1Rs)).isTrue();
        Assertions.assertThat((boolean)list.contains(rtn2Rs)).isTrue();
        Assertions.assertThat((boolean)list.contains(rtn3Rs)).isTrue();
        RuntimeSegmentUtilities.getOrCreateSegmentMemory((LeftTupleNode)this.n4, (ReteEvaluator)wm);
        bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)this.n4);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(3L);
        Assertions.assertThat((long)bm.getSegmentMemory().getSegmentPosMaskBit()).isEqualTo(2L);
        list = bm.getSegmentMemory().getPathMemories();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.contains(rtn2Rs)).isTrue();
        Assertions.assertThat((boolean)list.contains(rtn3Rs)).isTrue();
        bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)this.n5);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(3L);
        Assertions.assertThat((long)bm.getSegmentMemory().getSegmentPosMaskBit()).isEqualTo(2L);
        list = bm.getSegmentMemory().getPathMemories();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.contains(rtn2Rs)).isTrue();
        Assertions.assertThat((boolean)list.contains(rtn3Rs)).isTrue();
        RuntimeSegmentUtilities.getOrCreateSegmentMemory((LeftTupleNode)this.n6, (ReteEvaluator)wm);
        bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)this.n6);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(7L);
        Assertions.assertThat((long)bm.getSegmentMemory().getSegmentPosMaskBit()).isEqualTo(4L);
        list = bm.getSegmentMemory().getPathMemories();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains(rtn3Rs)).isTrue();
        bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)this.n7);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(7L);
        Assertions.assertThat((long)bm.getSegmentMemory().getSegmentPosMaskBit()).isEqualTo(4L);
        list = bm.getSegmentMemory().getPathMemories();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains(rtn3Rs)).isTrue();
        bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)this.n8);
        Assertions.assertThat((long)bm.getNodePosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(7L);
        Assertions.assertThat((long)bm.getSegmentMemory().getSegmentPosMaskBit()).isEqualTo(4L);
        list = bm.getSegmentMemory().getPathMemories();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains(rtn3Rs)).isTrue();
    }

    @Test
    public void testRuleSegmentLinking() {
        this.setUp(0);
        StatefulKnowledgeSessionImpl wm = new StatefulKnowledgeSessionImpl(1L, this.kBase);
        BetaMemory bm = null;
        PathMemory rtn1Rs = (PathMemory)wm.getNodeMemory((MemoryFactory)this.rtn1);
        PathMemory rtn2Rs = (PathMemory)wm.getNodeMemory((MemoryFactory)this.rtn2);
        PathMemory rtn3Rs = (PathMemory)wm.getNodeMemory((MemoryFactory)this.rtn3);
        DefaultFactHandle f1 = (DefaultFactHandle)wm.insert((Object)"test1");
        this.lian.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)wm);
        this.n1.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)wm);
        this.n3.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)wm);
        this.n4.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)wm);
        this.n8.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)wm);
        Assertions.assertThat((boolean)rtn1Rs.isRuleLinked()).isFalse();
        Assertions.assertThat((boolean)rtn2Rs.isRuleLinked()).isFalse();
        Assertions.assertThat((boolean)rtn3Rs.isRuleLinked()).isFalse();
        bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)this.n2);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isFalse();
        DefaultFactHandle f2 = (DefaultFactHandle)wm.insert((Object)"test2");
        this.n2.assertObject((InternalFactHandle)f2, this.context, (ReteEvaluator)wm);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isTrue();
        Assertions.assertThat((boolean)rtn1Rs.isRuleLinked()).isTrue();
        Assertions.assertThat((boolean)rtn2Rs.isRuleLinked()).isFalse();
        Assertions.assertThat((boolean)rtn3Rs.isRuleLinked()).isFalse();
        bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)this.n5);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isFalse();
        this.n5.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)wm);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isTrue();
        Assertions.assertThat((boolean)rtn1Rs.isRuleLinked()).isTrue();
        Assertions.assertThat((boolean)rtn2Rs.isRuleLinked()).isTrue();
        Assertions.assertThat((boolean)rtn3Rs.isRuleLinked()).isFalse();
        this.n6.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)wm);
        this.n7.assertObject((InternalFactHandle)f1, this.context, (ReteEvaluator)wm);
        Assertions.assertThat((boolean)bm.getSegmentMemory().isSegmentLinked()).isTrue();
        Assertions.assertThat((boolean)rtn1Rs.isRuleLinked()).isTrue();
        Assertions.assertThat((boolean)rtn2Rs.isRuleLinked()).isTrue();
        Assertions.assertThat((boolean)rtn3Rs.isRuleLinked()).isTrue();
        this.n2.retractRightTuple(f2.getFirstRightTuple(), this.context, (ReteEvaluator)wm);
        Assertions.assertThat((boolean)rtn1Rs.isRuleLinked()).isFalse();
        Assertions.assertThat((boolean)rtn2Rs.isRuleLinked()).isFalse();
        Assertions.assertThat((boolean)rtn3Rs.isRuleLinked()).isFalse();
    }
}

