/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession;

import java.beans.PropertyChangeSupport;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.MockObjectSink;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.junit.Before;
import org.junit.Test;

public class PropertyChangeListenerTest {
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;
    private EntryPointNode entryPoint;

    @Before
    public void setUp() throws Exception {
        this.kBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.kBase, Collections.emptyList());
        this.entryPoint = (EntryPointNode)this.buildContext.getRuleBase().getRete().getEntryPointNodes().values().iterator().next();
    }

    @Test
    public void test1() {
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(State.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        State a = new State("go");
        ksession.insert((Object)a, true);
        ksession.fireAllRules();
        Assertions.assertThat((int)sink.getAsserted().size()).isEqualTo(1);
        a.setState("stop");
    }

    public static class State {
        private final PropertyChangeSupport changes = new PropertyChangeSupport(this);
        private String state;

        public State(String state) {
            this.state = state;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String newState) {
            String oldState = this.state;
            this.state = newState;
            this.changes.firePropertyChange("state", oldState, newState);
        }
    }
}

