/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.base.rule.EntryPointId;
import org.drools.base.rule.accessor.GlobalResolver;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.builder.PhreakNodeFactory;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.test.model.Cheese;
import org.drools.core.test.model.Person;
import org.drools.kiesession.MockInternalMatch;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;

public class ReteooWorkingMemoryTest {
    @Test
    @Ignore
    public void testBasicWorkingMemoryActions() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        TruthMaintenanceSystem tms = TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)ksession);
        String string = "test";
        FactHandle fd = ksession.insert((Object)"test");
        InternalFactHandle fz = tms.insert((Object)"test", null, (InternalMatch)new MockInternalMatch());
        Assertions.assertThat((int)tms.getEqualityKeysSize()).isEqualTo(1);
        EqualityKey key = tms.get((Object)"test");
        Assertions.assertThat((Object)key.getFactHandle()).isSameAs((Object)fz);
        Assertions.assertThat((int)key.size()).isEqualTo(2);
        ksession.update(fd, (Object)"test");
        Assertions.assertThat((int)tms.getEqualityKeysSize()).isEqualTo(1);
        key = tms.get((Object)"test");
        Assertions.assertThat((Object)key.getFactHandle()).isSameAs((Object)fz);
        Assertions.assertThat((int)key.size()).isEqualTo(2);
        ksession.retract(fd);
        Assertions.assertThat((int)tms.getEqualityKeysSize()).isEqualTo(1);
        key = tms.get((Object)"test");
        fd = ksession.insert((Object)"test");
        Assertions.assertThat((int)tms.getEqualityKeysSize()).isEqualTo(1);
        Assertions.assertThat((int)tms.getEqualityKeysSize()).isEqualTo(1);
        key = tms.get((Object)"test");
        Assertions.assertThat((Object)key.getFactHandle()).isSameAs((Object)fd);
        Assertions.assertThat((int)key.size()).isEqualTo(1);
    }

    @Test
    public void testId() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        Assertions.assertThat((long)ksession.getIdentifier()).isEqualTo(0L);
        ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        Assertions.assertThat((long)ksession.getIdentifier()).isEqualTo(1L);
    }

    @Test
    public void testGlobalResolver() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("global1", "value1");
        map.put("global2", "value2");
        MapGlobalResolver resolver = new MapGlobalResolver(map);
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        ksession.setGlobalResolver((GlobalResolver)resolver);
        Assertions.assertThat((Object)ksession.getGlobal("global1")).isEqualTo((Object)"value1");
        Assertions.assertThat((Object)ksession.getGlobal("global2")).isEqualTo((Object)"value2");
    }

    @Test
    public void testObjectIterator() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ksession = kBase.newKieSession();
        ksession.insert((Object)new Person("bob", 35));
        ksession.insert((Object)new Cheese("stilton", 35));
        ksession.insert((Object)new Cheese("brie", 35));
        ksession.insert((Object)new Person("steve", 55));
        ksession.insert((Object)new Person("tom", 100));
        int i = 0;
        for (FactHandle fh : ksession.getFactHandles()) {
            if (i++ <= 5) continue;
            Assertions.fail((String)"should not iterate for than 3 times");
        }
        i = 0;
        for (FactHandle fh : ksession.getFactHandles()) {
            if (i++ <= 5) continue;
            Assertions.fail((String)"should not iterate for than 3 times");
        }
    }

    @Test
    @Ignore
    public void testExecuteQueueActions() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        ReentrantAction action = new ReentrantAction();
        ksession.addPropagation((PropagationEntry)action);
        ksession.flushPropagations();
        Assertions.assertThat((int)action.counter.get()).isEqualTo(2);
    }

    @Test
    public void testDifferentEntryPointsOnSameFact() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        Rete rete = kBase.getRete();
        PhreakNodeFactory nFacotry = new PhreakNodeFactory();
        EntryPointNode epn = nFacotry.buildEntryPointNode(kBase.getReteooBuilder().getNodeIdsGenerator().getNextId(), RuleBasePartitionId.MAIN_PARTITION, (ObjectSource)rete, new EntryPointId("xxx"));
        kBase.getRete().addObjectSink((ObjectSink)epn);
        KieSession ksession = kBase.newKieSession();
        FactHandle f1 = ksession.insert((Object)"f1");
        EntryPoint ep = ksession.getEntryPoint("xxx");
        try {
            ep.update(f1, (Object)"s1");
            Assertions.fail((String)"Should throw an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ep.retract(f1);
            Assertions.fail((String)"Should throw an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ksession.update(f1, (Object)"s1");
        Assertions.assertThat((Object)ksession.getObject(f1)).isNotNull();
        ksession.retract(f1);
        ksession.retract(f1);
        Assertions.assertThat((Object)ksession.getObject(f1)).isNull();
    }

    private static class FinalAction
    extends ReentrantAction {
        public AtomicInteger counter;

        public FinalAction(AtomicInteger counter) {
            this.counter = counter;
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.counter.incrementAndGet();
            workingMemory.flushPropagations();
            workingMemory.flushPropagations();
        }
    }

    private static class ReentrantAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        public AtomicInteger counter = new AtomicInteger(0);

        private ReentrantAction() {
        }

        public void internalExecute(ReteEvaluator reteEvaluator) {
            Assertions.assertThat((int)this.counter.get()).isEqualTo(0);
            reteEvaluator.addPropagation((PropagationEntry)new FinalAction(this.counter));
            Assertions.assertThat((int)this.counter.get()).isEqualTo(0);
            reteEvaluator.addPropagation((PropagationEntry)new FinalAction(this.counter));
            Assertions.assertThat((int)this.counter.get()).isEqualTo(0);
            reteEvaluator.getActivationsManager().flushPropagations();
            Assertions.assertThat((int)this.counter.get()).isEqualTo(0);
            reteEvaluator.getActivationsManager().flushPropagations();
            Assertions.assertThat((int)this.counter.get()).isEqualTo(0);
        }
    }
}

