/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession;

import java.io.Serializable;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.core.event.RuleRuntimeEventSupport;
import org.drools.core.test.model.Cheese;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.junit.Test;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class RuleRuntimeEventSupportTest {
    @Test
    public void testIsSerializable() {
        Assertions.assertThat((boolean)Serializable.class.isAssignableFrom(RuleRuntimeEventSupport.class)).isTrue();
    }

    @Test
    public void testRuleRuntimeEventListener() {
        InternalKnowledgeBase rb = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession wm = rb.newKieSession();
        final ArrayList wmList = new ArrayList();
        RuleRuntimeEventListener workingMemoryListener = new RuleRuntimeEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                wmList.add(event);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                wmList.add(event);
            }

            public void objectDeleted(ObjectDeletedEvent event) {
                wmList.add(event);
            }
        };
        wm.addEventListener(workingMemoryListener);
        Assertions.assertThat((int)wm.getRuleRuntimeEventListeners().size()).isEqualTo(1);
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 17);
        FactHandle stiltonHandle = wm.insert((Object)stilton);
        ObjectInsertedEvent oae = (ObjectInsertedEvent)wmList.get(0);
        Assertions.assertThat((Object)oae.getFactHandle()).isSameAs((Object)stiltonHandle);
        wm.update(stiltonHandle, (Object)cheddar);
        ObjectUpdatedEvent ome = (ObjectUpdatedEvent)wmList.get(1);
        Assertions.assertThat((Object)ome.getFactHandle()).isSameAs((Object)stiltonHandle);
        Assertions.assertThat((Object)ome.getObject()).isEqualTo((Object)cheddar);
        Assertions.assertThat((Object)ome.getOldObject()).isEqualTo((Object)stilton);
        wm.retract(stiltonHandle);
        ObjectDeletedEvent ore = (ObjectDeletedEvent)wmList.get(2);
        Assertions.assertThat((Object)ore.getFactHandle()).isSameAs((Object)stiltonHandle);
        FactHandle cheddarHandle = wm.insert((Object)cheddar);
        oae = (ObjectInsertedEvent)wmList.get(3);
        Assertions.assertThat((Object)oae.getFactHandle()).isSameAs((Object)cheddarHandle);
    }

    @Test
    public void testAddRuleRuntimeEventListener() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        final ArrayList wmList = new ArrayList();
        RuleRuntimeEventListener eventListener = new RuleRuntimeEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                wmList.add(event);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                wmList.add(event);
            }

            public void objectDeleted(ObjectDeletedEvent event) {
                wmList.add(event);
            }
        };
        ksession.addEventListener(eventListener);
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 17);
        FactHandle stiltonHandle = ksession.insert((Object)stilton);
        ObjectInsertedEvent oae = (ObjectInsertedEvent)wmList.get(0);
        Assertions.assertThat((Object)oae.getFactHandle()).isSameAs((Object)stiltonHandle);
        ksession.update(stiltonHandle, (Object)stilton);
        ObjectUpdatedEvent ome = (ObjectUpdatedEvent)wmList.get(1);
        Assertions.assertThat((Object)ome.getFactHandle()).isSameAs((Object)stiltonHandle);
        ksession.retract(stiltonHandle);
        ObjectDeletedEvent ore = (ObjectDeletedEvent)wmList.get(2);
        Assertions.assertThat((Object)ore.getFactHandle()).isSameAs((Object)stiltonHandle);
        ksession.insert((Object)cheddar);
    }

    @Test
    public void testRemoveRuleRuntimeEventListener() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        final ArrayList wmList = new ArrayList();
        RuleRuntimeEventListener eventListener = new RuleRuntimeEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                wmList.add(event);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                wmList.add(event);
            }

            public void objectDeleted(ObjectDeletedEvent event) {
                wmList.add(event);
            }
        };
        ksession.addEventListener(eventListener);
        ksession.removeEventListener(eventListener);
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 17);
        FactHandle stiltonHandle = ksession.insert((Object)stilton);
        Assertions.assertThat((boolean)wmList.isEmpty()).isTrue();
        ksession.update(stiltonHandle, (Object)stilton);
        Assertions.assertThat((boolean)wmList.isEmpty()).isTrue();
        ksession.retract(stiltonHandle);
        Assertions.assertThat((boolean)wmList.isEmpty()).isTrue();
        ksession.insert((Object)cheddar);
        Assertions.assertThat((boolean)wmList.isEmpty()).isTrue();
    }
}

