/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor.pattern;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.PatternSourceDescr;
import org.drools.core.util.ClassUtils;
import org.drools.javaparser.ast.drlx.OOPathExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.model.impl.NamesGenerator;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.WindowReferenceGenerator;
import org.drools.modelcompiler.builder.generator.drlxparse.ConstraintExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.ConstraintParser;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseFail;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseResult;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.drlxparse.ParseResultVoidVisitor;
import org.drools.modelcompiler.builder.generator.visitor.DSLNode;
import org.drools.modelcompiler.builder.generator.visitor.FromVisitor;
import org.drools.modelcompiler.builder.generator.visitor.pattern.ConstraintOOPath;
import org.drools.modelcompiler.builder.generator.visitor.pattern.PatternConstraintParseResult;
import org.kie.internal.builder.KnowledgeBuilderResult;

public abstract class PatternDSL
implements DSLNode {
    protected final RuleContext context;
    protected final PackageModel packageModel;
    protected final PatternDescr pattern;
    protected final List<? extends BaseDescr> constraintDescrs;
    protected final Class<?> patternType;
    protected final boolean allConstraintsPositional;

    PatternDSL(RuleContext context, PackageModel packageModel, PatternDescr pattern, List<? extends BaseDescr> constraintDescrs, boolean allConstraintsPositional, Class<?> patternType) {
        this.context = context;
        this.packageModel = packageModel;
        this.pattern = pattern;
        this.constraintDescrs = constraintDescrs;
        this.allConstraintsPositional = allConstraintsPositional;
        this.patternType = patternType;
    }

    public DeclarationSpec initPattern() {
        this.generatePatternIdentifierIfMissing();
        Optional<Expression> declarationSource = this.buildFromDeclaration(this.pattern);
        return this.context.addDeclaration(this.pattern.getIdentifier(), this.patternType, Optional.of(this.pattern), declarationSource);
    }

    protected static boolean isPositional(BaseDescr constraint) {
        return constraint instanceof ExprConstraintDescr && ((ExprConstraintDescr)constraint).getType() == ExprConstraintDescr.Type.POSITIONAL && !constraint.getText().contains(":=");
    }

    private Optional<String> findInnerBindingName(List<PatternConstraintParseResult> firstParsedConstraints) {
        return firstParsedConstraints.stream().map(PatternConstraintParseResult::getDrlxParseResult).filter(DrlxParseResult::isSuccess).map(d -> (DrlxParseSuccess)d).map(DrlxParseSuccess::getExprBinding).filter(Objects::nonNull).findFirst();
    }

    protected Optional<Expression> buildFromDeclaration(PatternDescr pattern) {
        Class patternType;
        Optional<PatternSourceDescr> source = Optional.ofNullable(pattern.getSource());
        try {
            patternType = this.context.getTypeResolver().resolveType(pattern.getObjectType());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Optional<Expression> declarationSourceFrom = source.flatMap(new FromVisitor(this.context, this.packageModel, patternType)::visit);
        if (declarationSourceFrom.isPresent()) {
            return declarationSourceFrom;
        }
        return source.flatMap(new WindowReferenceGenerator(this.packageModel, this.context.getTypeResolver())::visit);
    }

    protected void generatePatternIdentifierIfMissing() {
        if (this.pattern.getIdentifier() == null) {
            String generatedName = NamesGenerator.generateName((String)("pattern_" + this.patternType.getSimpleName()));
            String patternNameAggregated = this.findFirstInnerBinding(this.pattern, this.constraintDescrs, this.patternType).map(ib -> this.context.getAggregatePatternMap().putIfAbsent((String)ib, generatedName)).orElse(generatedName);
            this.pattern.setIdentifier(patternNameAggregated);
        }
    }

    public Optional<String> findFirstInnerBinding(PatternDescr pattern, List<? extends BaseDescr> constraintDescrs, Class<?> patternType) {
        return constraintDescrs.stream().map(constraint -> ConstraintExpression.createConstraintExpression(patternType, constraint, PatternDSL.isPositional(constraint)).getExpression()).map(DrlxParseUtil::parseExpression).filter(drlx -> drlx.getBind() != null).map(drlx -> drlx.getBind().asString()).findFirst();
    }

    protected List<PatternConstraintParseResult> findAllConstraint(PatternDescr pattern, List<? extends BaseDescr> constraintDescrs, Class<?> patternType) {
        ConstraintParser constraintParser = new ConstraintParser(this.context, this.packageModel);
        ArrayList<PatternConstraintParseResult> patternConstraintParseResults = new ArrayList<PatternConstraintParseResult>();
        for (BaseDescr baseDescr : constraintDescrs) {
            String patternIdentifier = pattern.getIdentifier();
            boolean isPositional = PatternDSL.isPositional(baseDescr);
            ConstraintExpression constraintExpression = ConstraintExpression.createConstraintExpression(patternType, baseDescr, isPositional);
            DrlxParseResult drlxParseResult = constraintParser.drlxParse(patternType, patternIdentifier, constraintExpression, isPositional);
            String expression = constraintExpression.getExpression();
            if (drlxParseResult.isSuccess() && ((DrlxParseSuccess)drlxParseResult).isRequiresSplit()) {
                int splitPos = expression.indexOf("&&");
                String expr1 = expression.substring(0, splitPos).trim();
                String expr2 = expr1.substring(0, this.firstNonIdentifierPos(expr1)) + " " + expression.substring(splitPos + 2).trim();
                DrlxParseResult drlxParseResult1 = constraintParser.drlxParse(patternType, patternIdentifier, expr1, isPositional);
                patternConstraintParseResults.add(new PatternConstraintParseResult(expr1, patternIdentifier, drlxParseResult1));
                DrlxParseResult drlxParseResult2 = constraintParser.drlxParse(patternType, patternIdentifier, expr2, isPositional);
                patternConstraintParseResults.add(new PatternConstraintParseResult(expr2, patternIdentifier, drlxParseResult2));
                continue;
            }
            patternConstraintParseResults.add(new PatternConstraintParseResult(expression, patternIdentifier, drlxParseResult));
        }
        return patternConstraintParseResults;
    }

    private int firstNonIdentifierPos(String expr) {
        for (int i = 0; i < expr.length(); ++i) {
            if (Character.isJavaIdentifierPart(expr.charAt(i))) continue;
            return i;
        }
        return expr.length();
    }

    protected void buildConstraint(final PatternDescr pattern, final Class<?> patternType, final PatternConstraintParseResult patternConstraintParseResult) {
        DrlxParseResult drlxParseResult1 = patternConstraintParseResult.getDrlxParseResult();
        final String expression = patternConstraintParseResult.getExpression();
        drlxParseResult1.accept(new ParseResultVoidVisitor(){

            @Override
            public void onSuccess(DrlxParseSuccess drlxParseResult) {
                DSLNode constraint = drlxParseResult.getExpr() instanceof OOPathExpr ? new ConstraintOOPath(PatternDSL.this.context, PatternDSL.this.packageModel, pattern, patternType, patternConstraintParseResult, expression, drlxParseResult) : PatternDSL.this.createSimpleConstraint(drlxParseResult, pattern);
                constraint.buildPattern();
                PatternDSL.this.registerUsedBindingInOr(drlxParseResult.getExprBinding());
            }

            @Override
            public void onFail(DrlxParseFail failure) {
                if (failure.getError() != null) {
                    PatternDSL.this.context.addCompilationError((KnowledgeBuilderResult)failure.getError());
                }
            }
        });
    }

    private void registerUsedBindingInOr(String exprBinding) {
        if (this.context.isNestedInsideOr().booleanValue()) {
            this.context.getBindingOr().add((Object)exprBinding);
        }
    }

    @Override
    public void buildPattern() {
        DeclarationSpec declarationSpec = this.initPattern();
        if (this.constraintDescrs.isEmpty() && !(this.pattern.getSource() instanceof AccumulateDescr)) {
            this.context.addExpression((Expression)this.input(declarationSpec));
        } else {
            List<PatternConstraintParseResult> patternConstraintParseResults = this.findAllConstraint(this.pattern, this.constraintDescrs, this.patternType);
            List<String> allBindings = patternConstraintParseResults.stream().map(p -> p.getDrlxParseResult().acceptWithReturnValue(DrlxParseSuccess::getExprBinding)).filter(Objects::nonNull).collect(Collectors.toList());
            DrlxParseUtil.validateDuplicateBindings(this.context.getRuleName(), allBindings).ifPresent(this.context::addCompilationError);
            if (!this.context.hasErrors()) {
                this.buildPattern(declarationSpec, patternConstraintParseResults);
            }
        }
    }

    protected Set<String> getSettableWatchedProps() {
        HashSet<String> watchedProps = new HashSet<String>();
        watchedProps.addAll(this.context.getRuleDescr().lookAheadFieldsOfIdentifier(this.pattern));
        watchedProps.addAll(DrlxParseUtil.getPatternListenedProperties(this.pattern));
        if (watchedProps.isEmpty()) {
            return watchedProps;
        }
        List settableProps = ClassUtils.getAccessibleProperties(this.patternType);
        HashSet<String> settableWatchedProps = new HashSet<String>();
        for (String watchedProp : watchedProps) {
            String actualProp = watchedProp.startsWith("!") ? watchedProp.substring(1) : watchedProp;
            if (!settableProps.contains(actualProp)) continue;
            settableWatchedProps.add(watchedProp);
        }
        return settableWatchedProps;
    }

    protected abstract void buildPattern(DeclarationSpec var1, List<PatternConstraintParseResult> var2);

    protected abstract MethodCallExpr input(DeclarationSpec var1);

    protected abstract DSLNode createSimpleConstraint(DrlxParseSuccess var1, PatternDescr var2);
}

