/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.model.Consequence;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceImpl;
import org.drools.model.functions.BlockN;
import org.drools.model.functions.ScriptBlock;
import org.drools.model.impl.DeclarationImpl;
import org.drools.modelcompiler.RuleContext;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.consequence.MVELConsequence;
import org.kie.api.builder.Message;

public class ConsequenceValidation {
    private final String packageName;
    private final String consequenceString;
    private final RuleDescr ruleDescr;
    private final List<Variable> variables = new ArrayList<Variable>();
    private String className;

    public ConsequenceValidation(String packageName, String consequenceString, RuleDescr ruleDescr) {
        this.packageName = packageName;
        this.consequenceString = consequenceString;
        this.ruleDescr = ruleDescr;
    }

    public void addVariable(DeclarationSpec d) {
        this.variables.add((Variable)new DeclarationImpl(d.getDeclarationClass(), d.getBindingId()));
    }

    public void validate(final ClassLoader classLoader, ResultsImpl messages) {
        Class<?> ruleClass;
        try {
            ruleClass = classLoader.loadClass(this.className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        final KnowledgePackageImpl pkg = new KnowledgePackageImpl(this.packageName);
        ScriptBlock block = new ScriptBlock(ruleClass, this.consequenceString);
        ConsequenceImpl consequence = new ConsequenceImpl((BlockN)block, this.variables.toArray(new Variable[0]), true, false, "mvel");
        RuleImpl rule = new RuleImpl(this.ruleDescr.getName());
        RuleContext context = new RuleContext(null, pkg, rule){

            @Override
            public Collection<InternalKnowledgePackage> getKnowledgePackages() {
                return Collections.singletonList(pkg);
            }

            @Override
            public ClassLoader getClassLoader() {
                return classLoader;
            }
        };
        try {
            MVELConsequence mvelConsequence = new MVELConsequence((Consequence)consequence, context);
            mvelConsequence.init();
        }
        catch (Exception e) {
            messages.addMessage(Message.Level.ERROR, this.className, "Mvel expression in error" + e.getMessage());
        }
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

