/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.project.codegen;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.codegen.common.DroolsModelBuildContext;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.context.JavaDroolsModelBuildContext;
import org.drools.codegen.common.context.QuarkusDroolsModelBuildContext;
import org.drools.codegen.common.context.SpringBootDroolsModelBuildContext;
import org.drools.drl.extensions.DecisionTableFactory;
import org.drools.drl.extensions.DecisionTableProvider;
import org.drools.model.project.codegen.RuleCodegen;
import org.drools.util.io.FileSystemResource;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.internal.utils.KieService;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;

public class RuleCodegenTest {
    private static final String RESOURCE_PATH = "src/test/resources";

    public static Stream<Arguments> contextBuilders() {
        return Stream.of(Arguments.of((Object[])new Object[]{JavaDroolsModelBuildContext.builder()}), Arguments.of((Object[])new Object[]{QuarkusDroolsModelBuildContext.builder()}), Arguments.of((Object[])new Object[]{SpringBootDroolsModelBuildContext.builder()}));
    }

    @BeforeEach
    public void setup() {
        DecisionTableFactory.setDecisionTableProvider((DecisionTableProvider)((DecisionTableProvider)KieService.load(DecisionTableProvider.class)));
    }

    @ParameterizedTest
    @MethodSource(value={"org.drools.model.project.codegen.RuleCodegenTest#contextBuilders"})
    public void isEmpty(DroolsModelBuildContext.Builder contextBuilder) {
        RuleCodegenTest.withLegacyApi(contextBuilder);
        DroolsModelBuildContext context = contextBuilder.build();
        RuleCodegen emptyCodeGenerator = RuleCodegen.ofResources((DroolsModelBuildContext)context, Collections.emptyList());
        Assertions.assertThat((boolean)emptyCodeGenerator.isEmpty()).isTrue();
        Assertions.assertThat((boolean)emptyCodeGenerator.isEnabled()).isFalse();
        Collection emptyGeneratedFiles = emptyCodeGenerator.generate();
        Assertions.assertThat((int)emptyGeneratedFiles.size()).isEqualTo(0);
        RuleCodegen codeGenerator = this.getRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/drools/model/project/codegen/pkg1/file1.drl"));
        Assertions.assertThat((boolean)codeGenerator.isEmpty()).isFalse();
        Assertions.assertThat((boolean)codeGenerator.isEnabled()).isTrue();
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(1);
    }

    @ParameterizedTest
    @MethodSource(value={"org.drools.model.project.codegen.RuleCodegenTest#contextBuilders"})
    public void generateSingleFile(DroolsModelBuildContext.Builder contextBuilder) {
        RuleCodegenTest.withLegacyApi(contextBuilder);
        RuleCodegen ruleCodegen = this.getRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/drools/model/project/codegen/pkg1/file1.drl"));
        Collection generatedFiles = ruleCodegen.withHotReloadMode().generate();
        this.assertHasLegacyApiFiles(generatedFiles);
        RuleCodegenTest.assertRules(5, 1, generatedFiles.size());
    }

    @ParameterizedTest
    @MethodSource(value={"org.drools.model.project.codegen.RuleCodegenTest#contextBuilders"})
    public void generateSinglePackage(DroolsModelBuildContext.Builder contextBuilder) {
        RuleCodegenTest.withLegacyApi(contextBuilder);
        RuleCodegen ruleCodegen = this.getRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/drools/model/project/codegen/pkg1").listFiles());
        Collection generatedFiles = ruleCodegen.withHotReloadMode().generate();
        this.assertHasLegacyApiFiles(generatedFiles);
        RuleCodegenTest.assertRules(7, 1, generatedFiles.size());
    }

    @ParameterizedTest
    @MethodSource(value={"org.drools.model.project.codegen.RuleCodegenTest#contextBuilders"})
    public void generateSingleDtable(DroolsModelBuildContext.Builder contextBuilder) {
        RuleCodegenTest.withLegacyApi(contextBuilder);
        RuleCodegen ruleCodegen = this.getRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/drools/simple/candrink/CanDrink.drl.xls"));
        Collection generatedFiles = ruleCodegen.withHotReloadMode().generate();
        this.assertHasLegacyApiFiles(generatedFiles);
        int externalizedLambda = 5;
        int legacyApiFiles = 2;
        RuleCodegenTest.assertRules(2, 1, generatedFiles.size() - externalizedLambda - legacyApiFiles);
    }

    @ParameterizedTest
    @MethodSource(value={"org.drools.model.project.codegen.RuleCodegenTest#contextBuilders"})
    public void generateCepRule(DroolsModelBuildContext.Builder contextBuilder) {
        RuleCodegenTest.withLegacyApi(contextBuilder);
        RuleCodegen ruleCodegen = this.getRuleCodegenFromFiles(contextBuilder, new File("src/test/resources/org/drools/simple/cep/cep.drl"));
        Collection generatedFiles = ruleCodegen.withHotReloadMode().generate();
        this.assertHasLegacyApiFiles(generatedFiles);
        int externalizedLambda = 2;
        int legacyApiFiles = 2;
        RuleCodegenTest.assertRules(2, 1, generatedFiles.size() - externalizedLambda - legacyApiFiles);
    }

    private void assertHasLegacyApiFiles(Collection<GeneratedFile> generatedFiles) {
        Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().endsWith("/ProjectModel.java"));
        Assertions.assertThat(generatedFiles.stream()).anyMatch(f -> f.relativePath().endsWith("/ProjectRuntime.java"));
    }

    private RuleCodegen getRuleCodegenFromFiles(DroolsModelBuildContext.Builder contextBuilder, File ... resources) {
        return this.getRuleCodegenFromFiles(contextBuilder.build(), resources);
    }

    private RuleCodegen getRuleCodegenFromFiles(DroolsModelBuildContext context, File ... resources) {
        return RuleCodegen.ofResources((DroolsModelBuildContext)context, RuleCodegenTest.fromFiles(Paths.get(RESOURCE_PATH, new String[0]), resources));
    }

    public static Collection<Resource> fromFiles(Path basePath, File ... files) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try (Stream<File> paths = Arrays.stream(files);){
            paths.filter(File::isFile).map(f -> {
                FileSystemResource resource = new FileSystemResource(f);
                resource.setResourceType(ResourceType.determineResourceType((String)f.getName()));
                return resource;
            }).forEach(resources::add);
        }
        return resources;
    }

    static void withLegacyApi(DroolsModelBuildContext.Builder builder) {
    }

    @Deprecated
    private static void assertRules(int expectedRules, int expectedPackages, int actualGeneratedFiles) {
        int expectedFiles = expectedRules + expectedPackages * 2;
        Assertions.assertThat((int)actualGeneratedFiles).isEqualTo(expectedFiles);
    }
}

