/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import org.drools.Gender;
import org.drools.Person;
import org.drools.mvelcompiler.MvelCompiler;
import org.drools.mvelcompiler.ParsingResult;
import org.drools.mvelcompiler.context.MvelCompilerContext;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.kie.soup.project.datamodel.commons.types.ClassTypeResolver;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

interface CompilerTest {
    default public void test(Consumer<MvelCompilerContext> testFunction, String actualExpression, String expectedResult, Consumer<ParsingResult> resultAssert) {
        HashSet<String> imports = new HashSet<String>();
        imports.add("java.util.List");
        imports.add("java.util.ArrayList");
        imports.add("java.util.HashMap");
        imports.add("java.util.Map");
        imports.add("java.math.BigDecimal");
        imports.add("org.drools.Address");
        imports.add(Person.class.getCanonicalName());
        imports.add(Gender.class.getCanonicalName());
        ClassTypeResolver typeResolver = new ClassTypeResolver(imports, this.getClass().getClassLoader());
        MvelCompilerContext mvelCompilerContext = new MvelCompilerContext((TypeResolver)typeResolver);
        testFunction.accept(mvelCompilerContext);
        ParsingResult compiled = new MvelCompiler(mvelCompilerContext).compile(actualExpression);
        Assert.assertThat((Object)compiled.resultAsString(), (Matcher)Matchers.equalToIgnoringWhiteSpace((String)expectedResult));
        resultAssert.accept(compiled);
    }

    default public void test(String actualExpression, String expectedResult, Consumer<ParsingResult> resultAssert) {
        this.test(id -> {}, actualExpression, expectedResult, resultAssert);
    }

    default public void test(Consumer<MvelCompilerContext> testFunction, String actualExpression, String expectedResult) {
        this.test(testFunction, actualExpression, expectedResult, t -> {});
    }

    default public void test(String actualExpression, String expectedResult) {
        this.test(d -> {}, actualExpression, expectedResult, t -> {});
    }

    default public Collection<String> allUsedBindings(ParsingResult result) {
        return new ArrayList<String>(result.getUsedBindings());
    }
}

