/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import java.util.Map;
import org.drools.Person;
import org.drools.mvelcompiler.CompilerTest;
import org.drools.mvelcompiler.ParsingResult;
import org.drools.mvelcompiler.context.MvelCompilerContext;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MvelCompilerTest
implements CompilerTest {
    @Test
    public void testConvertPropertyToAccessor() {
        String expectedJavaCode = "{ $p.getParent().getParent().getName(); }";
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ $p.parent.getParent().name; } ", expectedJavaCode);
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ $p.getParent().parent.name; } ", expectedJavaCode);
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ $p.parent.parent.name; } ", expectedJavaCode);
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ $p.getParent().getParent().getName(); } ", expectedJavaCode);
    }

    @Test
    public void testAccessorInArguments() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ insert(\"Modified person age to 1 for: \" + $p.name); }", "{ insert(\"Modified person age to 1 for: \" + $p.getName()); } ");
    }

    @Test
    public void testEnumField() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ key = $p.gender.getKey(); } ", "{ int key = $p.getGender().getKey(); }");
    }

    @Test
    public void testEnumConstant() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ key = Gender.FEMALE.getKey(); } ", "{ int key = Gender.FEMALE.getKey(); }");
    }

    @Test
    public void testPublicField() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ $p.parentPublic.getParent().name; } ", "{ $p.parentPublic.getParent().getName(); }");
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ $p.getParent().parentPublic.name; } ", "{ $p.getParent().parentPublic.getName(); }");
    }

    @Test
    public void testUncompiledMethod() {
        this.test("{ System.out.println(\"Hello World\"); }", "{ System.out.println(\"Hello World\"); }");
    }

    @Test
    public void testStringLength() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ $p.name.length; }", "{ $p.getName().length(); }");
    }

    @Test
    public void testAssignment() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ Person np = $p; np = $p; }", "{ org.drools.Person np = $p; np = $p; }");
    }

    @Test
    public void testAssignmentUndeclared() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ np = $p; }", "{ org.drools.Person np = $p; }");
    }

    @Test
    public void testSetter() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ $p.name = \"Luca\"; }", "{ $p.setName(\"Luca\"); }");
    }

    @Test
    public void testSetterPublicField() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ $p.nickName = \"Luca\"; } ", "{ $p.nickName = \"Luca\"; } ");
    }

    @Test
    public void withoutSemicolonAndComment() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{             delete($person) // some comment\ndelete($pet) // another comment\n}", "{             delete($person);\ndelete($pet);\n}");
    }

    @Test
    public void testInitializerArrayAccess() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ l = new ArrayList(); l.add(\"first\"); System.out.println(l[0]); }", "{ java.util.ArrayList l = new ArrayList(); l.add(\"first\"); System.out.println(l.get(0)); }");
    }

    @Test
    public void testInitializerMap() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{ m = new HashMap();\nm.put(\"key\", 2);\nSystem.out.println(m[\"key\"]);\n}", "{ java.util.HashMap m = new HashMap();\nm.put(\"key\", 2);\nSystem.out.println(m.get(\"key\"));\n}");
    }

    @Test
    public void testMixArrayMap() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{     m = new HashMap();\n    l = new ArrayList();\n    l.add(\"first\");\n    m.put(\"content\", l);\n    System.out.println(((ArrayList)m[\"content\"])[0]);\n    list.add(((ArrayList)m[\"content\"])[0]);\n}", "{     java.util.HashMap m = new HashMap();\n    java.util.ArrayList l = new ArrayList();\n    l.add(\"first\");\n    m.put(\"content\", l);\n    System.out.println(((java.util.ArrayList) m.get(\"content\")).get(0));\n    list.add(((java.util.ArrayList) m.get(\"content\")).get(0));\n}");
    }

    @Test
    public void testBigDecimal() {
        this.test("{     BigDecimal sum = 0;\n    BigDecimal money = 10;\n    sum += money;\n    sum -= money;\n}", "{     java.math.BigDecimal sum = java.math.BigDecimal.valueOf(0);\n    java.math.BigDecimal money = java.math.BigDecimal.valueOf(10);\n    sum = sum.add(money);\n    sum = sum.subtract(money);\n}");
    }

    @Test
    public void testModify() {
        this.test(ctx -> ctx.addDeclaration("$p", Person.class), "{ modify ( $p )  { name = \"Luca\", age = 35 }; }", "{ $p.setName(\"Luca\"); $p.setAge(35); }", result -> Assert.assertThat(this.allUsedBindings((ParsingResult)result), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"$p"})));
    }

    @Test
    public void testModifySemiColon() {
        this.test(ctx -> ctx.addDeclaration("$p", Person.class), "{ modify($p) { setAge(1); }; }", "{ $p.setAge(1); }", result -> Assert.assertThat(this.allUsedBindings((ParsingResult)result), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"$p"})));
    }

    @Test
    public void testModifyWithAssignment() {
        this.test(ctx -> ctx.addDeclaration("$p", Person.class), "{ modify($p) { age = $p.age+1 }; }", "{ $p.setAge($p.getAge() + 1); }", result -> Assert.assertThat(this.allUsedBindings((ParsingResult)result), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"$p"})));
    }

    @Test
    public void testWithSemiColon() {
        this.test("{ with( $l = new ArrayList()) { $l.add(2); }; }", "{ java.util.ArrayList $l = new ArrayList(); $l.add(2); }", (ParsingResult result) -> Assert.assertThat(this.allUsedBindings((ParsingResult)result), (Matcher)Matchers.is((Matcher)Matchers.empty())));
    }

    @Test
    public void testWithWithAssignment() {
        this.test(ctx -> ctx.addDeclaration("$p", Person.class), "{ with($p = new Person()) { age = $p.age+1 }; }", "{ org.drools.Person $p = new Person(); $p.setAge($p.getAge() + 1); }", result -> Assert.assertThat(this.allUsedBindings((ParsingResult)result), (Matcher)Matchers.is((Matcher)Matchers.empty())));
    }

    @Test
    public void testVariableDeclarationUntyped() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$map", Map.class), " { Map pMap = map.get( $r.getName() ); }", " { java.util.Map pMap = (java.util.Map) (map.get($r.getName())); }");
    }

    @Test
    public void testSimpleVariableDeclaration() {
        this.test(" { int i; }", " { int i; }");
    }

    @Test
    public void testModifyInsideIfBlock() {
        this.test(ctx -> ctx.addDeclaration("$p", Person.class), "{             if ($p.getParent() != null) {\n              $p.setName(\"with_parent\");\n         } else {\n         modify ($p) {\n            name = \"without_parent\"         }\n         }      }", "{   if ($p.getParent() != null) {       $p.setName(\"with_parent\");   } else {       $p.setName(\"without_parent\");   } }", result -> Assert.assertThat(this.allUsedBindings((ParsingResult)result), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"$p"})));
    }

    @Test
    public void testWithOrdering() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$p", Person.class), "{         with( s0 = new Person() ) {\n            age = 0\n        }\n        insertLogical(s0);\n        with( s1 = new Person() ) {\n            age = 1\n        }\n        insertLogical(s1);\n      }", "{ org.drools.Person s1 = new Person(); org.drools.Person s0 = new Person(); insertLogical(s0); insertLogical(s1); s0.setAge(0); s1.setAge(1); }");
    }

    @Test
    public void testModifyOrdering() {
        this.test((MvelCompilerContext ctx) -> ctx.addDeclaration("$person", Person.class), "{        Address $newAddress = new Address();\n        $newAddress.setCity( \"Brno\" );\n        insert( $newAddress );\n        modify( $person ) {\n          setAddress( $newAddress )\n        }}", "{ org.drools.Address $newAddress = new Address(); $newAddress.setCity(\"Brno\"); insert($newAddress); $person.setAddress($newAddress); }");
    }
}

