/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import java.util.HashSet;
import java.util.function.Consumer;
import org.drools.Gender;
import org.drools.Person;
import org.drools.core.addon.ClassTypeResolver;
import org.drools.core.addon.TypeResolver;
import org.drools.mvelcompiler.CompiledExpressionResult;
import org.drools.mvelcompiler.CompilerTest;
import org.drools.mvelcompiler.ConstraintCompiler;
import org.drools.mvelcompiler.context.MvelCompilerContext;
import org.junit.Test;

public class ConstraintCompilerTest
implements CompilerTest {
    @Test
    public void testBigDecimalPromotion() {
        this.testExpression(c -> {
            c.setRootPattern(Person.class);
            c.setRootTypePrefix("_this");
        }, "salary + salary", "_this.getSalary().add(_this.getSalary())");
    }

    public void testExpression(Consumer<MvelCompilerContext> testFunction, String inputExpression, String expectedResult, Consumer<CompiledExpressionResult> resultAssert) {
        HashSet<String> imports = new HashSet<String>();
        imports.add("java.util.List");
        imports.add("java.util.ArrayList");
        imports.add("java.util.HashMap");
        imports.add("java.util.Map");
        imports.add("java.math.BigDecimal");
        imports.add("org.drools.Address");
        imports.add(Person.class.getCanonicalName());
        imports.add(Gender.class.getCanonicalName());
        ClassTypeResolver typeResolver = new ClassTypeResolver(imports, this.getClass().getClassLoader());
        MvelCompilerContext mvelCompilerContext = new MvelCompilerContext((TypeResolver)typeResolver);
        testFunction.accept(mvelCompilerContext);
        CompiledExpressionResult compiled = new ConstraintCompiler(mvelCompilerContext).compileExpression(inputExpression);
        this.verifyBodyWithBetterDiff(expectedResult, compiled.resultAsString());
        resultAssert.accept(compiled);
    }

    void testExpression(Consumer<MvelCompilerContext> testFunction, String inputExpression, String expectedResult) {
        this.testExpression(testFunction, inputExpression, expectedResult, t -> {});
    }
}

