/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import java.io.InputStream;
import java.util.Map;
import org.drools.core.util.StringUtils;
import org.drools.mvel.parser.printer.PrintUtil;
import org.drools.mvelcompiler.CompiledResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluatorGenerator {
    private static final Logger LOG = LoggerFactory.getLogger((String)EvaluatorGenerator.class.getName());
    private CompilationUnit template;
    private ClassOrInterfaceDeclaration evaluatorClass;
    private BlockStmt methodBody;
    private BlockStmt bindingAssignmentBlock;
    private BlockStmt mvelExecutionBlock;
    private BlockStmt repopulateMapBlock;
    private Statement lastMVELStatement;
    private Statement lastBodyStatement;
    private static final String RESULT_VALUE_REFERENCE_NAME = "___resultValue";

    public CompilationUnit createEvaluatorClass(String originalExpression, CompiledResult input, Map<String, Object> vars) {
        this.loadTemplate();
        this.renameTemplateClass(originalExpression);
        this.clearExamples();
        for (Map.Entry<String, Object> entry : vars.entrySet()) {
            this.createContextVariableAssignments(entry);
        }
        BlockStmt compiledMVELBlock = input.statementResults();
        this.mvelExecutionBlock.replace((Node)compiledMVELBlock);
        this.lastMVELStatement = this.lastStatementOfABlock(compiledMVELBlock);
        this.lastBodyStatement = this.lastStatementOfABlock(this.methodBody);
        this.defineLastStatement(compiledMVELBlock);
        this.logGenerateClass();
        return this.template;
    }

    private Statement lastStatementOfABlock(BlockStmt mvelBlock) {
        NodeList statements = mvelBlock.getStatements();
        return (Statement)statements.get(statements.size() - 1);
    }

    private void clearExamples() {
        for (VariableDeclarationExpr variableDeclarationExpr : this.methodBody.findAll(VariableDeclarationExpr.class)) {
            variableDeclarationExpr.getParentNode().ifPresent(Node::remove);
        }
    }

    private void renameTemplateClass(String originalExpression) {
        String newName = String.format("Evaluator%s", StringUtils.md5Hash((String)originalExpression));
        EvaluatorGenerator.replaceSimpleNameWith((Node)this.evaluatorClass, "EvaluatorTemplate", newName);
    }

    private void logGenerateClass() {
        LOG.debug(PrintUtil.printNode((Node)this.template));
    }

    private void defineLastStatement(BlockStmt mvelBlock) {
        if (!this.lastMVELStatement.isExpressionStmt()) {
            return;
        }
        Expression expression = this.lastMVELStatement.asExpressionStmt().getExpression();
        this.addResultReference();
        if (expression.isMethodCallExpr() && expression.asMethodCallExpr().getNameAsString().startsWith("set")) {
            this.lastStatementIsGetter(mvelBlock, expression);
        } else {
            AssignExpr assignExpr = new AssignExpr((Expression)new NameExpr(RESULT_VALUE_REFERENCE_NAME), expression, AssignExpr.Operator.ASSIGN);
            mvelBlock.replace((Node)this.lastMVELStatement, (Node)new ExpressionStmt((Expression)assignExpr));
        }
        this.returnResult();
    }

    private void lastStatementIsGetter(BlockStmt mvelBlock, Expression expression) {
        MethodCallExpr methodCallExprClone = expression.asMethodCallExpr().clone();
        String getterName = methodCallExprClone.getName().asString().replace("set", "get");
        MethodCallExpr getter = new MethodCallExpr(getterName, new Expression[0]);
        methodCallExprClone.getScope().ifPresent(arg_0 -> ((MethodCallExpr)getter).setScope(arg_0));
        AssignExpr assignExpr = new AssignExpr((Expression)new NameExpr(RESULT_VALUE_REFERENCE_NAME), (Expression)getter, AssignExpr.Operator.ASSIGN);
        mvelBlock.addStatement((Expression)assignExpr);
    }

    private void returnResult() {
        ReturnStmt node = new ReturnStmt((Expression)new NameExpr(RESULT_VALUE_REFERENCE_NAME));
        this.lastBodyStatement.replace((Node)node);
    }

    private void addResultReference() {
        VariableDeclarationExpr returnVariable = new VariableDeclarationExpr(StaticJavaParser.parseType((String)Object.class.getCanonicalName()), RESULT_VALUE_REFERENCE_NAME);
        this.methodBody.addStatement(0, (Expression)returnVariable);
    }

    private void createContextVariableAssignments(Map.Entry<String, Object> entry) {
        String binding = entry.getKey();
        Object contextVar = entry.getValue();
        if (contextVar != null) {
            Class<?> contextVarClass;
            Class<?> clazz = contextVarClass = contextVar instanceof Class ? (Class<?>)contextVar : contextVar.getClass();
            if (contextVarClass != null && contextVarClass.getCanonicalName() != null) {
                Type type = StaticJavaParser.parseType((String)contextVarClass.getCanonicalName());
                VariableDeclarationExpr variable = new VariableDeclarationExpr(type, binding);
                CastExpr indexMethodExpression = new CastExpr(type, (Expression)new MethodCallExpr((Expression)new NameExpr("map"), "get", NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(binding)})));
                this.methodBody.addStatement(0, (Expression)variable);
                AssignExpr expr = new AssignExpr((Expression)new NameExpr(binding), (Expression)indexMethodExpression, AssignExpr.Operator.ASSIGN);
                this.bindingAssignmentBlock.addStatement((Expression)expr);
                MethodCallExpr putExpr = new MethodCallExpr((Expression)new NameExpr("map"), "put", NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(binding), new NameExpr(binding)}));
                this.repopulateMapBlock.addStatement((Expression)putExpr);
            }
        }
    }

    private void loadTemplate() {
        this.template = this.getMethodTemplate();
        this.evaluatorClass = (ClassOrInterfaceDeclaration)this.template.getClassByName("EvaluatorTemplate").orElseThrow(() -> new RuntimeException("Cannot find class"));
        MethodDeclaration methodDeclaration = (MethodDeclaration)this.evaluatorClass.findFirst(MethodDeclaration.class).orElseThrow(() -> new RuntimeException("cannot find Method"));
        this.methodBody = (BlockStmt)methodDeclaration.findFirst(BlockStmt.class).orElseThrow(() -> new RuntimeException("cannot find method body"));
        this.bindingAssignmentBlock = this.findBlock(" binding assignment");
        this.mvelExecutionBlock = this.findBlock(" execute MVEL here");
        this.repopulateMapBlock = this.findBlock(" repopulate map");
    }

    private BlockStmt findBlock(String comment) {
        BlockStmt block = (BlockStmt)this.methodBody.findFirst(BlockStmt.class, b -> EvaluatorGenerator.blockHasComment(b, comment)).orElseThrow(() -> new RuntimeException(comment + " not found"));
        block.getStatements().clear();
        return block;
    }

    private CompilationUnit getMethodTemplate() {
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/org/drools/mvel/EvaluatorTemplate.java");
        return StaticJavaParser.parse((InputStream)resourceAsStream);
    }

    public static void replaceSimpleNameWith(Node source, String oldName, String newName) {
        source.findAll(SimpleName.class, ne -> ne.toString().equals(oldName)).forEach(r -> r.replace((Node)new SimpleName(newName)));
    }

    private static boolean blockHasComment(BlockStmt block, String comment) {
        return block.getComment().filter(c -> comment.equals(c.getContent())).isPresent();
    }
}

