/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.drools.Gender;
import org.drools.Person;
import org.drools.mvelcompiler.CompiledBlockResult;
import org.drools.mvelcompiler.MvelCompiler;
import org.drools.mvelcompiler.context.MvelCompilerContext;
import org.drools.util.ClassTypeResolver;
import org.drools.util.TypeResolver;

interface CompilerTest {
    default public void test(Consumer<MvelCompilerContext> testFunction, String inputExpression, String expectedResult, Consumer<CompiledBlockResult> resultAssert) {
        HashSet<String> imports = new HashSet<String>();
        imports.add("java.util.List");
        imports.add("java.util.ArrayList");
        imports.add("java.util.HashMap");
        imports.add("java.util.Map");
        imports.add("java.math.BigDecimal");
        imports.add("org.drools.Address");
        imports.add(Person.class.getCanonicalName());
        imports.add(Gender.class.getCanonicalName());
        ClassTypeResolver typeResolver = new ClassTypeResolver(imports, this.getClass().getClassLoader());
        MvelCompilerContext mvelCompilerContext = new MvelCompilerContext((TypeResolver)typeResolver);
        testFunction.accept(mvelCompilerContext);
        CompiledBlockResult compiled = new MvelCompiler(mvelCompilerContext).compileStatement(inputExpression);
        this.verifyBodyWithBetterDiff(expectedResult, compiled.resultAsString());
        resultAssert.accept(compiled);
    }

    default public void verifyBodyWithBetterDiff(Object expected, Object actual) {
        try {
            Assertions.assertThat((Object)actual).asString().isEqualToIgnoringWhitespace((CharSequence)expected.toString());
        }
        catch (AssertionError e) {
            Assertions.assertThat((Object)actual).isEqualTo(expected);
        }
    }

    default public void test(String inputExpression, String expectedResult, Consumer<CompiledBlockResult> resultAssert) {
        this.test(id -> {}, inputExpression, expectedResult, resultAssert);
    }

    default public void test(Consumer<MvelCompilerContext> testFunction, String inputExpression, String expectedResult) {
        this.test(testFunction, inputExpression, expectedResult, t -> {});
    }

    default public void test(String inputExpression, String expectedResult) {
        this.test(d -> {}, inputExpression, expectedResult, t -> {});
    }

    default public Collection<String> allUsedBindings(CompiledBlockResult result) {
        return new ArrayList<String>(result.getUsedBindings());
    }
}

