/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.function.Consumer;
import org.drools.Gender;
import org.drools.Person;
import org.drools.mvelcompiler.CompiledExpressionResult;
import org.drools.mvelcompiler.CompilerTest;
import org.drools.mvelcompiler.ConstraintCompiler;
import org.drools.mvelcompiler.context.MvelCompilerContext;
import org.drools.util.ClassTypeResolver;
import org.drools.util.TypeResolver;
import org.junit.Test;

public class ConstraintCompilerTest
implements CompilerTest {
    @Test
    public void testBigDecimalPromotion() {
        this.testExpression(c -> c.setRootPatternPrefix(Person.class, "_this"), "salary + salary", "_this.getSalary().add(_this.getSalary(), java.math.MathContext.DECIMAL128)");
    }

    @Test
    public void testBigDecimalStringEquality() {
        this.testExpression(c -> c.setRootPatternPrefix(Person.class, "_this"), "salary == \"90\"", "_this.getSalary().compareTo(new java.math.BigDecimal(\"90\")) == 0");
    }

    @Test
    public void testBigDecimalStringNonEquality() {
        this.testExpression(c -> c.setRootPatternPrefix(Person.class, "_this"), "salary != \"90\"", "_this.getSalary().compareTo(new java.math.BigDecimal(\"90\")) != 0");
    }

    @Test
    public void testBigDecimalPromotionToIntMethod() {
        this.testExpression(c -> c.setRootPatternPrefix(Person.class, "_this"), "isEven(salary)", "_this.isEven(_this.getSalary().intValue())");
    }

    @Test
    public void testConversionConstructorArgument() {
        this.testExpression(c -> c.addDeclaration("$p", Person.class), "new Person($p.name, $p)", "new org.drools.Person($p.getName(), $p)");
    }

    @Test
    public void testBigDecimalMultiplyInt() {
        this.testExpression(c -> c.addDeclaration("$bd1", BigDecimal.class), "$bd1 * 10", "$bd1.multiply(new java.math.BigDecimal(10), java.math.MathContext.DECIMAL128)");
    }

    @Test
    public void testBigDecimalMultiplyNegativeInt() {
        this.testExpression(c -> c.addDeclaration("$bd1", BigDecimal.class), "$bd1 * -1", "$bd1.multiply(new java.math.BigDecimal(-1), java.math.MathContext.DECIMAL128)");
    }

    @Test
    public void testBigDecimalAddInt() {
        this.testExpression(c -> c.addDeclaration("$bd1", BigDecimal.class), "$bd1 + 10", "$bd1.add(new java.math.BigDecimal(10), java.math.MathContext.DECIMAL128)");
    }

    @Test
    public void testBigDecimalSubtractInt() {
        this.testExpression(c -> c.addDeclaration("$bd1", BigDecimal.class), "$bd1 - 10", "$bd1.subtract(new java.math.BigDecimal(10), java.math.MathContext.DECIMAL128)");
    }

    @Test
    public void testBigDecimalDivideInt() {
        this.testExpression(c -> c.addDeclaration("$bd1", BigDecimal.class), "$bd1 / 10", "$bd1.divide(new java.math.BigDecimal(10), java.math.MathContext.DECIMAL128)");
    }

    @Test
    public void testBigDecimalModInt() {
        this.testExpression(c -> c.addDeclaration("$bd1", BigDecimal.class), "$bd1 % 10", "$bd1.remainder(new java.math.BigDecimal(10), java.math.MathContext.DECIMAL128)");
    }

    public void testExpression(Consumer<MvelCompilerContext> testFunction, String inputExpression, String expectedResult, Consumer<CompiledExpressionResult> resultAssert) {
        HashSet<String> imports = new HashSet<String>();
        imports.add("java.util.List");
        imports.add("java.util.ArrayList");
        imports.add("java.util.HashMap");
        imports.add("java.util.Map");
        imports.add("java.math.BigDecimal");
        imports.add("org.drools.Address");
        imports.add(Person.class.getCanonicalName());
        imports.add(Gender.class.getCanonicalName());
        ClassTypeResolver typeResolver = new ClassTypeResolver(imports, this.getClass().getClassLoader());
        MvelCompilerContext mvelCompilerContext = new MvelCompilerContext((TypeResolver)typeResolver);
        testFunction.accept(mvelCompilerContext);
        CompiledExpressionResult compiled = new ConstraintCompiler(mvelCompilerContext).compileExpression(inputExpression);
        this.verifyBodyWithBetterDiff(expectedResult, compiled.resultAsString());
        resultAssert.accept(compiled);
    }

    void testExpression(Consumer<MvelCompilerContext> testFunction, String inputExpression, String expectedResult) {
        this.testExpression(testFunction, inputExpression, expectedResult, t -> {});
    }
}

