/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder.dialect.mvel;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleBuilder;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.WorkingMemory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DefaultKnowledgeHelper;
import org.drools.core.common.AgendaItemImpl;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.ImportDeclaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.Activation;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PatternExtractor;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.builder.MVELConsequenceBuilder;
import org.drools.mvel.builder.MVELDialect;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.rule.builder.dialect.mvel.InstrumentedDeclarationScopeResolver;
import org.drools.mvel.expr.MVELConsequence;
import org.drools.mvel.expr.MVELDebugHandler;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.mvel2.ParserContext;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.debug.DebugTools;

public class MVELConsequenceBuilderTest {
    private RuleBuildContext context;
    private RuleDescr ruleDescr;
    private MVELConsequenceBuilder builder;

    @Test
    public void testSimpleExpression() throws Exception {
        PackageDescr pkgDescr = new PackageDescr("pkg1");
        KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl();
        pkgBuilder.addPackage(pkgDescr);
        InternalKnowledgePackage pkg = pkgBuilder.getPackageRegistry("pkg1").getPackage();
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        ruleDescr.setNamespace("pkg1");
        ruleDescr.setConsequence((Object)"modify (cheese) {price = 5 };\nretract (cheese)");
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        RuleBuildContext context = new RuleBuildContext((DroolsAssemblerContext)pkgBuilder, ruleDescr, dialectRegistry, pkg, (Dialect)mvelDialect);
        InstrumentedDeclarationScopeResolver declarationResolver = new InstrumentedDeclarationScopeResolver();
        ClassObjectType cheeseObjeectType = new ClassObjectType(Cheese.class);
        Pattern pattern = new Pattern(0, (ObjectType)cheeseObjeectType, "cheese");
        GroupElement subrule = new GroupElement(GroupElement.AND);
        subrule.addChild((RuleConditionElement)pattern);
        HashMap<String, Declaration> map = new HashMap<String, Declaration>();
        map.put("cheese", pattern.getDeclaration());
        declarationResolver.setDeclarations(map);
        context.setDeclarationResolver((DeclarationScopeResolver)declarationResolver);
        MVELConsequenceBuilder builder = new MVELConsequenceBuilder();
        builder.build(context, "default");
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        PropagationContextFactory pctxFactory = kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        kBase.addPackage((KiePackage)pkg);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        BuildContext buildContext = new BuildContext(kBase);
        MockTupleSource source = new MockTupleSource(1, buildContext);
        source.setObjectCount(1);
        RuleTerminalNode rtn = new RuleTerminalNode(0, (LeftTupleSource)source, context.getRule(), subrule, 0, buildContext);
        Cheese cheddar = new Cheese("cheddar", 10);
        InternalFactHandle f0 = (InternalFactHandle)ksession.insert((Object)cheddar);
        LeftTupleImpl tuple = new LeftTupleImpl(f0, (Sink)rtn, true);
        f0.removeLeftTuple((LeftTuple)tuple);
        AgendaItemImpl item = new AgendaItemImpl(0L, (Tuple)tuple, 10, pctxFactory.createPropagationContext(1L, PropagationContext.Type.DELETION, null, null, null), (TerminalNode)rtn, null);
        DefaultKnowledgeHelper kbHelper = new DefaultKnowledgeHelper((WorkingMemory)ksession);
        kbHelper.setActivation((Activation)item);
        ((MVELConsequence)context.getRule().getConsequence()).compile((MVELDialectRuntimeData)pkgBuilder.getPackageRegistry(pkg.getName()).getDialectRuntimeRegistry().getDialectData("mvel"));
        context.getRule().getConsequence().evaluate((KnowledgeHelper)kbHelper, (WorkingMemory)ksession);
        Assert.assertEquals((long)5L, (long)cheddar.getPrice());
    }

    @Test
    public void testImperativeCodeError() throws Exception {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("pkg1");
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        ruleDescr.setConsequence((Object)"if (cheese.price == 10) { cheese.price = 5; }");
        Properties properties = new Properties();
        properties.setProperty("drools.dialect.default", "mvel");
        KnowledgeBuilderConfigurationImpl cfg1 = new KnowledgeBuilderConfigurationImpl(properties);
        KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl((InternalKnowledgePackage)pkg, cfg1);
        PackageRegistry pkgRegistry = pkgBuilder.getPackageRegistry(pkg.getName());
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect(pkgRegistry.getDialect());
        RuleBuildContext context = new RuleBuildContext((DroolsAssemblerContext)pkgBuilder, ruleDescr, dialectRegistry, (InternalKnowledgePackage)pkg, (Dialect)mvelDialect);
        InstrumentedDeclarationScopeResolver declarationResolver = new InstrumentedDeclarationScopeResolver();
        ClassObjectType cheeseObjeectType = new ClassObjectType(Cheese.class);
        Pattern pattern = new Pattern(0, (ObjectType)cheeseObjeectType);
        PatternExtractor extractor = new PatternExtractor((ObjectType)cheeseObjeectType);
        Declaration declaration = new Declaration("cheese", (InternalReadAccessor)extractor, pattern);
        HashMap<String, Declaration> map = new HashMap<String, Declaration>();
        map.put("cheese", declaration);
        declarationResolver.setDeclarations(map);
        context.setDeclarationResolver((DeclarationScopeResolver)declarationResolver);
        MVELConsequenceBuilder builder = new MVELConsequenceBuilder();
        builder.build(context, "default");
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        Cheese cheddar = new Cheese("cheddar", 10);
        InternalFactHandle f0 = (InternalFactHandle)ksession.insert((Object)cheddar);
        LeftTupleImpl tuple = new LeftTupleImpl(f0, null, true);
        AgendaItemImpl item = new AgendaItemImpl(0L, (Tuple)tuple, 10, null, null, null);
        DefaultKnowledgeHelper kbHelper = new DefaultKnowledgeHelper((WorkingMemory)ksession);
        kbHelper.setActivation((Activation)item);
        try {
            ((MVELConsequence)context.getRule().getConsequence()).compile((MVELDialectRuntimeData)pkgBuilder.getPackageRegistry(pkg.getName()).getDialectRuntimeRegistry().getDialectData("mvel"));
            context.getRule().getConsequence().evaluate((KnowledgeHelper)kbHelper, (WorkingMemory)ksession);
            Assert.fail((String)"should throw an exception, as 'if' is not allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)10L, (long)cheddar.getPrice());
    }

    @Test
    public void testLineSpanOptionalSemis() throws Exception {
        String simpleEx = "foo\nbar\nbaz";
        Assert.assertEquals((Object)"foo;\nbar;\nbaz", (Object)MVELConsequenceBuilder.delimitExpressions((String)simpleEx));
        String ex = "foo (\n bar \n)\nbar;\nyeah;\nman\nbaby";
        Assert.assertEquals((Object)"foo ( bar );\n\n\nbar;\nyeah;\nman;\nbaby", (Object)MVELConsequenceBuilder.delimitExpressions((String)ex));
        ex = "foo {\n bar \n}\nbar;   \nyeah;\nman\nbaby";
        Assert.assertEquals((Object)"foo { bar };\n\n\nbar;   \nyeah;\nman;\nbaby", (Object)MVELConsequenceBuilder.delimitExpressions((String)ex));
        ex = "foo [\n bar \n]\nbar;  x\nyeah();\nman[42]\nbaby;ca chiga;\nend";
        Assert.assertEquals((Object)"foo [ bar ];\n\n\nbar;  x;\nyeah();\nman[42];\nbaby;ca chiga;\nend", (Object)MVELConsequenceBuilder.delimitExpressions((String)ex));
        ex = "   \n\nfoo [\n bar \n]\n\n\nbar;  x\n  \nyeah();\nman[42]\nbaby;ca chiga;\nend";
        Assert.assertEquals((Object)"   \n\nfoo [ bar ];\n\n\n\n\nbar;  x;\n  \nyeah();\nman[42];\nbaby;ca chiga;\nend", (Object)MVELConsequenceBuilder.delimitExpressions((String)ex));
        ex = "   retract(f1) // some comment\n   retract(f2)\nend";
        Assert.assertEquals((Object)"   retract(f1) ;// some comment\n   retract(f2);\nend", (Object)MVELConsequenceBuilder.delimitExpressions((String)ex));
        ex = "   retract(f1 /* inline comment */) /* some\n comment\n*/   retract(f2)\nend";
        Assert.assertEquals((Object)"   retract(f1 /* inline comment */) ;/* some\n comment\n*/   retract(f2);\nend", (Object)MVELConsequenceBuilder.delimitExpressions((String)ex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMVELDebugSymbols() throws DroolsParserException {
        MVELDebugHandler.setDebugMode((boolean)true);
        try {
            DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
            PackageDescr pkgDescr = parser.parse((Reader)new InputStreamReader(this.getClass().getResourceAsStream("mvel_rule.drl")));
            Assert.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
            KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.drools");
            RuleDescr ruleDescr = (RuleDescr)pkgDescr.getRules().get(0);
            KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl((InternalKnowledgePackage)pkg);
            DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
            Dialect dialect = dialectRegistry.getDialect("mvel");
            RuleBuildContext context = new RuleBuildContext((DroolsAssemblerContext)pkgBuilder, ruleDescr, dialectRegistry, (InternalKnowledgePackage)pkg, dialect);
            RuleBuilder.build((RuleBuildContext)context);
            Assert.assertTrue((String)context.getErrors().toString(), (boolean)context.getErrors().isEmpty());
            RuleImpl rule = context.getRule();
            MVELConsequence mvelCons = (MVELConsequence)rule.getConsequence();
            mvelCons.compile((MVELDialectRuntimeData)pkgBuilder.getPackageRegistry(pkg.getName()).getDialectRuntimeRegistry().getDialectData("mvel"));
            String s = DebugTools.decompile((Serializable)mvelCons.getCompExpr());
            int fromIndex = 0;
            int count = 0;
            while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
                ++count;
            }
            Assert.assertEquals((long)4L, (long)count);
        }
        finally {
            MVELDebugHandler.setDebugMode((boolean)false);
        }
    }

    @Test
    public void testDebugSymbolCount() {
        String expr = "System.out.println( \"a1\" );\nSystem.out.println( \"a2\" );\nSystem.out.println( \"a3\" );\nSystem.out.println( \"a4\" );\n";
        ParserContext context = new ParserContext();
        context.setDebugSymbols(true);
        context.addImport("System", System.class);
        context.setStrictTypeEnforcement(true);
        context.setSourceFile("mysource");
        ExpressionCompiler compiler = new ExpressionCompiler(expr, context);
        CompiledExpression compiledExpression = compiler.compile();
        String s = DebugTools.decompile((Serializable)compiledExpression);
        System.out.println("s " + s);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        Assert.assertEquals((long)4L, (long)count);
    }

    private void setupTest(String consequence, Map<String, Object> namedConsequences) {
        this.builder = new MVELConsequenceBuilder();
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.drools.mvel.compiler.test");
        pkg.addImport(new ImportDeclaration(Cheese.class.getCanonicalName()));
        KnowledgeBuilderConfigurationImpl conf = new KnowledgeBuilderConfigurationImpl();
        KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl((InternalKnowledgePackage)pkg, conf);
        this.ruleDescr = new RuleDescr("test consequence builder");
        this.ruleDescr.setConsequence((Object)consequence);
        this.ruleDescr.addAttribute(new AttributeDescr("dialect", "mvel"));
        for (Map.Entry<String, Object> entry : namedConsequences.entrySet()) {
            this.ruleDescr.addNamedConsequences(entry.getKey(), entry.getValue());
        }
        RuleImpl rule = new RuleImpl(this.ruleDescr.getName());
        rule.addPattern((RuleConditionElement)new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class), "$cheese"));
        rule.addPattern((RuleConditionElement)new Pattern(0, (ObjectType)new ClassObjectType(Map.class), "$map"));
        PackageRegistry pkgRegistry = pkgBuilder.getPackageRegistry(pkg.getName());
        DialectCompiletimeRegistry reg = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        this.context = new RuleBuildContext((DroolsAssemblerContext)pkgBuilder, this.ruleDescr, reg, (InternalKnowledgePackage)pkg, reg.getDialect(pkgRegistry.getDialect()));
        this.context.getDeclarationResolver().pushOnBuildStack((RuleConditionElement)rule.getLhs());
        this.context.getDialect().getConsequenceBuilder().build(this.context, "default");
        for (String name : namedConsequences.keySet()) {
            this.context.getDialect().getConsequenceBuilder().build(this.context, name);
        }
        this.context.getDialect().addRule(this.context);
        pkgRegistry.getPackage().addRule(this.context.getRule());
        pkgBuilder.compileAll();
        pkgBuilder.reloadAll();
        if (pkgBuilder.hasErrors()) {
            Assert.fail((String)pkgBuilder.getErrors().toString());
        }
    }

    @Test
    public void testDefaultConsequenceCompilation() {
        String consequence = " System.out.println(\"this is a test:\" + $cheese);\n c1 = new Cheese().{ type = $cheese.type };c2 = new Cheese().{ type = $map[$cheese.type] };c3 = new Cheese().{ type = $map['key'] };";
        this.setupTest(consequence, new HashMap<String, Object>());
        Assert.assertNotNull((Object)this.context.getRule().getConsequence());
        Assert.assertFalse((boolean)this.context.getRule().hasNamedConsequences());
        Assert.assertTrue((boolean)(this.context.getRule().getConsequence() instanceof MVELConsequence));
    }

    @Test
    public void testDefaultConsequenceWithSingleNamedConsequenceCompilation() {
        String defaultCon = " System.out.println(\"this is a test\" + $cheese);\n ";
        HashMap<String, Object> namedConsequences = new HashMap<String, Object>();
        String name1 = " System.out.println(\"this is a test name1\" + $cheese);\n ";
        namedConsequences.put("name1", name1);
        this.setupTest(defaultCon, namedConsequences);
        Assert.assertTrue((boolean)(this.context.getRule().getConsequence() instanceof MVELConsequence));
        Assert.assertTrue((boolean)(this.context.getRule().getNamedConsequence("name1") instanceof MVELConsequence));
        Assert.assertNotSame((Object)this.context.getRule().getConsequence(), (Object)this.context.getRule().getNamedConsequence("name1"));
    }

    @Test
    public void testDefaultConsequenceWithMultipleNamedConsequenceCompilation() {
        String defaultCon = " System.out.println(\"this is a test\" + $cheese);\n ";
        HashMap<String, Object> namedConsequences = new HashMap<String, Object>();
        String name1 = " System.out.println(\"this is a test name1\" + $cheese);\n ";
        namedConsequences.put("name1", name1);
        String name2 = " System.out.println(\"this is a test name2\" + $cheese);\n ";
        namedConsequences.put("name2", name2);
        this.setupTest(defaultCon, namedConsequences);
        Assert.assertTrue((boolean)(this.context.getRule().getConsequence() instanceof MVELConsequence));
        Assert.assertTrue((boolean)(this.context.getRule().getNamedConsequence("name1") instanceof MVELConsequence));
        Assert.assertTrue((boolean)(this.context.getRule().getNamedConsequence("name2") instanceof MVELConsequence));
        Assert.assertNotSame((Object)this.context.getRule().getConsequence(), (Object)this.context.getRule().getNamedConsequence("name1"));
        Assert.assertNotSame((Object)this.context.getRule().getConsequence(), (Object)this.context.getRule().getNamedConsequence("name2"));
        Assert.assertNotSame((Object)this.context.getRule().getNamedConsequence("name1"), (Object)this.context.getRule().getNamedConsequence("name2"));
    }

    public static class MockBetaNode
    extends BetaNode {
        public MockBetaNode() {
        }

        protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
            return true;
        }

        MockBetaNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BuildContext buildContext) {
            super(id, leftInput, rightInput, EmptyBetaConstraints.getInstance(), buildContext);
        }

        MockBetaNode(int id, LeftTupleSource leftInput, ObjectSource rightInput) {
            super(id, leftInput, rightInput, EmptyBetaConstraints.getInstance(), null);
        }

        public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        }

        public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public short getType() {
            return 0;
        }

        public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(factHandle, (Sink)this, leftTupleMemoryEnabled);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(leftTuple, sink, pctx, leftTupleMemoryEnabled);
        }

        public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
            return new LeftTupleImpl(factHandle, leftTuple, sink);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
            return new LeftTupleImpl(leftTuple, rightTuple, sink);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
        }

        public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
            return super.createMemory(config, wm);
        }

        public LeftTuple createPeer(LeftTuple original) {
            return null;
        }
    }
}

