/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder.dialect.mvel;

import java.util.HashMap;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.EvalDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockLeftTupleSink;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.Tuple;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.builder.MVELDialect;
import org.drools.mvel.builder.MVELEvalBuilder;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.rule.builder.dialect.mvel.InstrumentedDeclarationScopeResolver;
import org.drools.mvel.expr.MVELEvalExpression;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.rule.FactHandle;

public class MVELEvalBuilderTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testSimpleExpression() {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("pkg1");
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        KnowledgeBuilderImpl pkgBuilder = new KnowledgeBuilderImpl((InternalKnowledgePackage)pkg);
        KnowledgeBuilderConfigurationImpl conf = pkgBuilder.getBuilderConfiguration();
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        RuleBuildContext context = new RuleBuildContext((DroolsAssemblerContext)pkgBuilder, ruleDescr, dialectRegistry, (InternalKnowledgePackage)pkg, (Dialect)mvelDialect);
        InstrumentedDeclarationScopeResolver declarationResolver = new InstrumentedDeclarationScopeResolver();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "price");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Integer.TYPE));
        Declaration declaration = new Declaration("a", (InternalReadAccessor)extractor, pattern);
        HashMap<String, Declaration> map = new HashMap<String, Declaration>();
        map.put("a", declaration);
        declarationResolver.setDeclarations(map);
        context.setDeclarationResolver((DeclarationScopeResolver)declarationResolver);
        EvalDescr evalDescr = new EvalDescr();
        evalDescr.setContent((Object)"a == 10");
        MVELEvalBuilder builder = new MVELEvalBuilder();
        EvalCondition eval = (EvalCondition)builder.build(context, (BaseDescr)evalDescr);
        ((MVELEvalExpression)eval.getEvalExpression()).compile((MVELDialectRuntimeData)pkgBuilder.getPackageRegistry(pkg.getName()).getDialectRuntimeRegistry().getDialectData("mvel"));
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        BuildContext buildContext = new BuildContext(kBase);
        MockLeftTupleSink sink = new MockLeftTupleSink(buildContext);
        MockTupleSource source = new MockTupleSource(1, buildContext);
        source.setObjectCount(1);
        sink.setLeftTupleSource((LeftTupleSource)source);
        Cheese cheddar = new Cheese("cheddar", 10);
        InternalFactHandle f0 = (InternalFactHandle)ksession.insert((Object)cheddar);
        LeftTupleImpl tuple = new LeftTupleImpl(f0, (Sink)sink, true);
        f0.removeLeftTuple((LeftTuple)tuple);
        Object evalContext = eval.createContext();
        Assert.assertTrue((boolean)eval.isAllowed((Tuple)tuple, (ReteEvaluator)ksession, evalContext));
        cheddar.setPrice(9);
        ksession.update((FactHandle)f0, (Object)cheddar);
        Assert.assertFalse((boolean)eval.isAllowed((Tuple)tuple, (ReteEvaluator)ksession, evalContext));
    }
}

