/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.expr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.MvelAccumulator;
import org.drools.core.spi.Tuple;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.expr.MVELCompilationUnit;
import org.drools.mvel.expr.MVELCompileable;
import org.drools.mvel.expr.MvelEvaluator;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.mvel2.integration.VariableResolverFactory;

public class MVELAccumulatorFunctionExecutor
implements MVELCompileable,
Externalizable,
MvelAccumulator {
    private static final long serialVersionUID = 510L;
    private MVELCompilationUnit unit;
    private AccumulateFunction function;
    private MvelEvaluator<Object> evaluator;

    public MVELAccumulatorFunctionExecutor() {
    }

    public MVELAccumulatorFunctionExecutor(MVELCompilationUnit unit, AccumulateFunction function) {
        this.unit = unit;
        this.function = function;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.unit = (MVELCompilationUnit)in.readObject();
        this.function = (AccumulateFunction)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.unit);
        out.writeObject(this.function);
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData) {
        this.evaluator = MvelEvaluator.createMvelEvaluator(this.unit.getCompiledExpression(runtimeData));
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData, RuleImpl rule) {
        this.evaluator = MvelEvaluator.createMvelEvaluator(this.unit.getCompiledExpression(runtimeData, (Object)rule.toRuleNameAndPathString()));
    }

    public Object createContext() {
        return this.function.createContext();
    }

    public Object init(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, ReteEvaluator reteEvaluator) {
        return this.function.initContext((Serializable)context);
    }

    public Object accumulate(Object workingMemoryContext, Object context, Tuple tuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, ReteEvaluator reteEvaluator) {
        VariableResolverFactory factory = this.unit.getFactory(null, null, null, handle, tuple, null, reteEvaluator, reteEvaluator.getGlobalResolver());
        Object value = this.evaluator.evaluate(handle.getObject(), factory);
        return this.function.accumulateValue((Serializable)context, value);
    }

    public boolean tryReverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Object value, Declaration[] declarations, Declaration[] innerDeclarations, ReteEvaluator reteEvaluator) {
        return this.function.tryReverse((Serializable)context, value);
    }

    public Object getResult(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, ReteEvaluator reteEvaluator) {
        try {
            return this.function.getResult((Serializable)context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean supportsReverse() {
        return this.function.supportsReverse();
    }

    public Object createWorkingMemoryContext() {
        return null;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.unit.getPreviousDeclarations();
    }

    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        this.unit.replaceDeclaration(declaration, resolved);
    }
}

