/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.expr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.EvalExpression;
import org.drools.core.spi.Tuple;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.expr.MVELCompilationUnit;
import org.drools.mvel.expr.MVELCompileable;
import org.drools.mvel.expr.MvelEvaluator;
import org.mvel2.integration.VariableResolverFactory;

public class MVELEvalExpression
implements EvalExpression,
MVELCompileable,
Externalizable {
    private static final long serialVersionUID = 510L;
    private MVELCompilationUnit unit;
    private String id;
    private MvelEvaluator<Boolean> evaluator;

    public MVELEvalExpression() {
    }

    public MVELEvalExpression(MVELCompilationUnit unit, String id) {
        this.unit = unit;
        this.id = id;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.unit = (MVELCompilationUnit)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeObject(this.unit);
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData) {
        this.evaluator = MvelEvaluator.createMvelEvaluator(this.unit.getCompiledExpression(runtimeData));
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData, RuleImpl rule) {
        this.evaluator = MvelEvaluator.createMvelEvaluator(this.unit.getCompiledExpression(runtimeData, (Object)rule.toRuleNameAndPathString()));
    }

    public Object createContext() {
        return this.unit.createFactory();
    }

    public boolean evaluate(Tuple tuple, Declaration[] requiredDeclarations, ReteEvaluator reteEvaluator, Object context) throws Exception {
        VariableResolverFactory factory = (VariableResolverFactory)context;
        this.unit.updateFactory(null, tuple, null, reteEvaluator, reteEvaluator.getGlobalResolver(), factory);
        InternalKnowledgePackage pkg = reteEvaluator.getKnowledgeBase().getPackage("MAIN");
        if (pkg != null) {
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData(this.id);
            factory.setNextFactory((VariableResolverFactory)data.getFunctionFactory());
        }
        return this.evaluator.evaluate(factory);
    }

    public String toString() {
        return this.unit.getExpression();
    }

    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        this.unit.replaceDeclaration(declaration, resolved);
    }

    public MVELEvalExpression clone() {
        MVELEvalExpression clone = new MVELEvalExpression(this.unit.clone(), this.id);
        clone.evaluator = this.evaluator;
        return clone;
    }

    public MVELEvalExpression clonePreservingDeclarations(EvalExpression original) {
        MVELCompilationUnit cloneUnit = this.unit.clone();
        cloneUnit.setPreviousDeclarations(((MVELEvalExpression)original).unit.getPreviousDeclarations());
        MVELEvalExpression clone = new MVELEvalExpression(cloneUnit, this.id);
        clone.evaluator = this.evaluator;
        return clone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.evaluator == null) {
            throw new RuntimeException("this MVELPredicateExpression must be compiled for hashCode");
        }
        result = 31 * result + this.unit.getExpression().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.evaluator == null) {
            throw new RuntimeException("this MVELReturnValueExpression must be compiled for equality");
        }
        MVELEvalExpression other = (MVELEvalExpression)obj;
        if (other.evaluator == null) {
            throw new RuntimeException("other MVELReturnValueExpression must be compiled for equality");
        }
        return this.unit.getExpression().equals(other.unit.getExpression());
    }
}

