/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.field;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ValueType;
import org.drools.core.rule.accessor.FieldValue;
import org.drools.mvel.field.FieldFactory;
import org.junit.Test;

public class FieldFactoryTest {
    @Test
    public void testBigDecimal() {
        FieldValue val = FieldFactory.getInstance().getFieldValue((Object)"42.42", ValueType.BIG_DECIMAL_TYPE);
        Assertions.assertThat(val.getValue().getClass()).isEqualTo(BigDecimal.class);
        Assertions.assertThat((boolean)val.getValue().equals(new BigDecimal("42.42"))).isTrue();
    }

    @Test
    public void testBigInteger() {
        FieldValue val = FieldFactory.getInstance().getFieldValue((Object)"424242", ValueType.BIG_INTEGER_TYPE);
        Assertions.assertThat(val.getValue().getClass()).isEqualTo(BigInteger.class);
        Assertions.assertThat((boolean)val.getValue().equals(new BigInteger("424242"))).isTrue();
    }

    @Test
    public void testDate() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);
        String s = df.format(df.parse("10-Jul-1974"));
        FieldValue val = FieldFactory.getInstance().getFieldValue((Object)s, ValueType.DATE_TYPE);
        Assertions.assertThat(val.getValue().getClass()).isEqualTo(Date.class);
        Date dt = (Date)val.getValue();
        Assertions.assertThat((String)df.format(dt)).isEqualTo(s);
    }
}

