/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.base.ValueType;
import org.drools.base.base.extractors.SelfReferenceClassFieldReader;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.GroupElement;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.RuleConditionElement;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.rule.constraint.Constraint;
import org.drools.base.time.Interval;
import org.drools.core.reteoo.builder.BuildUtils;
import org.drools.core.test.model.StockTick;
import org.drools.core.time.TemporalDependencyMatrix;
import org.drools.mvel.EvaluatorConstraint;
import org.drools.mvel.evaluators.AfterEvaluatorDefinition;
import org.junit.Before;
import org.junit.Test;

public class BuildUtilsTest {
    private BuildUtils utils;

    @Before
    public void setUp() throws Exception {
        this.utils = new BuildUtils();
    }

    @Test
    public void testCalculateTemporalDistance() {
        Interval[][] input = new Interval[][]{{new Interval(0L, 0L), new Interval(-2L, 2L), new Interval(-3L, 4L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(Long.MIN_VALUE, Long.MAX_VALUE)}, {new Interval(-2L, 2L), new Interval(0L, 0L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(1L, 2L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE)}, {new Interval(-4L, 3L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(0L, 0L), new Interval(2L, 3L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE)}, {new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(-2L, -1L), new Interval(-3L, -2L), new Interval(0L, 0L), new Interval(1L, 10L)}, {new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(-10L, -1L), new Interval(0L, 0L)}};
        Interval[][] expected = new Interval[][]{{new Interval(0L, 0L), new Interval(-2L, 2L), new Interval(-3L, 2L), new Interval(-1L, 4L), new Interval(0L, 14L)}, {new Interval(-2L, 2L), new Interval(0L, 0L), new Interval(-2L, 0L), new Interval(1L, 2L), new Interval(2L, 12L)}, {new Interval(-2L, 3L), new Interval(0L, 2L), new Interval(0L, 0L), new Interval(2L, 3L), new Interval(3L, 13L)}, {new Interval(-4L, 1L), new Interval(-2L, -1L), new Interval(-3L, -2L), new Interval(0L, 0L), new Interval(1L, 10L)}, {new Interval(-14L, 0L), new Interval(-12L, -2L), new Interval(-13L, -3L), new Interval(-10L, -1L), new Interval(0L, 0L)}};
        AfterEvaluatorDefinition evals = new AfterEvaluatorDefinition();
        ClassObjectType ot = new ClassObjectType(StockTick.class, true);
        Pattern a = new Pattern(0, (ObjectType)ot, "$a");
        Pattern b = new Pattern(1, (ObjectType)ot, "$b");
        b.addConstraint((Constraint)new EvaluatorConstraint(new Declaration[]{a.getDeclaration()}, evals.getEvaluator(ValueType.OBJECT_TYPE, AfterEvaluatorDefinition.AFTER, "-2,2"), (ReadAccessor)new SelfReferenceClassFieldReader(StockTick.class)));
        Pattern c = new Pattern(2, (ObjectType)ot, "$c");
        c.addConstraint((Constraint)new EvaluatorConstraint(new Declaration[]{a.getDeclaration()}, evals.getEvaluator(ValueType.OBJECT_TYPE, AfterEvaluatorDefinition.AFTER, "-3,4"), (ReadAccessor)new SelfReferenceClassFieldReader(StockTick.class)));
        Pattern d = new Pattern(3, (ObjectType)ot, "$d");
        d.addConstraint((Constraint)new EvaluatorConstraint(new Declaration[]{b.getDeclaration()}, evals.getEvaluator(ValueType.OBJECT_TYPE, AfterEvaluatorDefinition.AFTER, "1,2"), (ReadAccessor)new SelfReferenceClassFieldReader(StockTick.class)));
        d.addConstraint((Constraint)new EvaluatorConstraint(new Declaration[]{c.getDeclaration()}, evals.getEvaluator(ValueType.OBJECT_TYPE, AfterEvaluatorDefinition.AFTER, "2,3"), (ReadAccessor)new SelfReferenceClassFieldReader(StockTick.class)));
        Pattern e = new Pattern(4, (ObjectType)ot, "$e");
        e.addConstraint((Constraint)new EvaluatorConstraint(new Declaration[]{d.getDeclaration()}, evals.getEvaluator(ValueType.OBJECT_TYPE, AfterEvaluatorDefinition.AFTER, "1,10"), (ReadAccessor)new SelfReferenceClassFieldReader(StockTick.class)));
        GroupElement not = new GroupElement(GroupElement.Type.NOT);
        not.addChild((RuleConditionElement)e);
        GroupElement and = new GroupElement(GroupElement.Type.AND);
        and.addChild((RuleConditionElement)a);
        and.addChild((RuleConditionElement)b);
        and.addChild((RuleConditionElement)c);
        and.addChild((RuleConditionElement)d);
        and.addChild((RuleConditionElement)not);
        TemporalDependencyMatrix matrix = this.utils.calculateTemporalDistance(and);
        this.assertEqualsMatrix(expected, matrix.getMatrix());
        Assertions.assertThat((long)matrix.getExpirationOffset(a)).isEqualTo(15L);
        Assertions.assertThat((long)matrix.getExpirationOffset(d)).isEqualTo(11L);
        Assertions.assertThat((long)matrix.getExpirationOffset(e)).isEqualTo(1L);
    }

    public void assertEqualsMatrix(Interval[][] expected, Interval[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                ((ObjectAssert)Assertions.assertThat((Object)matrix[i][j]).as("Wrong value at (" + i + ", " + j, new Object[0])).isEqualTo((Object)expected[i][j]);
            }
        }
    }

    public void printMatrix(Interval[][] matrix) {
        System.out.println("------------------------------------------------------------------");
        for (int i = 0; i < matrix.length; ++i) {
            System.out.print("|  ");
            for (int j = 0; j < matrix[i].length; ++j) {
                System.out.print(matrix[i][j] + "  ");
            }
            System.out.println("|");
        }
        System.out.println("------------------------------------------------------------------");
    }
}

