/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder.dialect.java;

import java.util.HashMap;
import java.util.Set;
import org.antlr.runtime.RecognitionException;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.mvel.java.JavaAnalysisResult;
import org.drools.mvel.java.JavaExprAnalyzer;
import org.junit.Test;

public class JavaExprAnalyzerTest {
    @Test
    public void testAnalyzeBlock() {
        JavaExprAnalyzer analyzer = new JavaExprAnalyzer();
        String codeBlock = "int x;\nCheese cheese = new Cheese();\nfor( Iterator it = list.iterator(); it.hasNext(); ) {\n    int shouldNotBeIncluded = 1;\n}\n{\n    String anotherNonTopLevelVar = \"test\";\n}\ndouble thisIsAGoodVar = 0;\nmethod();\n";
        try {
            JavaAnalysisResult analysis = analyzer.analyzeBlock(codeBlock, new BoundIdentifiers(new HashMap(), null));
            Set vars = analysis.getLocalVariables();
            Assertions.assertThat((int)vars.size()).isEqualTo(3);
            Assertions.assertThat((boolean)vars.contains("x")).isTrue();
            Assertions.assertThat((boolean)vars.contains("cheese")).isTrue();
            Assertions.assertThat((boolean)vars.contains("thisIsAGoodVar")).isTrue();
        }
        catch (RecognitionException e) {
            e.printStackTrace();
            Assertions.fail((String)("Not supposed to raise exception: " + e.getMessage()));
        }
    }
}

