/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.rule.GroupElement;
import org.drools.base.rule.GroupElementFactory;
import org.drools.base.rule.InvalidPatternException;
import org.drools.base.rule.InvalidRuleException;
import org.drools.base.rule.LogicTransformer;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.RuleConditionElement;
import org.drools.core.util.DroolsStreamUtils;
import org.junit.Test;

public class LogicTransformerTest {
    @Test
    public void testSingleOrAndOrTransformation() throws InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        GroupElement or = GroupElementFactory.newOrInstance();
        or.addChild((RuleConditionElement)a);
        or.addChild((RuleConditionElement)b);
        GroupElement parent = GroupElementFactory.newAndInstance();
        parent.addChild((RuleConditionElement)or);
        parent.addChild((RuleConditionElement)c);
        LogicTransformer.getInstance().applyOrTransformation(parent);
        Assertions.assertThat((List)parent.getChildren()).hasSize(2);
        Assertions.assertThat(((RuleConditionElement)parent.getChildren().get(0)).getClass()).isEqualTo(GroupElement.class);
        Assertions.assertThat(((RuleConditionElement)parent.getChildren().get(1)).getClass()).isEqualTo(GroupElement.class);
        GroupElement and1 = (GroupElement)parent.getChildren().get(0);
        Assertions.assertThat((boolean)and1.isAnd()).isTrue();
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(0))).isEqualTo((Object)a);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(1))).isEqualTo((Object)c);
        GroupElement and2 = (GroupElement)parent.getChildren().get(1);
        Assertions.assertThat((Object)((RuleConditionElement)and2.getChildren().get(0))).isEqualTo((Object)b);
        Assertions.assertThat((Object)((RuleConditionElement)and2.getChildren().get(1))).isEqualTo((Object)c);
    }

    @Test
    public void testMultipleOrAndOrTransformation() throws InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        Pattern e = new Pattern(4, (ObjectType)type, "e");
        Pattern f = new Pattern(5, (ObjectType)type, "f");
        GroupElement parent = GroupElementFactory.newAndInstance();
        GroupElement or = GroupElementFactory.newOrInstance();
        or.addChild((RuleConditionElement)a);
        or.addChild((RuleConditionElement)b);
        parent.addChild((RuleConditionElement)or);
        parent.addChild((RuleConditionElement)c);
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)d);
        or2.addChild((RuleConditionElement)e);
        parent.addChild((RuleConditionElement)or2);
        GroupElement not = GroupElementFactory.newNotInstance();
        not.addChild((RuleConditionElement)f);
        parent.addChild((RuleConditionElement)not);
        LogicTransformer.getInstance().applyOrTransformation(parent);
        Assertions.assertThat((Comparable)parent.getType()).isEqualTo((Object)GroupElement.Type.OR);
        Assertions.assertThat((List)parent.getChildren()).hasSize(4);
        Assertions.assertThat(((RuleConditionElement)parent.getChildren().get(0)).getClass()).isEqualTo(GroupElement.class);
        Assertions.assertThat(((RuleConditionElement)parent.getChildren().get(1)).getClass()).isEqualTo(GroupElement.class);
        Assertions.assertThat(((RuleConditionElement)parent.getChildren().get(2)).getClass()).isEqualTo(GroupElement.class);
        Assertions.assertThat(((RuleConditionElement)parent.getChildren().get(3)).getClass()).isEqualTo(GroupElement.class);
        GroupElement and1 = (GroupElement)parent.getChildren().get(0);
        Assertions.assertThat((boolean)and1.isAnd()).isTrue();
        Assertions.assertThat((List)and1.getChildren()).hasSize(4);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(0))).isEqualTo((Object)a);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(1))).isEqualTo((Object)c);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(2))).isEqualTo((Object)d);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(3))).isEqualTo((Object)not);
        and1 = (GroupElement)parent.getChildren().get(1);
        Assertions.assertThat((boolean)and1.isAnd()).isTrue();
        Assertions.assertThat((List)and1.getChildren()).hasSize(4);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(0))).isEqualTo((Object)a);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(1))).isEqualTo((Object)c);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(2))).isEqualTo((Object)e);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(3))).isEqualTo((Object)not);
        and1 = (GroupElement)parent.getChildren().get(2);
        Assertions.assertThat((boolean)and1.isAnd()).isTrue();
        Assertions.assertThat((List)and1.getChildren()).hasSize(4);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(0))).isEqualTo((Object)b);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(1))).isEqualTo((Object)c);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(2))).isEqualTo((Object)d);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(3))).isEqualTo((Object)not);
        and1 = (GroupElement)parent.getChildren().get(3);
        Assertions.assertThat((boolean)and1.isAnd()).isTrue();
        Assertions.assertThat((List)and1.getChildren()).hasSize(4);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(0))).isEqualTo((Object)b);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(1))).isEqualTo((Object)c);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(2))).isEqualTo((Object)e);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(3))).isEqualTo((Object)not);
    }

    @Test
    public void testNotOrTransformation() throws InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        GroupElement parent = GroupElementFactory.newNotInstance();
        GroupElement or = GroupElementFactory.newOrInstance();
        parent.addChild((RuleConditionElement)or);
        or.addChild((RuleConditionElement)a);
        or.addChild((RuleConditionElement)b);
        LogicTransformer.getInstance().applyOrTransformation(parent);
        Assertions.assertThat((boolean)parent.isAnd()).isTrue();
        Assertions.assertThat((int)parent.getChildren().size()).isEqualTo(2);
        GroupElement b1 = (GroupElement)parent.getChildren().get(0);
        GroupElement b2 = (GroupElement)parent.getChildren().get(1);
        Assertions.assertThat((boolean)b1.isNot()).isTrue();
        Assertions.assertThat((boolean)b2.isNot()).isTrue();
        Assertions.assertThat((int)b1.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)b1.getChildren().get(0))).isEqualTo((Object)a);
        Assertions.assertThat((int)b2.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)b2.getChildren().get(0))).isEqualTo((Object)b);
    }

    @Test
    public void testNotExistsTransformation() throws InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        GroupElement not = GroupElementFactory.newNotInstance();
        GroupElement exists = GroupElementFactory.newExistsInstance();
        GroupElement and = GroupElementFactory.newAndInstance();
        not.addChild((RuleConditionElement)exists);
        exists.addChild((RuleConditionElement)and);
        and.addChild((RuleConditionElement)a);
        and.addChild((RuleConditionElement)b);
        GroupElement[] transformed = LogicTransformer.getInstance().transform(not, Collections.EMPTY_MAP);
        GroupElement wrapper = transformed[0];
        GroupElement notR = (GroupElement)wrapper.getChildren().get(0);
        Assertions.assertThat((boolean)notR.isNot()).isTrue();
        Assertions.assertThat((int)notR.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((boolean)(notR.getChildren().get(0) instanceof GroupElement)).isTrue();
        GroupElement andR = (GroupElement)notR.getChildren().get(0);
        Assertions.assertThat((boolean)andR.isAnd()).isTrue();
        Assertions.assertThat((int)andR.getChildren().size()).isEqualTo(2);
        Assertions.assertThat((boolean)(andR.getChildren().get(0) instanceof Pattern)).isTrue();
        Assertions.assertThat((boolean)(andR.getChildren().get(1) instanceof Pattern)).isTrue();
        Pattern a1 = (Pattern)andR.getChildren().get(0);
        Pattern b1 = (Pattern)andR.getChildren().get(1);
        Assertions.assertThat((Object)a1).isEqualTo((Object)a);
        Assertions.assertThat((Object)b1).isEqualTo((Object)b);
    }

    @Test
    public void testExistOrTransformation() throws InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        GroupElement parent = GroupElementFactory.newExistsInstance();
        GroupElement or = GroupElementFactory.newOrInstance();
        parent.addChild((RuleConditionElement)or);
        or.addChild((RuleConditionElement)a);
        or.addChild((RuleConditionElement)b);
        LogicTransformer.getInstance().applyOrTransformation(parent);
        Assertions.assertThat((boolean)parent.isNot()).isTrue();
        Assertions.assertThat((int)parent.getChildren().size()).isEqualTo(1);
        GroupElement and = (GroupElement)parent.getChildren().get(0);
        Assertions.assertThat((boolean)and.isAnd()).isTrue();
        Assertions.assertThat((int)and.getChildren().size()).isEqualTo(2);
        GroupElement b1 = (GroupElement)and.getChildren().get(0);
        GroupElement b2 = (GroupElement)and.getChildren().get(1);
        Assertions.assertThat((boolean)b1.isNot()).isTrue();
        Assertions.assertThat((boolean)b2.isNot()).isTrue();
        Assertions.assertThat((int)b1.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)b1.getChildren().get(0))).isEqualTo((Object)a);
        Assertions.assertThat((int)b2.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)b2.getChildren().get(0))).isEqualTo((Object)b);
    }

    @Test
    public void testEliminateEmptyBranchesAndDuplications() throws InvalidRuleException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)a);
        and1.addChild((RuleConditionElement)b);
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)c);
        and2.addChild((RuleConditionElement)d);
        and1.addChild((RuleConditionElement)and2);
        GroupElement or = GroupElementFactory.newOrInstance();
        and1.addChild((RuleConditionElement)or);
        Object[] result = LogicTransformer.getInstance().transform(and1, Collections.EMPTY_MAP);
        Assertions.assertThat((Object[])result).hasSize(1);
        Assertions.assertThat((List)result[0].getChildren()).hasSize(4);
        Assertions.assertThat((Object)((RuleConditionElement)result[0].getChildren().get(0))).isEqualTo((Object)a);
        Assertions.assertThat((Object)((RuleConditionElement)result[0].getChildren().get(1))).isEqualTo((Object)b);
        Assertions.assertThat((Object)((RuleConditionElement)result[0].getChildren().get(2))).isEqualTo((Object)c);
        Assertions.assertThat((Object)((RuleConditionElement)result[0].getChildren().get(3))).isEqualTo((Object)d);
    }

    @Test
    public void testProcessTree() throws IOException, ClassNotFoundException, InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        Pattern e = new Pattern(4, (ObjectType)type, "e");
        Pattern g = new Pattern(5, (ObjectType)type, "g");
        Pattern h = new Pattern(6, (ObjectType)type, "h");
        Pattern i = new Pattern(7, (ObjectType)type, "i");
        GroupElement and1 = GroupElementFactory.newAndInstance();
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)a);
        and1.addChild((RuleConditionElement)and2);
        and2.addChild((RuleConditionElement)b);
        GroupElement not1 = GroupElementFactory.newNotInstance();
        GroupElement not2 = GroupElementFactory.newNotInstance();
        not1.addChild((RuleConditionElement)not2);
        not2.addChild((RuleConditionElement)c);
        and2.addChild((RuleConditionElement)not1);
        and1.addChild((RuleConditionElement)d);
        GroupElement and3 = GroupElementFactory.newAndInstance();
        and3.addChild((RuleConditionElement)e);
        GroupElement or1 = GroupElementFactory.newOrInstance();
        and3.addChild((RuleConditionElement)or1);
        GroupElement exist1 = GroupElementFactory.newExistsInstance();
        exist1.addChild((RuleConditionElement)g);
        or1.addChild((RuleConditionElement)h);
        or1.addChild((RuleConditionElement)exist1);
        GroupElement not3 = GroupElementFactory.newNotInstance();
        not3.addChild((RuleConditionElement)i);
        GroupElement root = GroupElementFactory.newAndInstance();
        root.addChild((RuleConditionElement)and1);
        root.addChild((RuleConditionElement)and3);
        root.addChild((RuleConditionElement)not3);
        GroupElement[] result = LogicTransformer.getInstance().transform(root, Collections.EMPTY_MAP);
        File testFile = new File("target/test/LogicTransformerTest_correct_processTree1.dat");
        testFile.getParentFile().mkdirs();
        DroolsStreamUtils.streamOut((OutputStream)new FileOutputStream(testFile), (Object)result);
        GroupElement[] correctResultRoot = (GroupElement[])DroolsStreamUtils.streamIn((InputStream)new FileInputStream(testFile));
        for (int j = 0; j < correctResultRoot.length; ++j) {
            Assertions.assertThat((Object)result[j]).isEqualTo((Object)correctResultRoot[j]);
        }
    }

    @Test
    public void testCloneable() {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        Pattern e = new Pattern(4, (ObjectType)type, "e");
        Pattern f = new Pattern(5, (ObjectType)type, "f");
        Pattern g = new Pattern(6, (ObjectType)type, "g");
        Pattern h = new Pattern(7, (ObjectType)type, "h");
        GroupElement and = GroupElementFactory.newAndInstance();
        and.addChild((RuleConditionElement)a);
        and.addChild((RuleConditionElement)b);
        GroupElement or = GroupElementFactory.newOrInstance();
        or.addChild((RuleConditionElement)c);
        or.addChild((RuleConditionElement)d);
        and.addChild((RuleConditionElement)or);
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)e);
        and2.addChild((RuleConditionElement)f);
        or.addChild((RuleConditionElement)and2);
        GroupElement not = GroupElementFactory.newNotInstance();
        and.addChild((RuleConditionElement)not);
        GroupElement or2 = GroupElementFactory.newOrInstance();
        not.addChild((RuleConditionElement)or2);
        or2.addChild((RuleConditionElement)g);
        or2.addChild((RuleConditionElement)h);
        GroupElement cloned = and.clone();
        Assertions.assertThat((Object)cloned).isEqualTo((Object)and);
    }

    @Test
    public void testTransform() throws IOException, ClassNotFoundException, InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        Pattern e = new Pattern(4, (ObjectType)type, "e");
        Pattern f = new Pattern(5, (ObjectType)type, "f");
        Pattern g = new Pattern(6, (ObjectType)type, "g");
        Pattern h = new Pattern(7, (ObjectType)type, "h");
        GroupElement and = GroupElementFactory.newAndInstance();
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)a);
        GroupElement or1 = GroupElementFactory.newOrInstance();
        or1.addChild((RuleConditionElement)b);
        or1.addChild((RuleConditionElement)c);
        and1.addChild((RuleConditionElement)or1);
        and.addChild((RuleConditionElement)and1);
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)d);
        or2.addChild((RuleConditionElement)e);
        and.addChild((RuleConditionElement)or2);
        GroupElement and2 = GroupElementFactory.newAndInstance();
        GroupElement not1 = GroupElementFactory.newNotInstance();
        not1.addChild((RuleConditionElement)f);
        GroupElement or3 = GroupElementFactory.newOrInstance();
        or3.addChild((RuleConditionElement)g);
        GroupElement not2 = GroupElementFactory.newNotInstance();
        not2.addChild((RuleConditionElement)h);
        or3.addChild((RuleConditionElement)not2);
        and2.addChild((RuleConditionElement)not1);
        and2.addChild((RuleConditionElement)or3);
        and.addChild((RuleConditionElement)and2);
        GroupElement[] ands = LogicTransformer.getInstance().transform(and, Collections.EMPTY_MAP);
        File testFile = new File("target/test/LogicTransformerTest_correct_transform1.dat");
        testFile.getParentFile().mkdirs();
        DroolsStreamUtils.streamOut((OutputStream)new FileOutputStream(testFile), (Object)ands);
        GroupElement[] correctResultAnds = (GroupElement[])DroolsStreamUtils.streamIn((InputStream)new FileInputStream(testFile));
        for (int j = 0; j < ands.length; ++j) {
            Assertions.assertThat((Object)ands[j]).isEqualTo((Object)correctResultAnds[j]);
        }
    }
}

