/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.osgi;

import javax.persistence.Persistence;
import javax.persistence.spi.PersistenceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ProviderTrackerCustomizer
implements ServiceTrackerCustomizer {
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PersistenceProvider";
    private BundleContext ctx;

    public ProviderTrackerCustomizer(BundleContext context) {
        this.ctx = context;
    }

    public Object addingService(ServiceReference reference) {
        this.log("New service detected...");
        String providerName = this.getProviderName(reference);
        PersistenceProvider provider = (PersistenceProvider)this.ctx.getService(reference);
        Persistence.addProvider(provider);
        this.log("Added service " + providerName);
        return provider;
    }

    public void modifiedService(ServiceReference reference, Object serviceObject) {
        this.removedService(reference, serviceObject);
    }

    public void removedService(ServiceReference reference, Object serviceObject) {
        this.log("Removing service...");
        String providerName = this.getProviderName(reference);
        Persistence.removeProvider(providerName);
        this.log("Removed service " + providerName + " service object: " + serviceObject);
    }

    private String getProviderName(ServiceReference ref) {
        String providerName = (String)ref.getProperty(PERSISTENCE_PROVIDER);
        if (providerName == null) {
            System.out.println("Provider service registered without name property");
            throw new RuntimeException("Provider service registered without name property");
        }
        return providerName;
    }

    private void log(String message) {
        System.out.println("ProviderTracker: " + message);
    }
}

