/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.ftp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.h2.constant.SysProperties;
import org.h2.server.Service;
import org.h2.server.ftp.FtpControl;
import org.h2.server.ftp.FtpEventListener;
import org.h2.store.fs.FileSystem;
import org.h2.tools.Server;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;

public class FtpServer
implements Service {
    public static final String DEFAULT_ROOT = "ftp";
    public static final String DEFAULT_READ = "guest";
    public static final String DEFAULT_WRITE = "sa";
    public static final String DEFAULT_WRITE_PASSWORD = "sa";
    private ServerSocket serverSocket;
    private int port = 8021;
    private int openConnectionCount;
    private int maxConnectionCount = 100;
    private SimpleDateFormat dateFormatNew = new SimpleDateFormat("MMM dd HH:mm", Locale.ENGLISH);
    private SimpleDateFormat dateFormatOld = new SimpleDateFormat("MMM dd  yyyy", Locale.ENGLISH);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private String root = "ftp";
    private String writeUserName = "sa";
    private String writePassword = "sa";
    private String readUserName = "guest";
    private HashMap tasks = new HashMap();
    private FileSystem fs;
    private boolean trace;
    private boolean allowTask;
    static final String TASK_SUFFIX = ".task";
    private FtpEventListener eventListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen() {
        try {
            while (this.serverSocket != null) {
                boolean bl;
                Socket socket = this.serverSocket.accept();
                Object object = this;
                synchronized (object) {
                    ++this.openConnectionCount;
                    bl = this.openConnectionCount > this.maxConnectionCount;
                }
                object = new FtpControl(socket, this, bl);
                ((Thread)object).start();
            }
        }
        catch (Exception exception) {
            this.traceError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeConnection() {
        FtpServer ftpServer = this;
        synchronized (ftpServer) {
            --this.openConnectionCount;
        }
    }

    public ServerSocket createDataSocket() throws SQLException {
        ServerSocket serverSocket = NetUtils.createServerSocket(0, false);
        return serverSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendFile(StringBuffer stringBuffer, String string) throws SQLException {
        String string2;
        stringBuffer.append(this.fs.isDirectory(string) ? (char)'d' : '-');
        stringBuffer.append('r');
        stringBuffer.append(this.fs.canWrite(string) ? (char)'w' : '-');
        stringBuffer.append("------- 1 owner group ");
        String string3 = String.valueOf(this.fs.length(string));
        for (int i = string3.length(); i < 15; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string3);
        stringBuffer.append(' ');
        Date date = new Date();
        Date date2 = new Date(this.fs.getLastModified(string));
        if (date2.after(date) || Math.abs((date.getTime() - date2.getTime()) / 1000L / 60L / 60L / 24L) > 180L) {
            SimpleDateFormat simpleDateFormat = this.dateFormatOld;
            synchronized (simpleDateFormat) {
                string2 = this.dateFormatOld.format(date2);
            }
        }
        SimpleDateFormat simpleDateFormat = this.dateFormatNew;
        synchronized (simpleDateFormat) {
            string2 = this.dateFormatNew.format(date2);
        }
        stringBuffer.append(string2);
        stringBuffer.append(' ');
        stringBuffer.append(FileUtils.getFileName(string));
        stringBuffer.append("\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String formatLastModified(String string) {
        SimpleDateFormat simpleDateFormat = this.dateFormat;
        synchronized (simpleDateFormat) {
            return this.dateFormat.format(new Date(this.fs.getLastModified(string)));
        }
    }

    String getFileName(String string) {
        return this.root + this.getPath(string);
    }

    String getPath(String string) {
        if (string.indexOf("..") > 0) {
            string = "/";
        }
        while (string.startsWith("/") && this.root.endsWith("/")) {
            string = string.substring(1);
        }
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        this.trace("path: " + string);
        return string;
    }

    String getDirectoryListing(String string, boolean bl) throws SQLException {
        String[] stringArray = this.fs.listFiles(string);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (this.fs.isDirectory(string2) && (!this.fs.isDirectory(string2) || !bl)) continue;
            this.appendFile(stringBuffer, string2);
        }
        return stringBuffer.toString();
    }

    public boolean checkUserPassword(String string, String string2) {
        return string.equals(this.writeUserName) && string2.equals(this.writePassword);
    }

    public boolean checkUserPasswordReadOnly(String string, String string2) {
        return string.equals(this.readUserName);
    }

    public void init(String[] stringArray) throws Exception {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ("-ftpPort".equals(string)) {
                this.port = MathUtils.decodeInt(stringArray[++i]);
                continue;
            }
            if ("-ftpDir".equals(string)) {
                this.root = FileUtils.normalize(stringArray[++i]);
                continue;
            }
            if ("-ftpRead".equals(string)) {
                this.readUserName = stringArray[++i];
                continue;
            }
            if ("-ftpWrite".equals(string)) {
                this.writeUserName = stringArray[++i];
                continue;
            }
            if ("-ftpWritePassword".equals(string)) {
                this.writePassword = stringArray[++i];
                continue;
            }
            if ("-trace".equals(string)) {
                this.trace = true;
                continue;
            }
            if ("-log".equals(string) && SysProperties.OLD_COMMAND_LINE_OPTIONS) {
                this.trace = Server.readArgBoolean(stringArray, i) == 1;
                ++i;
                continue;
            }
            if (!"-ftpTask".equals(string)) continue;
            this.allowTask = true;
        }
        this.fs = FileSystem.getInstance(this.root);
        this.root = this.fs.normalize(this.root);
    }

    public String getURL() {
        return "ftp://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    public void start() throws SQLException {
        this.fs.mkdirs(this.root);
        this.serverSocket = NetUtils.createServerSocket(this.port, false);
    }

    public void stop() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            this.traceError(iOException);
        }
        this.serverSocket = null;
    }

    public boolean isRunning(boolean bl) {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket socket = NetUtils.createLoopbackSocket(this.port, false);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                this.traceError(exception);
            }
            return false;
        }
    }

    public boolean getAllowOthers() {
        return true;
    }

    public String getType() {
        return "FTP";
    }

    public String getName() {
        return "H2 FTP Server";
    }

    void trace(String string) {
        if (this.trace) {
            System.out.println(string);
        }
    }

    void traceError(Throwable throwable) {
        if (this.trace) {
            throwable.printStackTrace();
        }
    }

    public boolean getAllowTask() {
        return this.allowTask;
    }

    void startTask(String string) throws IOException {
        this.stopTask(string);
        if (string.endsWith(".zip.task")) {
            this.trace("expand: " + string);
            Process process = Runtime.getRuntime().exec("jar -xf " + string, null, new File(this.root));
            new StreamRedirect(string, process.getInputStream(), null).start();
            return;
        }
        Properties properties = FileUtils.loadProperties(string);
        String string2 = properties.getProperty("command");
        String string3 = string.substring(0, string.length() - TASK_SUFFIX.length());
        String string4 = this.root + "/" + properties.getProperty("error", string3 + ".err.txt");
        String string5 = this.root + "/" + properties.getProperty("output", string3 + ".out.txt");
        this.trace("start process: " + string + " / " + string2);
        Process process = Runtime.getRuntime().exec(string2, null, new File(this.root));
        new StreamRedirect(string, process.getErrorStream(), string4).start();
        new StreamRedirect(string, process.getInputStream(), string5).start();
        this.tasks.put(string, process);
    }

    void stopTask(String string) {
        this.trace("kill process: " + string);
        Process process = (Process)this.tasks.remove(string);
        if (process == null) {
            return;
        }
        process.destroy();
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public void setEventListener(FtpEventListener ftpEventListener) {
        this.eventListener = ftpEventListener;
    }

    public FtpEventListener getEventListener() {
        return this.eventListener;
    }

    private static class StreamRedirect
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private String outFile;
        private String processFile;

        StreamRedirect(String string, InputStream inputStream, String string2) {
            this.processFile = string;
            this.in = inputStream;
            this.outFile = string2;
        }

        private void openOutput() {
            if (this.outFile != null) {
                try {
                    this.out = FileUtils.openFileOutputStream(this.outFile, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.outFile = null;
            }
        }

        public void run() {
            while (true) {
                try {
                    int n;
                    while ((n = this.in.read()) >= 0) {
                        this.openOutput();
                        if (this.out == null) continue;
                        this.out.write(n);
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
            IOUtils.closeSilently(this.out);
            IOUtils.closeSilently(this.in);
            new File(this.processFile).delete();
        }
    }
}

